/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.dateiaustausch.PeerToPeerAnwendung;
import filius.software.system.Datei;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class GUIApplicationPeerToPeerAnwendungWindow
extends GUIApplicationWindow {
    private boolean pruefungOK = true;
    private boolean zahlOK = true;
    private JPanel mainPanel;
    private JPanel networkPanel;
    private JPanel searchPanel;
    private JLabel networkIpLabel;
    private JButton networkIpButton;
    private JTextField networkIpField;
    private JLabel searchLabel;
    private JButton searchButton;
    private JButton downloadButton;
    private JButton stopSearchButton;
    private JButton emptyListButton;
    private JTextField searchField;
    private JTable netzwerkTabelle;
    private JTable ergebnisTabelle;
    private JTable dateiTabelle;
    private JPanel filePanel;
    private JLabel filePanelLabel;
    private JLabel maxClientsLabel;
    private JTextField maxClientsField;
    private JPanel configPanel;
    private JLabel tabHead;

    public GUIApplicationPeerToPeerAnwendungWindow(final GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.mainPanel = new JPanel(new BorderLayout());
        this.networkPanel = new JPanel(new BorderLayout());
        this.networkIpLabel = new JLabel(messages.getString("peertopeeranwendung_msg1"));
        this.networkIpButton = new JButton(messages.getString("peertopeeranwendung_msg2"));
        this.networkIpButton.setToolTipText(messages.getString("peertopeeranwendung_msg3"));
        this.tabHead = new JLabel(messages.getString("peertopeeranwendung_msg4"));
        this.networkIpField = new JTextField("192.168.0.1");
        this.networkIpField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationPeerToPeerAnwendungWindow.this.ipPruefen(GUIApplicationPeerToPeerAnwendungWindow.this.networkIpField);
            }
        });
        this.networkIpButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (GUIApplicationPeerToPeerAnwendungWindow.this.pruefungOK) {
                    ((PeerToPeerAnwendung)GUIApplicationPeerToPeerAnwendungWindow.this.holeAnwendung()).beitretenNetzwerk(GUIApplicationPeerToPeerAnwendungWindow.this.networkIpField.getText());
                } else {
                    JOptionPane.showMessageDialog(desktop, I18n.messages.getString("peertopeeranwendung_msg5"));
                }
            }
        });
        DefaultTableModel neuesTabellenModell = new DefaultTableModel(0, 2);
        this.netzwerkTabelle = new JTable(neuesTabellenModell);
        this.netzwerkTabelle.setEnabled(false);
        this.netzwerkTabelle.setIntercellSpacing(new Dimension(10, 10));
        this.netzwerkTabelle.setRowHeight(30);
        this.netzwerkTabelle.setShowGrid(false);
        this.netzwerkTabelle.setFillsViewportHeight(true);
        this.netzwerkTabelle.setBackground(Color.WHITE);
        this.netzwerkTabelle.setShowHorizontalLines(true);
        TableColumnModel tcm = this.netzwerkTabelle.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("peertopeeranwendung_msg6"));
        tcm.getColumn(0).setPreferredWidth(20);
        tcm.getColumn(1).setHeaderValue(messages.getString("peertopeeranwendung_msg7"));
        tcm.getColumn(1).setPreferredWidth(300);
        JScrollPane tabellenScrollPane = new JScrollPane(this.netzwerkTabelle);
        neuesTabellenModell = new DefaultTableModel(0, 3);
        this.ergebnisTabelle = new JTable(neuesTabellenModell);
        this.ergebnisTabelle.setDragEnabled(false);
        this.ergebnisTabelle.setIntercellSpacing(new Dimension(10, 10));
        this.ergebnisTabelle.setRowHeight(30);
        this.ergebnisTabelle.setShowGrid(false);
        this.ergebnisTabelle.setFillsViewportHeight(true);
        this.ergebnisTabelle.setBackground(Color.WHITE);
        this.ergebnisTabelle.setShowHorizontalLines(true);
        this.ergebnisTabelle.setSelectionMode(0);
        tcm = this.ergebnisTabelle.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("peertopeeranwendung_msg8"));
        tcm.getColumn(0).setPreferredWidth(200);
        tcm.getColumn(1).setHeaderValue(messages.getString("peertopeeranwendung_msg9"));
        tcm.getColumn(1).setPreferredWidth(200);
        tcm.getColumn(2).setHeaderValue(messages.getString("peertopeeranwendung_msg10"));
        tcm.getColumn(2).setPreferredWidth(50);
        JScrollPane tabellenScrollPaneErgebnis = new JScrollPane(this.ergebnisTabelle);
        Box verticalTopBox = Box.createVerticalBox();
        Box topBox = Box.createHorizontalBox();
        topBox.add(this.networkIpLabel);
        topBox.add(Box.createHorizontalStrut(5));
        topBox.add(this.networkIpField);
        topBox.add(Box.createHorizontalStrut(15));
        topBox.add(this.networkIpButton);
        topBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box labelBox = Box.createHorizontalBox();
        labelBox.add(this.tabHead);
        verticalTopBox.add(topBox);
        verticalTopBox.add(Box.createVerticalStrut(5));
        verticalTopBox.add(this.tabHead);
        this.networkPanel.add((Component)verticalTopBox, "North");
        this.networkPanel.add((Component)tabellenScrollPane, "Center");
        tabbedPane.addTab("Netzwerk", new ImageIcon(this.getClass().getResource("/gfx/desktop/peertopeer_netzwerk_klein.png")), this.networkPanel);
        this.searchPanel = new JPanel(new BorderLayout());
        this.searchLabel = new JLabel(messages.getString("peertopeeranwendung_msg11"));
        this.searchField = new JTextField();
        this.searchField.setToolTipText(messages.getString("peertopeeranwendung_msg12"));
        this.searchButton = new JButton(messages.getString("peertopeeranwendung_msg13"));
        this.searchButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((PeerToPeerAnwendung)GUIApplicationPeerToPeerAnwendungWindow.this.holeAnwendung()).sucheDatei(GUIApplicationPeerToPeerAnwendungWindow.this.searchField.getText());
            }
        });
        this.stopSearchButton = new JButton(messages.getString("peertopeeranwendung_msg14"));
        this.stopSearchButton.setToolTipText(messages.getString("peertopeeranwendung_msg15"));
        this.stopSearchButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((PeerToPeerAnwendung)GUIApplicationPeerToPeerAnwendungWindow.this.holeAnwendung()).abbrechenSuche();
            }
        });
        this.emptyListButton = new JButton(messages.getString("peertopeeranwendung_msg16"));
        this.emptyListButton.setToolTipText(messages.getString("peertopeeranwendung_msg17"));
        this.emptyListButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((PeerToPeerAnwendung)GUIApplicationPeerToPeerAnwendungWindow.this.holeAnwendung()).loescheSuchergebnisse();
                GUIApplicationPeerToPeerAnwendungWindow.this.updateErgebnisTabelle();
            }
        });
        this.downloadButton = new JButton(messages.getString("peertopeeranwendung_msg18"));
        this.downloadButton.setToolTipText(messages.getString("peertopeeranwendung_msg19"));
        this.downloadButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int zeilenNummer = GUIApplicationPeerToPeerAnwendungWindow.this.ergebnisTabelle.getSelectedRow();
                if (zeilenNummer > -1) {
                    ((PeerToPeerAnwendung)GUIApplicationPeerToPeerAnwendungWindow.this.holeAnwendung()).herunterladenDatei(zeilenNummer);
                }
            }
        });
        Box searchBox = Box.createHorizontalBox();
        searchBox.add(this.searchLabel);
        searchBox.add(Box.createHorizontalStrut(5));
        searchBox.add(this.searchField);
        searchBox.add(Box.createHorizontalStrut(5));
        searchBox.add(this.searchButton);
        searchBox.add(Box.createHorizontalStrut(2));
        searchBox.add(this.stopSearchButton);
        searchBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box downloadBox = Box.createHorizontalBox();
        downloadBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        downloadBox.add(this.downloadButton);
        downloadBox.add(Box.createHorizontalStrut(5));
        downloadBox.add(this.emptyListButton);
        this.searchPanel.add((Component)searchBox, "North");
        this.searchPanel.add((Component)tabellenScrollPaneErgebnis, "Center");
        this.searchPanel.add((Component)downloadBox, "South");
        tabbedPane.addTab(messages.getString("peertopeeranwendung_msg20"), new ImageIcon(this.getClass().getResource("/gfx/desktop/peertopeer_suchen_klein.png")), this.searchPanel);
        this.filePanel = new JPanel(new BorderLayout());
        this.filePanelLabel = new JLabel(messages.getString("peertopeeranwendung_msg21"));
        DefaultTableModel dateiTabellenModell = new DefaultTableModel(0, 2);
        this.dateiTabelle = new JTable(dateiTabellenModell);
        this.dateiTabelle.setDragEnabled(false);
        this.dateiTabelle.setEnabled(false);
        this.dateiTabelle.setIntercellSpacing(new Dimension(10, 10));
        this.dateiTabelle.setRowHeight(30);
        this.dateiTabelle.setShowGrid(false);
        this.dateiTabelle.setFillsViewportHeight(true);
        this.dateiTabelle.setBackground(Color.WHITE);
        this.dateiTabelle.setShowHorizontalLines(true);
        tcm = this.dateiTabelle.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("peertopeeranwendung_msg22"));
        tcm.getColumn(0).setPreferredWidth(300);
        tcm.getColumn(1).setHeaderValue(messages.getString("peertopeeranwendung_msg23"));
        tcm.getColumn(1).setPreferredWidth(50);
        JScrollPane dateiScrollPane = new JScrollPane(this.dateiTabelle);
        this.updateDateiTabelle();
        Box dateiBox = Box.createHorizontalBox();
        dateiBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        dateiBox.add(this.filePanelLabel);
        this.filePanel.add((Component)dateiBox, "North");
        this.filePanel.add((Component)dateiScrollPane, "Center");
        tabbedPane.addTab(messages.getString("peertopeeranwendung_msg24"), new ImageIcon(this.getClass().getResource("/gfx/desktop/peertopeer_dateien_klein.png")), this.filePanel);
        this.configPanel = new JPanel(new BorderLayout());
        this.maxClientsLabel = new JLabel(messages.getString("peertopeeranwendung_msg25"));
        this.maxClientsField = new JTextField("" + ((PeerToPeerAnwendung)this.holeAnwendung()).getMaxTeilnehmerZahl());
        this.maxClientsField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationPeerToPeerAnwendungWindow.this.zahlPruefen(GUIApplicationPeerToPeerAnwendungWindow.this.maxClientsField);
            }
        });
        JButton maxClientButton = new JButton(messages.getString("peertopeeranwendung_msg26"));
        maxClientButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (GUIApplicationPeerToPeerAnwendungWindow.this.zahlOK) {
                    ((PeerToPeerAnwendung)GUIApplicationPeerToPeerAnwendungWindow.this.holeAnwendung()).setMaxTeilnehmerZahl(Integer.parseInt(GUIApplicationPeerToPeerAnwendungWindow.this.maxClientsField.getText()));
                } else {
                    JOptionPane.showMessageDialog(desktop, I18n.messages.getString("peertopeeranwendung_msg27"));
                }
            }
        });
        Box configBox = Box.createHorizontalBox();
        configBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        configBox.add(this.maxClientsLabel);
        configBox.add(Box.createHorizontalStrut(10));
        configBox.add(this.maxClientsField);
        configBox.add(Box.createHorizontalStrut(10));
        configBox.add(maxClientButton);
        this.configPanel.add((Component)configBox, "North");
        tabbedPane.addTab(messages.getString("peertopeeranwendung_msg28"), new ImageIcon(this.getClass().getResource("/gfx/desktop/peertopeer_einstellungen.png")), this.configPanel);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GUIApplicationPeerToPeerAnwendungWindow.this.updateDateiTabelle();
                GUIApplicationPeerToPeerAnwendungWindow.this.updateErgebnisTabelle();
                GUIApplicationPeerToPeerAnwendungWindow.this.updateNetzwerkTabelle();
            }
        });
        this.mainPanel.add((Component)tabbedPane, "Center");
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.updateNetzwerkTabelle();
        this.updateErgebnisTabelle();
        this.updateDateiTabelle();
    }

    public void updateDateiTabelle() {
        DefaultTableModel tabellenModell = (DefaultTableModel)this.dateiTabelle.getModel();
        tabellenModell.setRowCount(0);
        List<Datei> tempListe = this.holeAnwendung().getSystemSoftware().getDateisystem().holeDateien(((PeerToPeerAnwendung)this.holeAnwendung()).holeVerzeichnis());
        for (Datei tmpDatei : tempListe) {
            Vector<String> v = new Vector<String>();
            v.add(tmpDatei.getName());
            v.add(tmpDatei.getDateiTyp());
            tabellenModell.addRow(v);
        }
    }

    public void updateNetzwerkTabelle() {
        DefaultTableModel tabellenModell = (DefaultTableModel)this.netzwerkTabelle.getModel();
        tabellenModell.setRowCount(0);
        LinkedList<String> tempListe = ((PeerToPeerAnwendung)this.holeAnwendung()).holeBekanntePeerToPeerTeilnehmer();
        int zaehler = 0;
        for (String ip : tempListe) {
            Vector<Object> v = new Vector<Object>();
            v.add(++zaehler);
            v.add(ip);
            tabellenModell.addRow(v);
        }
    }

    public void updateErgebnisTabelle() {
        DefaultTableModel tabellenModell = (DefaultTableModel)this.ergebnisTabelle.getModel();
        tabellenModell.setRowCount(0);
        LinkedList<String> tempListe = ((PeerToPeerAnwendung)this.holeAnwendung()).holeErgebnisse();
        for (String ergebnis : tempListe) {
            Vector<String> v = new Vector<String>();
            StringTokenizer tempTokenizer = new StringTokenizer(ergebnis, "/");
            v.add(tempTokenizer.nextToken());
            String tmp = tempTokenizer.nextToken();
            v.add(tmp.substring(0, tmp.lastIndexOf(":")));
            v.add(tmp.substring(tmp.lastIndexOf(":") + 1));
            tabellenModell.addRow(v);
        }
    }

    public void ipPruefen(JTextField feld) {
        if (EingabenUeberpruefung.isGueltig(feld.getText(), EingabenUeberpruefung.musterIpAdresse)) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            this.pruefungOK = true;
        } else {
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
            this.pruefungOK = false;
        }
    }

    public void zahlPruefen(JTextField feld) {
        if (EingabenUeberpruefung.isGueltig(feld.getText(), EingabenUeberpruefung.musterNurZahlen)) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            this.zahlOK = true;
        } else {
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
            this.zahlOK = false;
        }
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        this.updateDateiTabelle();
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        this.setVisible(false);
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        this.setVisible(false);
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
        this.updateDateiTabelle();
    }

    public void internalFrameIconified(InternalFrameEvent e) {
        this.updateDateiTabelle();
    }

    public void internalFrameOpened(InternalFrameEvent e) {
        this.updateDateiTabelle();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.updateNetzwerkTabelle();
        this.updateErgebnisTabelle();
        this.updateDateiTabelle();
    }
}

