/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.Main;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.Anwendung;
import filius.software.system.Betriebssystem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class GUIInstallationsDialog
extends JInternalFrame
implements I18n {
    private static final long serialVersionUID = 1L;
    private Container c = this.getContentPane();
    private JList softwareInstalliert;
    private JList softwareVerfuegbar;
    private JButton removeButton;
    private JButton addButton;
    private JButton confirmButton;
    private JLabel titleInstalled;
    private JLabel titleAvailable;
    private DefaultListModel lmVerfuegbar;
    private DefaultListModel lmInstalliert;
    private GUIDesktopPanel dp;
    private List<Map<String, String>> programme = null;

    public GUIInstallationsDialog(GUIDesktopPanel dp) {
        this.dp = dp;
        try {
            this.programme = Information.getInformation().ladeProgrammListe();
        }
        catch (IOException e) {
            e.printStackTrace(Main.debug);
        }
        this.initListen();
        this.initButtons();
        this.titleInstalled = new JLabel(messages.getString("installationsdialog_msg3"));
        this.titleAvailable = new JLabel(messages.getString("installationsdialog_msg4"));
        Box gesamtBox = Box.createVerticalBox();
        Box wrapperInstBox = Box.createVerticalBox();
        Box wrapperAvailBox = Box.createVerticalBox();
        wrapperInstBox.add(this.titleInstalled);
        wrapperInstBox.add(Box.createVerticalStrut(10));
        Box listenBox = Box.createHorizontalBox();
        listenBox.add(Box.createHorizontalStrut(10));
        JScrollPane scrollAnwendungInstallieren = new JScrollPane(this.softwareInstalliert);
        scrollAnwendungInstallieren.setPreferredSize(new Dimension(170, 200));
        wrapperInstBox.add(scrollAnwendungInstallieren);
        listenBox.add(wrapperInstBox);
        listenBox.add(Box.createHorizontalGlue());
        Box topButtonBox = Box.createVerticalBox();
        topButtonBox.add(this.addButton);
        topButtonBox.add(Box.createVerticalStrut(10));
        topButtonBox.add(this.removeButton);
        listenBox.add(topButtonBox);
        wrapperAvailBox.add(this.titleAvailable);
        wrapperAvailBox.add(Box.createVerticalStrut(10));
        JScrollPane scrollAnwendungVerfuegbar = new JScrollPane(this.softwareVerfuegbar);
        scrollAnwendungVerfuegbar.setPreferredSize(new Dimension(170, 200));
        wrapperAvailBox.add(scrollAnwendungVerfuegbar);
        listenBox.add(wrapperAvailBox);
        listenBox.add(Box.createHorizontalStrut(10));
        gesamtBox.add(Box.createVerticalStrut(10));
        gesamtBox.add(listenBox);
        gesamtBox.add(Box.createVerticalStrut(10));
        Box bottomButtonBox = Box.createVerticalBox();
        bottomButtonBox.add(this.confirmButton);
        this.confirmButton.setAlignmentX(0.5f);
        gesamtBox.add(bottomButtonBox);
        gesamtBox.add(Box.createVerticalStrut(10));
        this.c.add((Component)gesamtBox, "Center");
        this.setClosable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setBounds(0, 40, 480, 360);
        this.setTitle(messages.getString("installationsdialog_msg1"));
        this.setVisible(true);
        this.setAnwendungsIcon("gfx/desktop/icon_softwareinstallation.png");
    }

    private GUIDesktopPanel getDesktopPanel() {
        return this.dp;
    }

    private void hinzufuegen() {
        int[] selektiertIndices;
        Vector<String> vLoeschen = new Vector<String>();
        for (int i : selektiertIndices = this.softwareVerfuegbar.getSelectedIndices()) {
            this.lmInstalliert.addElement(this.lmVerfuegbar.get(i));
            vLoeschen.add((String)this.lmVerfuegbar.get(i));
        }
        Enumeration e = vLoeschen.elements();
        while (e.hasMoreElements()) {
            String oZuLoeschen = (String)e.nextElement();
            this.lmVerfuegbar.removeElement(oZuLoeschen);
        }
    }

    private void entfernen() {
        int[] selektiertIndices = this.softwareInstalliert.getSelectedIndices();
        Vector<String> hinzu = new Vector<String>();
        for (int i : selektiertIndices) {
            this.lmVerfuegbar.addElement(this.lmInstalliert.getElementAt(i));
            hinzu.add((String)this.lmInstalliert.getElementAt(i));
        }
        Enumeration e = hinzu.elements();
        while (e.hasMoreElements()) {
            String hinzuObjekt = (String)e.nextElement();
            this.lmInstalliert.removeElement(hinzuObjekt);
        }
    }

    private void aenderungenSpeichern() {
        Betriebssystem bs = this.getDesktopPanel().getBetriebssystem();
        for (Map<String, String> appInfo : this.programme) {
            Anwendung anwendung;
            int i;
            for (i = 0; i < this.lmInstalliert.getSize(); ++i) {
                if (!this.lmInstalliert.getElementAt(i).equals(appInfo.get("Anwendung")) || bs.holeSoftware(appInfo.get("Klasse").toString()) != null) continue;
                bs.installiereSoftware(appInfo.get("Klasse").toString());
                anwendung = bs.holeSoftware(appInfo.get("Klasse").toString());
                anwendung.starten();
            }
            for (i = 0; i < this.lmVerfuegbar.getSize(); ++i) {
                if (!this.lmVerfuegbar.getElementAt(i).equals(appInfo.get("Anwendung")) || (anwendung = bs.holeSoftware(appInfo.get("Klasse").toString())) == null) continue;
                anwendung.beenden();
                bs.entferneSoftware(appInfo.get("Klasse").toString());
            }
        }
        this.dp.updateAnwendungen();
    }

    private void initButtons() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand().equals(GUIInstallationsDialog.this.addButton.getActionCommand())) {
                    GUIInstallationsDialog.this.hinzufuegen();
                } else if (arg0.getActionCommand().equals(GUIInstallationsDialog.this.removeButton.getActionCommand())) {
                    GUIInstallationsDialog.this.entfernen();
                } else if (arg0.getActionCommand() == GUIInstallationsDialog.this.confirmButton.getText()) {
                    GUIInstallationsDialog.this.aenderungenSpeichern();
                    GUIInstallationsDialog.this.setVisible(false);
                }
            }
        };
        this.removeButton = new JButton(new ImageIcon(this.getClass().getResource("/gfx/allgemein/pfeil_rechts.png")));
        this.removeButton.setMargin(new Insets(2, 2, 2, 2));
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(al);
        this.addButton = new JButton(new ImageIcon(this.getClass().getResource("/gfx/allgemein/pfeil_links.png")));
        this.addButton.setMargin(new Insets(2, 2, 2, 2));
        this.addButton.setActionCommand("add");
        this.addButton.addActionListener(al);
        this.confirmButton = new JButton(messages.getString("installationsdialog_msg2"));
        this.confirmButton.addActionListener(al);
    }

    private void initListen() {
        this.lmInstalliert = new DefaultListModel();
        this.lmVerfuegbar = new DefaultListModel();
        Betriebssystem bs = this.dp.getBetriebssystem();
        Anwendung[] anwendungen = bs.holeArrayInstallierteSoftware();
        for (int i = 0; i < anwendungen.length; ++i) {
            if (anwendungen[i] == null) continue;
            this.lmInstalliert.addElement(anwendungen[i].holeAnwendungsName());
        }
        if (this.programme != null) {
            for (Map<String, String> programmInfo : this.programme) {
                String awKlasse = programmInfo.get("Klasse");
                if (this.dp.getBetriebssystem().holeSoftware(awKlasse) != null) continue;
                this.lmVerfuegbar.addElement(programmInfo.get("Anwendung"));
            }
        }
        this.softwareInstalliert = new JList();
        this.softwareInstalliert.setModel(this.lmInstalliert);
        this.softwareInstalliert.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUIInstallationsDialog.this.entfernen();
                }
            }
        });
        this.softwareVerfuegbar = new JList();
        this.softwareVerfuegbar.setModel(this.lmVerfuegbar);
        this.softwareVerfuegbar.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUIInstallationsDialog.this.hinzufuegen();
                }
            }
        });
    }

    public void setAnwendungsIcon(String datei) {
        ImageIcon image = new ImageIcon(this.getClass().getResource("/" + datei));
        image.setImage(image.getImage().getScaledInstance(16, 16, 16));
        this.setFrameIcon(image);
    }
}

