/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.software.system.Datei;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class GUITreeRenderer
extends DefaultTreeCellRenderer {
    private Icon dateiIcon;
    private Icon ordnerIcon;
    private boolean dateienAnzeigen;

    public GUITreeRenderer(Icon dateiIcon, Icon ordnerIcon) {
        this.dateiIcon = dateiIcon;
        this.ordnerIcon = ordnerIcon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (leaf && this.isDatei(value)) {
            this.setIcon(this.dateiIcon);
            this.setText(this.getDateiName(value));
        } else {
            this.setIcon(this.ordnerIcon);
        }
        if (this.isDatei(value) && !this.isDateienAnzeigen()) {
            this.setVisible(false);
            this.setText("");
            this.setIcon(null);
        }
        return this;
    }

    protected boolean isDatei(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        return node.getUserObject().getClass().equals(Datei.class);
    }

    protected String getDateiName(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject().getClass().equals(Datei.class)) {
            Datei datei = (Datei)node.getUserObject();
            return datei.getName();
        }
        return "";
    }

    public boolean isDateienAnzeigen() {
        return this.dateienAnzeigen;
    }

    public void setDateienAnzeigen(boolean dateienAnzeigen) {
        this.dateienAnzeigen = dateienAnzeigen;
    }
}

