/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIApplicationDNSServerWindow;
import filius.gui.anwendungssicht.GUIApplicationWebServerWindow;
import filius.gui.netzwerksicht.JFirewallDialog;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.software.dns.DNSServer;
import filius.software.www.WebServer;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JTableEditable
extends JTable {
    private static final long serialVersionUID = 1L;
    private boolean editable;
    private String typeID = null;
    private Object parentGUI;

    public JTableEditable(TableModel model, boolean editable) {
        super(model);
        this.setEditable(editable);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(new ColorTableCellRenderer());
        }
    }

    public JTableEditable(TableModel model, boolean editable, String type) {
        super(model);
        this.setEditable(editable);
        this.typeID = type;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(new ColorTableCellRenderer());
        }
    }

    public void setParentGUI(Object parent) {
        this.parentGUI = parent;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editable;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            String formerValue = (String)this.getValueAt(this.editingRow, this.editingColumn);
            String value = (String)editor.getCellEditorValue();
            if (value == null) {
                value = "";
            }
            boolean updateCellValue = true;
            if (this.parentGUI instanceof GUIApplicationDNSServerWindow) {
                value = value.trim();
                updateCellValue = false;
                DNSServer dnsServer = (DNSServer)((GUIApplicationDNSServerWindow)this.parentGUI).holeAnwendung();
                if (this.typeID != null && this.typeID.equals("A")) {
                    if (this.editingColumn == 0) {
                        boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                        if (validChange) {
                            dnsServer.changeSingleEntry(this.editingRow, 0, "A", value);
                        }
                    } else {
                        boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterIpAdresse);
                        if (validChange) {
                            dnsServer.changeSingleEntry(this.editingRow, 3, "A", value);
                        }
                    }
                } else if (this.typeID != null && this.typeID.equals("MX")) {
                    if (this.editingColumn == 0) {
                        boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                        if (validChange) {
                            dnsServer.changeSingleEntry(this.editingRow, 0, "MX", value);
                        }
                    } else {
                        boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                        if (validChange) {
                            dnsServer.changeSingleEntry(this.editingRow, 3, "MX", value);
                        }
                    }
                } else if (this.typeID != null && this.typeID.equals("NS")) {
                    if (this.editingColumn == 0) {
                        boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                        if (validChange) {
                            dnsServer.changeSingleEntry(this.editingRow, 0, "NS", value);
                        }
                    } else {
                        boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                        if (validChange) {
                            dnsServer.changeSingleEntry(this.editingRow, 3, "NS", value);
                        }
                    }
                }
            }
            if (this.parentGUI instanceof GUIApplicationWebServerWindow && this.typeID != null && this.typeID.equals("WWW")) {
                ((WebServer)((GUIApplicationWebServerWindow)this.parentGUI).holeAnwendung()).changeVHostTable(this.editingRow, this.editingColumn, value);
            }
            if (this.parentGUI instanceof JFirewallDialog) {
                if (this.editingColumn == 0) {
                    this.setValueAt(formerValue, this.editingRow, this.editingColumn);
                } else {
                    String retValue = ((JFirewallDialog)this.parentGUI).getFirewall().changeSingleEntry(this.editingRow, this.editingColumn, value);
                    if (!retValue.equals(value)) {
                        this.setValueAt(retValue, this.editingRow, this.editingColumn);
                    }
                    if (this.editingColumn == 1 || this.editingColumn == 3) {
                        if (!EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterIpAdresseAuchLeer)) {
                            ((ColorTableCellRenderer)this.getCellRenderer(this.editingRow, this.editingColumn)).setColor(this.editingRow, this.editingColumn, EingabenUeberpruefung.farbeFalsch);
                        } else {
                            ((ColorTableCellRenderer)this.getCellRenderer(this.editingRow, this.editingColumn)).resetColor(this.editingRow, this.editingColumn);
                        }
                        if (!value.isEmpty() && ((String)this.getValueAt(this.editingRow, this.editingColumn + 1)).isEmpty()) {
                            this.setValueAt("255.255.255.255", this.editingRow, this.editingColumn + 1);
                        }
                    }
                    if (this.editingColumn == 6) {
                        if (!EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterPortAuchLeer)) {
                            ((ColorTableCellRenderer)this.getCellRenderer(this.editingRow, this.editingColumn)).setColor(this.editingRow, this.editingColumn, EingabenUeberpruefung.farbeFalsch);
                        } else {
                            ((ColorTableCellRenderer)this.getCellRenderer(this.editingRow, this.editingColumn)).resetColor(this.editingRow, this.editingColumn);
                        }
                    }
                }
            }
            if (updateCellValue) {
                this.setValueAt(value, this.editingRow, this.editingColumn);
            }
            this.removeEditor();
        }
    }

    public String getType() {
        return this.typeID;
    }

    public class ColorTableCellRenderer
    implements TableCellRenderer {
        private HashMap<Integer, Color> cellData = new HashMap();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(value != null ? value.toString() : "");
            int key = (row + 1) * 1000 + column;
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(Color.CYAN);
            } else if (this.cellData.containsKey(key)) {
                label.setBackground(this.cellData.get(key));
            } else {
                label.setBackground(Color.WHITE);
            }
            return label;
        }

        public void setColor(int row, int column, Color color) {
            int key = (row + 1) * 1000 + column;
            this.cellData.put(key, color);
        }

        public void resetColor(int row, int column) {
            int key = (row + 1) * 1000 + column;
            this.cellData.remove(key);
        }

        public void resetColors() {
            this.cellData.clear();
        }
    }
}

