/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.netzwerksicht.GUIDocuItem;
import filius.gui.netzwerksicht.GUIDocumentationPanel;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.GUINetworkPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GUIPrintPanel
extends JPanel {
    private static final int EMPTY_BORDER = 10;
    private GUINetworkPanel networkPanel;
    private GUIDocumentationPanel docuPanel;

    public GUIPrintPanel(int width, int height) {
        this.setSize(width + 20, height + 20);
        this.setOpaque(false);
        this.networkPanel = new GUINetworkPanel(width, height);
        this.add(this.networkPanel);
        this.networkPanel.setBounds(10, 10, width, height);
        this.docuPanel = new GUIDocumentationPanel(width, height);
        this.add(this.docuPanel);
        this.docuPanel.setBounds(10, 10, width, height);
    }

    public void updateViewport(List<GUIKnotenItem> knoten, List<GUIKabelItem> kabel, List<GUIDocuItem> docuItems, boolean docuItemsEnabled) {
        this.networkPanel.updateViewport(knoten, kabel);
        this.docuPanel.updateViewport(docuItems, false);
    }

    public void updateViewport(List<GUIKnotenItem> knoten, List<GUIKabelItem> kabel, List<GUIDocuItem> docuItems, String footerText) {
        this.networkPanel.updateViewport(knoten, kabel);
        this.docuPanel.updateViewport(docuItems, false);
        JLabel footer = new JLabel(footerText);
        footer.setForeground(Color.lightGray);
        int footerWidth = footer.getFontMetrics(footer.getFont()).stringWidth(footerText) + 20;
        int footerHeight = footer.getFontMetrics(footer.getFont()).getHeight();
        int footerY = (int)Math.max(this.networkPanel.maxY, this.docuPanel.maxY) + 30;
        int footerX = (int)Math.min(this.networkPanel.minX, this.docuPanel.minX);
        footer.setBounds(footerX, footerY, footerWidth, footerHeight);
        this.docuPanel.add(footer);
        this.docuPanel.maxX = Math.max((double)(footerX + footerWidth), this.docuPanel.maxX);
        this.docuPanel.maxY = footerY + footerHeight;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getClipY() {
        return (int)Math.min(this.networkPanel.minY, this.docuPanel.minY);
    }

    public int getClipHeight() {
        int totalMaxY = (int)Math.max(this.networkPanel.maxY, this.docuPanel.maxY);
        return totalMaxY - this.getClipY() + 20;
    }

    public int getClipWidth() {
        int totalMaxX = (int)Math.max(this.networkPanel.maxX, this.docuPanel.maxX);
        return totalMaxX - this.getClipX() + 20;
    }

    public int getClipX() {
        return (int)Math.min(this.networkPanel.minX, this.docuPanel.minX);
    }
}

