/*
 * Decompiled with CFR 0.152.
 */
package filius.rahmenprogramm;

import filius.Main;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;

public class FiliusClassLoader
extends ClassLoader
implements I18n {
    private static FiliusClassLoader classLoader;

    protected FiliusClassLoader(ClassLoader parent) {
        super(parent);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + ", constr: FiliusClassLoader(" + parent + ")");
    }

    public static FiliusClassLoader getInstance(ClassLoader parent) {
        Main.debug.println("INVOKED (static) filius.rahmenprogramm.FiliusClassLoader, getInstance()");
        if (classLoader == null) {
            classLoader = new FiliusClassLoader(parent);
        }
        return classLoader;
    }

    @Override
    public Class<?> loadClass(String name) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", loadClass(" + name + ")");
        Class<?> klasse = null;
        try {
            klasse = this.getParent().loadClass(name);
            return klasse;
        }
        catch (Exception exception) {
            try {
                klasse = this.findClass(name);
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
            }
            return klasse;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", findClass(" + name + ")");
        Class<?> c = null;
        if (name.endsWith("BeanInfo")) {
            return null;
        }
        byte[] b = this.loadClassData(name);
        if (b == null) {
            throw new ClassNotFoundException(messages.getString("rp_filiusclassloader_msg1") + " " + name + " " + messages.getString("rp_filiusclassloader_msg2"));
        }
        c = this.defineClass(name, b, 0, b.length);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassData(String className) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", loadClassData(" + className + ")");
        CharArrayWriter byteInputFromClassFile = new CharArrayWriter();
        FileInputStream fileInput = null;
        byte[] classData = null;
        String classPath = Information.getInformation().getAnwendungenPfad() + className.replace('.', System.getProperty("file.separator").charAt(0)) + ".class";
        if (new File(classPath).exists()) {
            try {
                int temp;
                fileInput = new FileInputStream(classPath);
                while ((temp = fileInput.read()) != -1) {
                    byteInputFromClassFile.append((char)temp);
                }
                char[] tempCharArray = byteInputFromClassFile.toCharArray();
                classData = new byte[tempCharArray.length];
                for (int i = 0; i < classData.length; ++i) {
                    classData[i] = (byte)tempCharArray[i];
                }
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
                classData = null;
            }
            finally {
                try {
                    fileInput.close();
                }
                catch (Exception exception) {}
            }
        }
        return classData;
    }
}

