/*
 * Decompiled with CFR 0.152.
 */
package filius.software.clientserver;

import filius.Main;
import filius.rahmenprogramm.I18n;
import filius.software.clientserver.ClientAnwendung;
import filius.software.transportschicht.TCPSocket;

public class ClientBaustein
extends ClientAnwendung
implements I18n {
    private int zielPort = 55555;
    private String zielIPAdresse;

    public void verbinden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ClientBaustein), verbinden()");
        Object[] args = new Object[]{this.zielIPAdresse, new Integer(this.zielPort)};
        this.ausfuehren("initialisiereSocket", args);
        this.ausfuehren("empfangeNachricht", null);
    }

    public void initialisiereSocket(String zielAdresse, Integer port) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ClientBaustein), initialisiereSocket(" + zielAdresse + "," + port + ")");
        try {
            this.socket = new TCPSocket(this.getSystemSoftware(), zielAdresse, (int)port);
            this.socket.verbinden();
            this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg2"));
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
            this.socket = null;
            this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg1") + e.getMessage());
        }
    }

    public void trennen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ClientBaustein), trennen()");
        if (this.socket != null) {
            this.socket.schliessen();
            this.socket = null;
            this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg3"));
        }
    }

    public void senden(String nachricht) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ClientBaustein), versendeNachricht(" + nachricht + ")");
        if (this.socket != null && this.socket.istVerbunden()) {
            try {
                this.socket.senden(nachricht);
                this.benachrichtigeBeobachter("<<" + nachricht);
            }
            catch (Exception e) {
                this.benachrichtigeBeobachter(e.getMessage());
                e.printStackTrace(Main.debug);
            }
        } else {
            this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg4"));
        }
    }

    public void empfangeNachricht() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ClientBaustein), empfangeNachricht()");
        if (this.socket != null && this.socket.istVerbunden()) {
            try {
                while (this.istVerbunden()) {
                    String nachricht = this.socket.empfangen();
                    if (nachricht != null) {
                        this.benachrichtigeBeobachter(">>" + nachricht);
                        continue;
                    }
                    this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg5") + " " + this.socket.holeZielIPAdresse() + ":" + this.socket.holeZielPort() + " " + messages.getString("sw_clientbaustein_msg6"));
                    this.socket.schliessen();
                }
            }
            catch (Exception e) {
                this.benachrichtigeBeobachter(e.getMessage());
                e.printStackTrace(Main.debug);
            }
        } else {
            this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg4"));
        }
    }

    public String getZielIPAdresse() {
        return this.zielIPAdresse;
    }

    public void setZielIPAdresse(String zielIPAdresse) {
        this.zielIPAdresse = zielIPAdresse;
    }

    public int getZielPort() {
        return this.zielPort;
    }

    public void setZielPort(int zielPort) {
        this.zielPort = zielPort;
    }
}

