/*
 * Decompiled with CFR 0.152.
 */
package filius.software.lokal;

import filius.Main;
import filius.exception.SocketException;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.clientserver.ClientAnwendung;
import filius.software.dns.Resolver;
import filius.software.system.Betriebssystem;
import filius.software.system.Datei;
import filius.software.system.Dateisystem;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.ServerSocket;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.SocketSchnittstelle;
import filius.software.transportschicht.TransportProtokoll;
import filius.software.vermittlungsschicht.IP;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.Route;
import filius.software.vermittlungsschicht.RouteNotFoundException;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.swing.tree.DefaultMutableTreeNode;

public class Terminal
extends ClientAnwendung
implements I18n {
    boolean abfrageVar;
    private DefaultMutableTreeNode aktuellerOrdner;
    private boolean interrupted = false;

    @Override
    public void setSystemSoftware(InternetKnotenBetriebssystem bs) {
        super.setSystemSoftware(bs);
        this.aktuellerOrdner = this.getSystemSoftware().getDateisystem().getRoot();
    }

    public String move(String[] args) {
        return this.mv(args);
    }

    public String mv(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Terminal), mv(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 2)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg40"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg40");
        }
        if (this.pureCopy(args)) {
            this.getSystemSoftware().getDateisystem().deleteFile(Dateisystem.absoluterPfad(this.getAktuellerOrdner()) + "/" + args[0]);
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg35"));
            return messages.getString("sw_terminal_msg35");
        }
        this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg36"));
        return messages.getString("sw_terminal_msg36");
    }

    public String rm(String[] args) {
        return this.del(args);
    }

    public String del(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Terminal), del(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 1)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg41"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg41");
        }
        if (this.getSystemSoftware().getDateisystem().deleteFile(Dateisystem.absoluterPfad(this.getAktuellerOrdner()) + "/" + args[0])) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg37"));
            return messages.getString("sw_terminal_msg37");
        }
        this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg38"));
        return messages.getString("sw_terminal_msg38");
    }

    private boolean pureCopy(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Terminal), pureCopy(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        this.getSystemSoftware().getDateisystem().printTree();
        String srcString = args[0];
        srcString = srcString.length() > 0 && srcString.substring(0, 1).equals("/") ? Dateisystem.evaluatePathString(srcString) : Dateisystem.evaluatePathString(Dateisystem.absoluterPfad(this.getAktuellerOrdner()) + "/" + srcString);
        String destString = args[1];
        destString = destString.length() > 0 && destString.substring(0, 1).equals("/") ? Dateisystem.evaluatePathString(destString) : Dateisystem.evaluatePathString(Dateisystem.absoluterPfad(this.getAktuellerOrdner()) + "/" + destString);
        String destDir = Dateisystem.getDirectory(destString);
        String destFile = Dateisystem.getBasename(destString);
        Datei sfile = this.getSystemSoftware().getDateisystem().holeDatei(srcString);
        if (sfile == null) {
            return false;
        }
        Datei dfile = new Datei(destFile, sfile.getDateiTyp(), sfile.getDateiInhalt());
        return this.getSystemSoftware().getDateisystem().speicherDatei(destDir, dfile);
    }

    public String copy(String[] args) {
        return this.cp(args);
    }

    public String cp(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Terminal), cp(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 2)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg40"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg40");
        }
        if (this.pureCopy(args)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg33"));
            return messages.getString("sw_terminal_msg33");
        }
        this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg34"));
        return messages.getString("sw_terminal_msg34");
    }

    public String ipconfig(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), ipconfig(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 0)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg42"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg42");
        }
        Betriebssystem bs = (Betriebssystem)this.getSystemSoftware();
        String ausgabe = "";
        ausgabe = ausgabe + messages.getString("sw_terminal_msg4") + " " + bs.holeIPAdresse() + "\n";
        ausgabe = ausgabe + messages.getString("sw_terminal_msg5") + " " + bs.holeNetzmaske() + "\n";
        ausgabe = ausgabe + messages.getString("sw_terminal_msg26") + " " + bs.holeMACAdresse() + "\n";
        ausgabe = ausgabe + messages.getString("sw_terminal_msg6") + " " + bs.getStandardGateway() + "\n";
        ausgabe = ausgabe + messages.getString("sw_terminal_msg27") + " " + bs.getDNSServer() + "\n";
        this.benachrichtigeBeobachter(ausgabe);
        return ausgabe;
    }

    public String route(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), route(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 0)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg42"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg42");
        }
        String ausgabe = messages.getString("sw_terminal_msg7");
        LinkedList<String[]> routingTabelle = this.getSystemSoftware().getWeiterleitungstabelle().holeTabelle();
        ListIterator it = routingTabelle.listIterator();
        while (it.hasNext()) {
            String[] eintrag = (String[])it.next();
            ausgabe = ausgabe + "| ";
            for (int i = 0; i < eintrag.length; ++i) {
                ausgabe = ausgabe + eintrag[i] + this.stringFuellen(15 - eintrag[i].length(), " ") + " | ";
            }
            ausgabe = ausgabe + "\n";
        }
        this.benachrichtigeBeobachter(ausgabe);
        return ausgabe;
    }

    public String ls(String[] args) {
        return this.dir(args);
    }

    public String dir(String[] args) {
        String currPath;
        LinkedList<Object> liste;
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), dir(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 0, 1)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg43"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg43");
        }
        int anzahlVerzeichnisse = 0;
        int anzahlDateien = 0;
        if (args[0].isEmpty()) {
            liste = this.getSystemSoftware().getDateisystem().listeVerzeichnis(this.aktuellerOrdner);
            currPath = Dateisystem.absoluterPfad(this.aktuellerOrdner);
        } else if (args[0].length() > 0 && args[0].substring(0, 1).equals("/")) {
            liste = this.getSystemSoftware().getDateisystem().listeVerzeichnis(this.getSystemSoftware().getDateisystem().verzeichnisKnoten(args[0]));
            currPath = Dateisystem.evaluatePathString(args[0]);
        } else {
            liste = this.getSystemSoftware().getDateisystem().listeVerzeichnis(Dateisystem.verzeichnisKnoten(this.aktuellerOrdner, args[0]));
            currPath = Dateisystem.evaluatePathString(Dateisystem.absoluterPfad(this.aktuellerOrdner) + "/" + args[0]);
        }
        if (liste == null || liste.size() == 0) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg8"));
            return messages.getString("sw_terminal_msg8");
        }
        StringBuffer inhalt = new StringBuffer();
        inhalt.append(messages.getString("sw_terminal_msg9") + " " + currPath + ":\n");
        for (Object e : liste) {
            if (e instanceof Datei) {
                ++anzahlDateien;
                Datei tmpDatei = (Datei)e;
                int leerzeichen = 40 - tmpDatei.getName().length();
                inhalt.append(tmpDatei.getName() + this.stringFuellen(leerzeichen, ".") + tmpDatei.holeGroesse() + "\n");
                continue;
            }
            ++anzahlVerzeichnisse;
            inhalt.append("[" + e + "]\n");
        }
        inhalt.append(messages.getString("sw_terminal_msg10") + anzahlVerzeichnisse);
        inhalt.append(messages.getString("sw_terminal_msg11") + anzahlDateien + "\n");
        this.benachrichtigeBeobachter(inhalt.toString());
        return inhalt.toString();
    }

    public String touch(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), touch(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 1)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg41"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg41");
        }
        String ergebnis = messages.getString("sw_terminal_msg12");
        String absPath = args[0].length() > 0 && args[0].substring(0, 1).equals("/") ? Dateisystem.evaluatePathString(args[0]) : Dateisystem.evaluatePathString(Dateisystem.absoluterPfad(this.aktuellerOrdner) + "/" + args[0]);
        String filePath = Dateisystem.getDirectory(absPath);
        String dateiName = Dateisystem.getBasename(absPath);
        if (!dateiName.equals("")) {
            if (!this.getSystemSoftware().getDateisystem().dateiVorhanden(filePath, dateiName)) {
                this.getSystemSoftware().getDateisystem().speicherDatei(filePath, new Datei(dateiName, "text/txt", ""));
                ergebnis = messages.getString("sw_terminal_msg13");
            } else {
                ergebnis = messages.getString("sw_terminal_msg14");
            }
        } else {
            ergebnis = messages.getString("sw_terminal_msg15");
        }
        this.benachrichtigeBeobachter(ergebnis);
        return ergebnis;
    }

    public String mkdir(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), mkdir(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 1)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg41"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg41");
        }
        String ergebnis = messages.getString("sw_terminal_msg16");
        String absPath = args[0].length() > 0 && args[0].substring(0, 1).equals("/") ? Dateisystem.evaluatePathString(args[0]) : Dateisystem.evaluatePathString(Dateisystem.absoluterPfad(this.aktuellerOrdner) + "/" + args[0]);
        String filePath = Dateisystem.getDirectory(absPath);
        String dateiName = Dateisystem.getBasename(absPath);
        ergebnis = !dateiName.equals("") ? (!this.getSystemSoftware().getDateisystem().dateiVorhanden(filePath, dateiName) && this.getSystemSoftware().getDateisystem().erstelleVerzeichnis(filePath, dateiName) ? messages.getString("sw_terminal_msg17") : messages.getString("sw_terminal_msg18")) : messages.getString("sw_terminal_msg19");
        this.benachrichtigeBeobachter(ergebnis);
        return ergebnis;
    }

    public String cd(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), cd(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        String ergebnis = "";
        if (!this.numParams(args, 0, 1)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg43"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg43");
        }
        if (this.numParams(args, 1)) {
            DefaultMutableTreeNode newDir = args[0].charAt(0) == '/' ? this.getSystemSoftware().getDateisystem().changeDirectory(args[0]) : this.getSystemSoftware().getDateisystem().changeDirectory(Dateisystem.absoluterPfad(this.aktuellerOrdner), args[0]);
            if (newDir != null) {
                this.aktuellerOrdner = newDir;
            } else {
                ergebnis = messages.getString("sw_terminal_msg20");
            }
        } else {
            ergebnis = Dateisystem.absoluterPfad(this.aktuellerOrdner);
        }
        this.benachrichtigeBeobachter(ergebnis);
        return ergebnis;
    }

    public String pwd(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), pwd(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 0)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg42"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg42");
        }
        String ergebnis = Dateisystem.absoluterPfad(this.aktuellerOrdner);
        this.benachrichtigeBeobachter(ergebnis);
        return ergebnis;
    }

    public String netstat(String[] args) {
        StringBuffer ergebnis = new StringBuffer();
        ergebnis.append(messages.getString("sw_terminal_msg49"));
        ergebnis.append("--------------------------------------------------------------------------\n");
        TransportProtokoll transport = this.getSystemSoftware().holeTcp();
        String protocol = "TCP";
        this.processTransportProtocol(ergebnis, transport, protocol);
        transport = this.getSystemSoftware().holeUdp();
        protocol = "UDP";
        this.processTransportProtocol(ergebnis, transport, protocol);
        this.benachrichtigeBeobachter(ergebnis);
        return ergebnis.toString();
    }

    private void processTransportProtocol(StringBuffer ergebnis, TransportProtokoll transport, String protocol) {
        Enumeration<Integer> benutztePorts = transport.holeAktiveSockets().keys();
        while (benutztePorts.hasMoreElements()) {
            int port = benutztePorts.nextElement();
            try {
                SocketSchnittstelle tmpSocket = transport.holeSocket(port);
                String[] socketData = this.getSocketInformation(tmpSocket);
                ergebnis.append(String.format("| %-8s ", protocol));
                ergebnis.append(String.format("| %-6s ", "" + port));
                ergebnis.append(String.format("| %-15s ", socketData[0]));
                ergebnis.append(String.format("| %-15s ", socketData[1]));
                ergebnis.append(String.format("| %-14s |\n", socketData[2]));
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    private String[] getSocketInformation(SocketSchnittstelle socket) {
        String localAddress = "";
        String remoteAddress = "";
        String state = "";
        if (socket instanceof Socket) {
            remoteAddress = ((Socket)socket).holeZielIPAdresse();
            try {
                Route routingEntry = this.getSystemSoftware().determineRoute(remoteAddress);
                localAddress = routingEntry.getInterfaceIpAddress();
            }
            catch (RouteNotFoundException e) {
                localAddress = "<unknown>";
            }
            state = ((Socket)socket).getStateAsString();
        } else if (socket instanceof ServerSocket) {
            remoteAddress = "-";
            localAddress = "-";
            state = "LISTEN";
        }
        return new String[]{localAddress, remoteAddress, state};
    }

    public String test(String[] args) {
        String ergebnis = messages.getString("sw_terminal_msg23");
        if (this.getSystemSoftware().getDateisystem().speicherDatei(args[0], new Datei("test", "txt", "blaaa"))) {
            ergebnis = messages.getString("sw_terminal_msg24");
        }
        this.benachrichtigeBeobachter(ergebnis);
        return ergebnis;
    }

    public String help(String[] args) {
        this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg25"));
        return messages.getString("sw_terminal_msg25");
    }

    public String type(String[] args) {
        return this.cat(args);
    }

    public String cat(String[] args) {
        StringBuilder result = new StringBuilder();
        if (args == null || args.length < 1 || args[0] == null || "".equals(args[0])) {
            result.append(messages.getString("sw_terminal_msg51"));
        } else {
            Datei file = this.getSystemSoftware().getDateisystem().holeDatei(this.aktuellerOrdner, args[0]);
            result.append(file.getDateiInhalt());
        }
        this.benachrichtigeBeobachter(result.toString());
        return result.toString();
    }

    public String arp(String[] args) {
        StringBuilder ergebnis = new StringBuilder();
        ergebnis.append(messages.getString("sw_terminal_msg50"));
        ergebnis.append("----------------------------------------\n");
        Map<String, String> arpTable = this.getSystemSoftware().holeARP().holeARPTabelle();
        for (String ipAddress : arpTable.keySet()) {
            ergebnis.append(String.format("| %-15s  ", ipAddress));
            ergebnis.append(String.format("| %-17s |\n", arpTable.get(ipAddress)));
        }
        ergebnis.append("----------------------------------------\n");
        this.benachrichtigeBeobachter(ergebnis.toString());
        return ergebnis.toString();
    }

    public String host(String[] args) {
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), host(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 1)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg44"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg44");
        }
        Betriebssystem bs = (Betriebssystem)this.getSystemSoftware();
        Resolver res = bs.holeDNSClient();
        if (res == null) {
            Main.debug.println("ERROR (" + this.hashCode() + "): Terminal 'host': Resolver is null!");
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg30"));
            return messages.getString("sw_terminal_msg30");
        }
        try {
            String result = res.holeIPAdresse(args[0]);
            if (result != null) {
                this.benachrichtigeBeobachter(args[0] + " " + messages.getString("sw_terminal_msg28") + " " + result + "\n");
                return args[0] + " " + messages.getString("sw_terminal_msg28") + " " + result + "\n";
            }
            Main.debug.println("ERROR (" + this.hashCode() + "): Terminal 'host': result is null!");
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg30"));
            return messages.getString("sw_terminal_msg30");
        }
        catch (TimeoutException e) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg31"));
            return messages.getString("sw_terminal_msg31");
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg29"));
            return messages.getString("sw_terminal_msg29");
        }
    }

    public String ping(String[] args) {
        int num;
        String destIp;
        Main.debug.print("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), ping(");
        for (int i = 0; i < args.length; ++i) {
            Main.debug.print(i + "='" + args[i] + "' ");
        }
        Main.debug.println(")");
        if (!this.numParams(args, 1)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg44"));
            return messages.getString("sw_terminal_msg32") + messages.getString("sw_terminal_msg44");
        }
        Resolver res = this.getSystemSoftware().holeDNSClient();
        if (res == null) {
            Main.debug.println("ERROR (" + this.hashCode() + "): Terminal 'host': Resolver is null!");
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg30"));
            return messages.getString("sw_terminal_msg30");
        }
        try {
            destIp = IP.ipCheck(args[0]);
            if (destIp == null) {
                destIp = res.holeIPAdresse(args[0]);
            }
            if (destIp == null) {
                Main.debug.println("ERROR (" + this.hashCode() + "): Terminal 'host': result is null!");
                this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg30"));
                return messages.getString("sw_terminal_msg30");
            }
        }
        catch (TimeoutException e) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg31") + " (DNS)");
            return messages.getString("sw_terminal_msg31 (DNS)");
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg29"));
            return messages.getString("sw_terminal_msg29");
        }
        try {
            Route route = this.getSystemSoftware().determineRoute(destIp);
            if (VermittlungsProtokoll.isBroadcast(destIp, route.getInterfaceIpAddress(), route.getNetMask())) {
                this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg53"));
                return messages.getString("sw_terminal_msg53");
            }
        }
        catch (RouteNotFoundException e1) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_msg52"));
            return messages.getString("sw_terminal_msg52");
        }
        this.benachrichtigeBeobachter(new Boolean(true));
        this.benachrichtigeBeobachter("PING " + args[0] + " (" + destIp + ")");
        int receivedReplies = 0;
        int loopNumber = Information.isPosixCommandLineToolBehaviour() ? 10 : 4;
        for (num = 0; !this.interrupted && num < loopNumber; ++num) {
            try {
                long timeStart = System.currentTimeMillis();
                int resTTL = this.getSystemSoftware().holeICMP().startSinglePing(destIp, num + 1);
                long timeDiff = 1000L - (System.currentTimeMillis() - timeStart);
                if (resTTL >= 0) {
                    this.benachrichtigeBeobachter("\nFrom " + args[0] + " (" + destIp + "): icmp_seq=" + (num + 1) + " ttl=" + resTTL + " time=" + (System.currentTimeMillis() - timeStart) + "ms");
                    ++receivedReplies;
                }
                if (timeDiff <= 0L) continue;
                try {
                    Thread.sleep(timeDiff);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (TimeoutException e) {
                this.benachrichtigeBeobachter("\nFrom " + args[0] + " (" + destIp + "): icmp_seq=" + (num + 1) + "   -- Timeout!");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
            }
        }
        this.benachrichtigeBeobachter(new Boolean(false));
        this.benachrichtigeBeobachter("\n--- " + args[0] + " " + messages.getString("sw_terminal_msg45") + " ---\n" + num + " " + messages.getString("sw_terminal_msg46") + ", " + receivedReplies + " " + messages.getString("sw_terminal_msg47") + ", " + (int)Math.round((1.0 - (double)receivedReplies / (double)num) * 100.0) + "% " + messages.getString("sw_terminal_msg48") + "\n");
        return "";
    }

    public String traceroute(String[] args) {
        int ttl;
        if (!this.numParams(args, 1)) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_trace_msg1"));
            return null;
        }
        int maxHops = 20;
        String destIP = IP.ipCheck(args[0]);
        if (destIP == null) {
            Resolver res = this.getSystemSoftware().holeDNSClient();
            try {
                destIP = res.holeIPAdresse(args[0]);
            }
            catch (TimeoutException e) {
                this.benachrichtigeBeobachter(messages.getString("sw_terminal_trace_msg2"));
                return null;
            }
        }
        if (destIP == null) {
            this.benachrichtigeBeobachter(messages.getString("sw_terminal_trace_msg3"));
            return null;
        }
        this.benachrichtigeBeobachter(new Boolean(true));
        if (destIP.equals(args[0])) {
            this.benachrichtigeBeobachter(String.format(messages.getString("sw_terminal_trace_msg4") + "\n", args[0], maxHops));
        } else {
            this.benachrichtigeBeobachter(String.format(messages.getString("sw_terminal_trace_msg5") + "\n", args[0], destIP, maxHops));
        }
        IcmpPaket recv = null;
        int seqNr = 966;
        int fehler = 0;
        for (ttl = 1; ttl <= maxHops && !this.interrupted; ++ttl) {
            this.benachrichtigeBeobachter(" " + ttl + "    ");
            for (int i = 0; i < 3 && !this.interrupted; ++i) {
                recv = this.getSystemSoftware().holeICMP().sendProbe(destIP, ttl, ++seqNr);
                if (recv != null && recv.getSeqNr() == seqNr) {
                    fehler = 0;
                    break;
                }
                ++fehler;
                this.benachrichtigeBeobachter("* ");
            }
            if (fehler == 0) {
                this.benachrichtigeBeobachter(recv.getQuellIp());
                if (recv.getIcmpType() != 11) {
                    break;
                }
            } else if (fehler > 5) break;
            this.benachrichtigeBeobachter("\n");
        }
        this.benachrichtigeBeobachter(new Boolean(false));
        if (ttl >= maxHops) {
            this.benachrichtigeBeobachter("\n\n" + String.format(messages.getString("sw_terminal_trace_msg6"), args[0], maxHops));
        } else if (this.interrupted) {
            this.benachrichtigeBeobachter("\n\n" + messages.getString("sw_terminal_trace_msg7"));
        } else if (recv != null && recv.getIcmpType() == 3) {
            switch (recv.getIcmpCode()) {
                case 0: {
                    this.benachrichtigeBeobachter("\n\n" + String.format(messages.getString("sw_terminal_trace_msg8"), recv.getQuellIp()));
                    break;
                }
                case 1: {
                    this.benachrichtigeBeobachter("\n\n" + String.format(messages.getString("sw_terminal_trace_msg9"), recv.getQuellIp()));
                    break;
                }
                default: {
                    this.benachrichtigeBeobachter("\n\n" + String.format(messages.getString("sw_terminal_trace_msg10"), recv.getQuellIp()));
                    break;
                }
            }
        } else if (fehler == 0) {
            if (ttl == 1) {
                this.benachrichtigeBeobachter("\n\n" + String.format(messages.getString("sw_terminal_trace_msg11"), args[0]));
            } else {
                this.benachrichtigeBeobachter("\n\n" + String.format(messages.getString("sw_terminal_trace_msg12"), args[0], ttl));
            }
        } else {
            this.benachrichtigeBeobachter("\n\n" + messages.getString("sw_terminal_trace_msg13"));
        }
        return null;
    }

    public void setInterrupt(boolean val) {
        this.interrupted = val;
    }

    @Override
    public void beenden() {
        this.setInterrupt(true);
        super.beenden();
    }

    public void terminalEingabeAuswerten(String enteredCommand, String[] enteredParameters) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), terminalEingabeAuswerten(" + enteredCommand + "," + enteredParameters + ")");
        Object[] args = new Object[]{enteredParameters};
        try {
            this.getClass().getDeclaredMethod(enteredCommand, enteredParameters.getClass());
            this.setInterrupt(false);
            this.ausfuehren(enteredCommand, args);
        }
        catch (NoSuchMethodException e) {
            this.benachrichtigeBeobachter(messages.getString("terminal_msg2") + "\n" + messages.getString("terminal_msg3") + "\n");
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
        }
    }

    public DefaultMutableTreeNode getAktuellerOrdner() {
        return this.aktuellerOrdner;
    }

    public void setAktuellerOrdner(DefaultMutableTreeNode aktuellerOrdner) {
        this.aktuellerOrdner = aktuellerOrdner;
    }

    public String addSlashes(String sl) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), addSlashes(" + sl + ")");
        String slNeu = "";
        String letztesZ = "" + sl.charAt(sl.length() - 1);
        if (!letztesZ.equals("/")) {
            slNeu = sl + "/";
        }
        return slNeu;
    }

    private String stringFuellen(int a, String fueller) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), stringFuellen(" + a + "," + fueller + ")");
        String tmp = "";
        for (int i = 0; i < a; ++i) {
            tmp = tmp + fueller;
        }
        return tmp;
    }

    public String makeEmptyString(int a, String fueller) {
        return this.stringFuellen(a, fueller);
    }

    private int countParams(String[] args) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", " + this.getId() + ") " + this.getClass() + " (Terminal), countParams(" + args + ")");
        int count = 0;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].isEmpty()) {
                ++count;
                continue;
            }
            return count;
        }
        return count;
    }

    private boolean numParams(String[] args, int exactNum) {
        return exactNum == this.countParams(args);
    }

    private boolean numParams(String[] args, int minNum, int maxNum) {
        int count = this.countParams(args);
        return count >= minNum && count <= maxNum;
    }
}

