/*
 * Decompiled with CFR 0.152.
 */
package filius.software.rip;

import filius.software.rip.RIPMessageRoute;
import filius.software.vermittlungsschicht.IP;
import java.util.LinkedList;

public class RIPMessage {
    public String ip;
    public String publicIp;
    public int infinity;
    public int timeout;
    public LinkedList<RIPMessageRoute> routes;

    public RIPMessage(String ip, String publicIp, int infinity, int timeout) {
        this.ip = ip;
        this.publicIp = publicIp;
        this.infinity = infinity;
        this.timeout = timeout;
        this.routes = new LinkedList();
    }

    public RIPMessage(String msg) throws IllegalArgumentException {
        String[] lines = msg.split("\n");
        try {
            this.ip = IP.ipCheck(lines[0]);
            this.publicIp = IP.ipCheck(lines[1]);
            this.infinity = Integer.parseInt(lines[2]);
            this.timeout = Integer.parseInt(lines[3]);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
        if (this.ip == null || this.publicIp == null || this.timeout <= 0 || this.infinity <= 0) {
            throw new IllegalArgumentException();
        }
        this.routes = new LinkedList();
        for (int i = 4; i < lines.length; ++i) {
            this.routes.add(new RIPMessageRoute(lines[i]));
        }
    }

    public String toString() {
        String res = "";
        res = res + this.ip + "\n";
        res = res + this.publicIp + "\n";
        res = res + this.infinity + "\n";
        res = res + this.timeout;
        for (RIPMessageRoute route : this.routes) {
            res = res + "\n" + route.toString();
        }
        return res;
    }

    public void addRoute(RIPMessageRoute newRoute) {
        for (RIPMessageRoute route : this.routes) {
            if (!route.ip.equals(newRoute.ip) || !route.mask.equals(newRoute.mask)) continue;
            if (newRoute.hops < route.hops) {
                route.hops = newRoute.hops;
            }
            return;
        }
        this.routes.add(newRoute);
    }
}

