/*
 * Decompiled with CFR 0.152.
 */
package filius.software.rip;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.software.clientserver.ServerMitarbeiter;
import filius.software.rip.RIPMessage;
import filius.software.rip.RIPMessageRoute;
import filius.software.rip.RIPRoute;
import filius.software.rip.RIPServer;
import filius.software.rip.RIPTable;
import filius.software.system.VermittlungsrechnerBetriebssystem;
import filius.software.transportschicht.Socket;
import filius.software.vermittlungsschicht.IP;

public class RIPServerMitarbeiter
extends ServerMitarbeiter {
    private RIPTable table;
    private VermittlungsrechnerBetriebssystem bs;
    private InternetKnoten knoten;

    public RIPServerMitarbeiter(RIPServer server, Socket socket) {
        super(server, socket);
        this.bs = (VermittlungsrechnerBetriebssystem)server.getSystemSoftware();
        this.knoten = (InternetKnoten)this.bs.getKnoten();
        this.table = this.bs.getRIPTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verarbeiteNachricht(String nachricht) {
        RIPMessage msg;
        try {
            msg = new RIPMessage(nachricht);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        String nicIp = this.findeInterfaceIp(msg.ip);
        if (nicIp == null || nicIp.equals(msg.ip)) {
            return;
        }
        RIPTable rIPTable = this.table;
        synchronized (rIPTable) {
            for (RIPMessageRoute entry : msg.routes) {
                int hops = entry.hops >= msg.infinity || entry.hops + 1 >= 16 ? 16 : entry.hops + 1;
                RIPRoute route = this.table.search(entry.ip, entry.mask);
                if (route != null) {
                    if (!route.getGateway().equals(msg.ip) && route.hops <= hops) continue;
                    if (route.hops > hops) {
                        route.setGateway(msg.ip);
                        route.hopPublicIp = msg.publicIp;
                        route.setInterfaceIpAddress(nicIp);
                    } else if (route.hops < hops) {
                        this.table.setNextBeacon(0L);
                    }
                    route.hops = hops;
                    route.refresh(msg.timeout);
                    continue;
                }
                if (hops >= 16) continue;
                route = new RIPRoute(msg.timeout, entry.ip, entry.mask, msg.ip, msg.publicIp, nicIp, hops);
                this.table.addRoute(route);
                this.table.setNextBeacon(0L);
            }
            this.table.notifyAll();
        }
    }

    String findeInterfaceIp(String ipStr) {
        long ip = IP.inetAton(ipStr);
        for (NetzwerkInterface nic : this.knoten.getNetzwerkInterfaces()) {
            long netAddr;
            long netMask = IP.inetAton(nic.getSubnetzMaske());
            if ((ip & netMask) != (netAddr = IP.inetAton(nic.getIp()) & netMask)) continue;
            return nic.getIp();
        }
        return null;
    }
}

