/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.Main;
import filius.software.system.Datei;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Dateisystem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FILE_SEPARATOR = "/";
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode arbeitsVerzeichnis;

    public Dateisystem() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Dateisystem), constr: Dateisystem()");
        this.arbeitsVerzeichnis = this.root = new DefaultMutableTreeNode("root");
    }

    public void printTree() {
        this.printSubtree("", this.root);
    }

    private void printSubtree(String indent, DefaultMutableTreeNode tmpRoot) {
        Main.debug.print(indent + "--");
        if (!(tmpRoot.getUserObject() instanceof Datei)) {
            Main.debug.println("[" + tmpRoot.getUserObject().toString() + "]");
        }
        indent = indent + " |";
        Enumeration<TreeNode> e = tmpRoot.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            this.printSubtree(indent, node);
        }
    }

    public boolean dateiVorhanden(DefaultMutableTreeNode verzeichnis, String dateiName) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Dateisystem), dateiVorhanden(" + verzeichnis + "," + dateiName + ")");
        if (verzeichnis == null) {
            return false;
        }
        Enumeration<TreeNode> e = verzeichnis.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode enode = (DefaultMutableTreeNode)e.nextElement();
            if (!enode.getUserObject().toString().equalsIgnoreCase(dateiName)) continue;
            return true;
        }
        return false;
    }

    public boolean dateiVorhanden(String verzeichnis, String dateiName) {
        return this.dateiVorhanden(this.verzeichnisKnoten(verzeichnis), dateiName);
    }

    public static String absoluterPfad(DefaultMutableTreeNode node) {
        Main.debug.println("INVOKED (static) filius.software.system.Dateisystem, absoluterPfad(" + node + ")");
        Object[] pfadObjekte = node.getUserObjectPath();
        StringBuffer pfad = new StringBuffer();
        pfad.append(pfadObjekte[0].toString());
        for (int i = 1; i < pfadObjekte.length; ++i) {
            pfad.append(FILE_SEPARATOR + pfadObjekte[i].toString());
        }
        return Dateisystem.stripRoot(pfad.toString());
    }

    public String holeRootPfad() {
        return Dateisystem.absoluterPfad(this.root);
    }

    public DefaultMutableTreeNode verzeichnisKnoten(String pfad) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", verzeichnisKnoten(" + pfad + ")");
        pfad = Dateisystem.stripRoot(Dateisystem.evaluatePathString(pfad));
        if (pfad.equals(FILE_SEPARATOR) || pfad.isEmpty()) {
            return this.root;
        }
        Enumeration<TreeNode> enumeration = this.root.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!pfad.equalsIgnoreCase(Dateisystem.absoluterPfad(node))) continue;
            return node;
        }
        return null;
    }

    public static DefaultMutableTreeNode verzeichnisKnoten(DefaultMutableTreeNode verzeichnis, String pfad) {
        Main.debug.println("INVOKED (static) filius.software.system.Dateisystem, verzeichnisKnoten(" + verzeichnis + "," + pfad + ")");
        String absolutePath = pfad.length() > 0 && pfad.substring(0, 1).equals(FILE_SEPARATOR) ? Dateisystem.evaluatePathString(pfad) : Dateisystem.evaluatePathString(Dateisystem.absoluterPfad(verzeichnis) + FILE_SEPARATOR + pfad);
        Enumeration<TreeNode> enumeration = verzeichnis.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!absolutePath.equalsIgnoreCase(Dateisystem.absoluterPfad(node))) continue;
            return node;
        }
        return null;
    }

    public boolean deleteFile(String absolutePath) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Dateisystem), deleteFile(" + absolutePath + ")");
        DefaultMutableTreeNode node = this.verzeichnisKnoten(absolutePath);
        if (node != null) {
            node.removeFromParent();
            return true;
        }
        return false;
    }

    public Datei holeDatei(String dateiPfad) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Dateisystem), holeDatei(" + dateiPfad + ")");
        DefaultMutableTreeNode node = this.verzeichnisKnoten(dateiPfad);
        if (node != null && node.getUserObject() instanceof Datei) {
            return (Datei)node.getUserObject();
        }
        return null;
    }

    public Datei holeDatei(DefaultMutableTreeNode verzeichnis, String dateiPfad) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Dateisystem), holeDatei(" + verzeichnis + "," + dateiPfad + ")");
        String absoluterDateiPfad = Dateisystem.absoluterPfad(verzeichnis) + FILE_SEPARATOR + dateiPfad;
        return this.holeDatei(absoluterDateiPfad);
    }

    public Datei holeDatei(String verzeichnisPfad, String dateiPfad) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Dateisystem), holeDatei(" + verzeichnisPfad + "," + dateiPfad + ")");
        String absoluterDateiPfad = verzeichnisPfad + FILE_SEPARATOR + dateiPfad;
        return this.holeDatei(absoluterDateiPfad);
    }

    public LinkedList<Datei> dateiSuche(String suchVerzeichnis, String suchString) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Dateisystem), dateiSuche(" + suchVerzeichnis + "," + suchString + ")");
        LinkedList<Datei> dateien = new LinkedList<Datei>();
        DefaultMutableTreeNode verzeichnisNode = this.verzeichnisKnoten(suchVerzeichnis);
        Enumeration<TreeNode> e = verzeichnisNode.children();
        while (e.hasMoreElements()) {
            Datei tmpDatei;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof Datei) || !(tmpDatei = (Datei)node.getUserObject()).getName().toLowerCase().matches("(.+)?" + suchString.toLowerCase() + "(.+)?")) continue;
            dateien.addLast(tmpDatei);
        }
        return dateien;
    }

    public boolean speicherDatei(String verzeichnisPfad, Datei datei) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", speicherDatei(" + verzeichnisPfad + "," + datei + ")");
        DefaultMutableTreeNode node = null;
        node = this.verzeichnisKnoten(verzeichnisPfad);
        if (node != null) {
            if (!this.dateiVorhanden(node, datei.getName())) {
                DefaultMutableTreeNode dateiNode = new DefaultMutableTreeNode(datei);
                node.add(dateiNode);
            } else {
                node = this.verzeichnisKnoten(verzeichnisPfad + FILE_SEPARATOR + datei.getName());
                Datei file = (Datei)node.getUserObject();
                file.setDateiInhalt(datei.getDateiInhalt());
                file.setDateiTyp(datei.getDateiTyp());
                file.setSize(datei.holeGroesse());
            }
            return true;
        }
        Main.debug.println("ERROR (" + this.hashCode() + "): Datei " + datei + " konnte nicht gespeichert werden, weil Verzeichnis " + verzeichnisPfad + " nicht existiert.");
        return false;
    }

    public boolean speicherDatei(DefaultMutableTreeNode verzeichnis, Datei datei) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", speicherDatei(" + verzeichnis + "," + datei + ")");
        return this.speicherDatei(Dateisystem.absoluterPfad(verzeichnis), datei);
    }

    public boolean erstelleVerzeichnis(String verzeichnisPfad, String neuesVerzeichnis) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", erstelleVerzeichnis(" + verzeichnisPfad + "," + neuesVerzeichnis + ")");
        DefaultMutableTreeNode neuerNode = null;
        String absPath = neuesVerzeichnis.length() > 0 && neuesVerzeichnis.substring(0, 1).equals(FILE_SEPARATOR) ? Dateisystem.evaluatePathString(neuesVerzeichnis) : Dateisystem.evaluatePathString(verzeichnisPfad + FILE_SEPARATOR + neuesVerzeichnis);
        verzeichnisPfad = Dateisystem.getDirectory(absPath);
        neuesVerzeichnis = Dateisystem.getBasename(absPath);
        DefaultMutableTreeNode node = this.verzeichnisKnoten(verzeichnisPfad);
        if (node != null) {
            if (this.dateiVorhanden(node, neuesVerzeichnis)) {
                Main.debug.println("WARNING (" + this.hashCode() + "): Verzeichnis " + neuesVerzeichnis + " wurde nicht erzeugt, weil es im Verzeichnis " + verzeichnisPfad + " bereits existiert.");
            } else {
                neuerNode = new DefaultMutableTreeNode(neuesVerzeichnis);
                node.add(neuerNode);
            }
            return true;
        }
        return false;
    }

    public boolean erstelleVerzeichnis(DefaultMutableTreeNode verzeichnis, String neuesVerzeichnis) {
        return this.erstelleVerzeichnis(Dateisystem.absoluterPfad(verzeichnis), neuesVerzeichnis);
    }

    public List<Datei> holeDateien(DefaultMutableTreeNode node) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", holeDateien(" + node + ")");
        LinkedList<Datei> liste = new LinkedList<Datei>();
        if (node == null) {
            return null;
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!(n.getUserObject() instanceof Datei)) continue;
            Datei dat = (Datei)n.getUserObject();
            liste.add(dat);
        }
        return liste;
    }

    public LinkedList<Object> listeVerzeichnis(DefaultMutableTreeNode verzeichnis) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", listeVerzeichnis(" + verzeichnis + ")");
        LinkedList<Object> liste = new LinkedList<Object>();
        if (verzeichnis == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = verzeichnis.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode tmpNode = (DefaultMutableTreeNode)enumeration.nextElement();
            liste.addLast(tmpNode.getUserObject());
        }
        return liste;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(DefaultMutableTreeNode root) {
        this.root = root;
    }

    public void fixDirectory(DefaultMutableTreeNode root) {
        if (root.getAllowsChildren()) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.fixDirectory((DefaultMutableTreeNode)root.getChildAt(i));
            }
        }
        if (root.getUserObject() == null) {
            root.setUserObject("restored-" + System.currentTimeMillis());
        } else if (root.getUserObject() instanceof Datei && ((Datei)root.getUserObject()).getName().isEmpty()) {
            ((Datei)root.getUserObject()).setName("restored-" + System.currentTimeMillis());
        }
    }

    public DefaultMutableTreeNode getArbeitsVerzeichnis() {
        return this.arbeitsVerzeichnis;
    }

    public void setArbeitsVerzeichnis(DefaultMutableTreeNode arbeitsVerzeichnis) {
        this.arbeitsVerzeichnis = arbeitsVerzeichnis;
    }

    public DefaultMutableTreeNode changeDirectory(String absPath) {
        return this.verzeichnisKnoten(absPath);
    }

    public DefaultMutableTreeNode changeDirectory(String currDir, String relPath) {
        return this.verzeichnisKnoten(currDir + FILE_SEPARATOR + relPath);
    }

    public static String evaluatePathString(String path) {
        Main.debug.println("INVOKED (static) filius.software.system.Dateisystem, evaluatePathString(" + path + ")");
        String result = "";
        StringTokenizer tk = new StringTokenizer(path, FILE_SEPARATOR);
        String[] pathElements = new String[tk.countTokens()];
        int currIndex = -1;
        while (tk.hasMoreTokens()) {
            String currString = tk.nextToken();
            if (currString.equals("..")) {
                --currIndex;
                continue;
            }
            if (currString.equals(".") || currString.equals("")) continue;
            pathElements[++currIndex] = currString;
        }
        for (int i = 0; i <= currIndex; ++i) {
            result = result + pathElements[i];
            if (i >= currIndex) continue;
            result = result + FILE_SEPARATOR;
        }
        if (currIndex >= 0 && path.substring(0, 1).equals(FILE_SEPARATOR)) {
            result = FILE_SEPARATOR + result;
        }
        return result;
    }

    private static String stripRoot(String path) {
        Main.debug.println("INVOKED (static) filius.software.system.Dateisystem, stripRoot(" + path + ")");
        if (path.indexOf(FILE_SEPARATOR) >= 0) {
            return path.substring(path.indexOf(FILE_SEPARATOR));
        }
        return FILE_SEPARATOR;
    }

    public static String getDirectory(String path) {
        Main.debug.println("INVOKED (static) filius.software.system.Dateisystem, getDirectory(" + path + ")");
        if (path.lastIndexOf(FILE_SEPARATOR) >= 0) {
            return path.substring(0, path.lastIndexOf(FILE_SEPARATOR));
        }
        return "";
    }

    public static String getBasename(String path) {
        Main.debug.println("INVOKED (static) filius.software.system.Dateisystem, getBasename(" + path + ")");
        if (path.lastIndexOf(FILE_SEPARATOR) >= 0) {
            return path.substring(path.lastIndexOf(FILE_SEPARATOR) + 1);
        }
        return path;
    }
}

