/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.font.Font;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.TypecastFont;
import jogamp.graph.font.typecast.ot.table.HeadTable;
import jogamp.graph.font.typecast.ot.table.HheaTable;

class TypecastHMetrics
implements Font.Metrics {
    private final TypecastFont fontImpl;
    private final HeadTable headTable;
    private final float unitsPerEM_Inv;
    private final AABBox bbox;
    private final HheaTable hheaTable;

    public TypecastHMetrics(TypecastFont typecastFont) {
        this.fontImpl = typecastFont;
        this.headTable = this.fontImpl.font.getHeadTable();
        this.hheaTable = this.fontImpl.font.getHheaTable();
        this.unitsPerEM_Inv = 1.0f / (float)this.headTable.getUnitsPerEm();
        int n = this.headTable.getXMax() - this.headTable.getXMin();
        int n2 = this.headTable.getYMax() - this.headTable.getYMin();
        float f = this.headTable.getXMin();
        float f2 = -(this.headTable.getYMin() + n2);
        float f3 = f + (float)n;
        float f4 = f2 + (float)n2;
        this.bbox = new AABBox(f, f2, 0.0f, f3, f4, 0.0f);
    }

    @Override
    public final float getAscent(float f) {
        return this.getScale(f) * (float)(-this.hheaTable.getAscender());
    }

    @Override
    public final float getDescent(float f) {
        return this.getScale(f) * (float)(-this.hheaTable.getDescender());
    }

    @Override
    public final float getLineGap(float f) {
        return this.getScale(f) * (float)(-this.hheaTable.getLineGap());
    }

    @Override
    public final float getMaxExtend(float f) {
        return this.getScale(f) * (float)this.hheaTable.getXMaxExtent();
    }

    @Override
    public final float getScale(float f) {
        return f * this.unitsPerEM_Inv;
    }

    @Override
    public final AABBox getBBox(float f) {
        AABBox aABBox = new AABBox(this.bbox.getLow(), this.bbox.getHigh());
        aABBox.scale(this.getScale(f));
        return aABBox;
    }
}

