/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.Main;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.gui.anwendungssicht.GUITreeRenderer;
import filius.gui.anwendungssicht.OrdnerInhaltListRenderer;
import filius.rahmenprogramm.I18n;
import filius.software.lokal.FileExplorer;
import filius.software.system.Datei;
import filius.software.system.Dateisystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class GUIApplicationFileExplorerWindow
extends GUIApplicationWindow {
    private static final long serialVersionUID = 1L;
    private final ImageIcon dateiIcon = new ImageIcon(this.getClass().getResource("/gfx/desktop/datei.png"));
    private final ImageIcon ordnerIcon = new ImageIcon(this.getClass().getResource("/gfx/desktop/ordner.png"));
    private JPanel backPanel;
    private JTree tv;
    private DefaultMutableTreeNode aktuellerOrdner = this.holeAnwendung().getSystemSoftware().getDateisystem().getRoot();
    private JList dateiListe;
    private DefaultMutableTreeNode selektierteNode;
    private DefaultMutableTreeNode zwischenAblageNode;
    private JButton btImportieren;
    private String datei;
    private String pfad;
    private JInternalFrame fileImportFrame;

    public GUIApplicationFileExplorerWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.initialisiereKomponenten();
    }

    private void initialisiereKomponenten() {
        this.backPanel = new JPanel(new BorderLayout());
        this.tv = new JTree(this.aktuellerOrdner);
        this.tv.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)GUIApplicationFileExplorerWindow.this.tv.getLastSelectedPathComponent();
                if (node != null) {
                    GUIApplicationFileExplorerWindow.this.aktuellerOrdner = node;
                    GUIApplicationFileExplorerWindow.this.ordnerInhaltAnzeigen(node);
                }
            }
        });
        this.tv.setBounds(0, 0, 150, 100);
        this.tv.setCellRenderer(new GUITreeRenderer((Icon)this.dateiIcon, this.ordnerIcon));
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final JButton aktualisieren = new JButton(messages.getString("fileexplorer_msg1"));
        aktualisieren.setActionCommand("aktualisieren");
        aktualisieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(aktualisieren.getActionCommand())) {
                    GUIApplicationFileExplorerWindow.this.aktualisieren();
                }
            }
        });
        box.add(aktualisieren);
        box.add(Box.createVerticalStrut(5));
        this.btImportieren = new JButton(messages.getString("fileexplorer_msg2"));
        this.btImportieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIApplicationFileExplorerWindow.this.fileImport();
            }
        });
        box.add(this.btImportieren);
        JScrollPane scrollpane = new JScrollPane(this.tv);
        scrollpane.setPreferredSize(new Dimension(10, 240));
        Box horBox = Box.createHorizontalBox();
        horBox.add(scrollpane);
        horBox.setPreferredSize(new Dimension(180, 240));
        DefaultListModel lmDateiListe = new DefaultListModel();
        this.dateiListe = new JList(lmDateiListe);
        this.dateiListe.setFixedCellHeight(16);
        JScrollPane dateiListenScrollPane = new JScrollPane(this.dateiListe);
        dateiListenScrollPane.setPreferredSize(new Dimension(10, 240));
        horBox.add(dateiListenScrollPane);
        this.dateiListe.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && GUIApplicationFileExplorerWindow.this.aktuellerOrdner != null) {
                    int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
                    DefaultListModel lm = (DefaultListModel)GUIApplicationFileExplorerWindow.this.dateiListe.getModel();
                    int selektiert = GUIApplicationFileExplorerWindow.this.selektierteZelle(index, e.getPoint());
                    JPopupMenu popmen = new JPopupMenu();
                    final JMenuItem miNeuerOrdner = new JMenuItem(I18n.messages.getString("fileexplorer_msg3"));
                    miNeuerOrdner.setActionCommand("neuerordner");
                    final JMenuItem miLoeschen = new JMenuItem(I18n.messages.getString("fileexplorer_msg4"));
                    miLoeschen.setActionCommand("loeschen");
                    final JMenuItem miAusschneiden = new JMenuItem(I18n.messages.getString("fileexplorer_msg5"));
                    miAusschneiden.setActionCommand("ausschneiden");
                    final JMenuItem miKopieren = new JMenuItem(I18n.messages.getString("fileexplorer_msg6"));
                    miKopieren.setActionCommand("kopieren");
                    final JMenuItem miEinfuegen = new JMenuItem(I18n.messages.getString("fileexplorer_msg7"));
                    miEinfuegen.setActionCommand("einfuegen");
                    final JMenuItem miUmbenennen = new JMenuItem(I18n.messages.getString("fileexplorer_msg8"));
                    miUmbenennen.setActionCommand("umbenennen");
                    ActionListener al = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String neuerName;
                            int loeschAbfrage;
                            String ordnerName;
                            if (e.getActionCommand().equals(miNeuerOrdner.getActionCommand()) && !(ordnerName = JOptionPane.showInputDialog("")).equals("")) {
                                GUIApplicationFileExplorerWindow.this.holeAnwendung().getSystemSoftware().getDateisystem().erstelleVerzeichnis(GUIApplicationFileExplorerWindow.this.aktuellerOrdner, ordnerName);
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miLoeschen.getActionCommand()) && (loeschAbfrage = JOptionPane.showConfirmDialog(GUIApplicationFileExplorerWindow.this, I18n.messages.getString("fileexplorer_msg18"), I18n.messages.getString("fileexplorer_msg18"), 0)) == 0) {
                                GUIApplicationFileExplorerWindow.this.aktuellerOrdner.remove(GUIApplicationFileExplorerWindow.this.selektierteNode);
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miAusschneiden.getActionCommand())) {
                                try {
                                    GUIApplicationFileExplorerWindow.this.zwischenAblageNode = GUIApplicationFileExplorerWindow.this.tiefesKopieren(GUIApplicationFileExplorerWindow.this.selektierteNode);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace(Main.debug);
                                }
                                catch (ClassNotFoundException e1) {
                                    e1.printStackTrace(Main.debug);
                                }
                                GUIApplicationFileExplorerWindow.this.aktuellerOrdner.remove(GUIApplicationFileExplorerWindow.this.selektierteNode);
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miKopieren.getActionCommand())) {
                                try {
                                    GUIApplicationFileExplorerWindow.this.zwischenAblageNode = GUIApplicationFileExplorerWindow.this.tiefesKopieren(GUIApplicationFileExplorerWindow.this.selektierteNode);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace(Main.debug);
                                }
                                catch (ClassNotFoundException e1) {
                                    e1.printStackTrace(Main.debug);
                                }
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miEinfuegen.getActionCommand())) {
                                GUIApplicationFileExplorerWindow.this.aktuellerOrdner.add(GUIApplicationFileExplorerWindow.this.zwischenAblageNode);
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miUmbenennen.getActionCommand()) && (neuerName = JOptionPane.showInputDialog(GUIApplicationFileExplorerWindow.this, (Object)I18n.messages.getString("fileexplorer_msg9"))) != null && !neuerName.trim().isEmpty() && !GUIApplicationFileExplorerWindow.this.holeAnwendung().getSystemSoftware().getDateisystem().dateiVorhanden(GUIApplicationFileExplorerWindow.this.aktuellerOrdner, neuerName)) {
                                if (GUIApplicationFileExplorerWindow.this.selektierteNode.getUserObject().getClass().equals(Datei.class)) {
                                    Datei dat = (Datei)GUIApplicationFileExplorerWindow.this.selektierteNode.getUserObject();
                                    dat.setName(neuerName);
                                } else {
                                    GUIApplicationFileExplorerWindow.this.selektierteNode.setUserObject(neuerName);
                                }
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                        }
                    };
                    miNeuerOrdner.addActionListener(al);
                    miLoeschen.addActionListener(al);
                    miAusschneiden.addActionListener(al);
                    miKopieren.addActionListener(al);
                    miEinfuegen.addActionListener(al);
                    miUmbenennen.addActionListener(al);
                    if (selektiert == -1) {
                        popmen.add(miNeuerOrdner);
                        if (GUIApplicationFileExplorerWindow.this.zwischenAblageNode != null) {
                            popmen.add(miEinfuegen);
                        }
                    } else {
                        String[] teile = lm.getElementAt(index).toString().split(";");
                        if (teile.length > 0) {
                            GUIApplicationFileExplorerWindow.this.selektierteNode = Dateisystem.verzeichnisKnoten(GUIApplicationFileExplorerWindow.this.aktuellerOrdner, teile[1]);
                            GUIApplicationFileExplorerWindow.this.dateiListe.setSelectedIndex(index);
                        }
                        popmen.add(miLoeschen);
                        popmen.add(miAusschneiden);
                        popmen.add(miKopieren);
                        popmen.add(miUmbenennen);
                    }
                    GUIApplicationFileExplorerWindow.this.add(popmen);
                    popmen.show(GUIApplicationFileExplorerWindow.this.dateiListe, e.getX(), e.getY());
                }
            }
        });
        box.add(horBox);
        this.backPanel.add((Component)box, "Center");
        this.ordnerInhaltAnzeigen(this.aktuellerOrdner);
        this.getContentPane().add(this.backPanel);
        this.pack();
    }

    public void ordnerInhaltAnzeigen(DefaultMutableTreeNode node) {
        DefaultListModel lm = (DefaultListModel)this.dateiListe.getModel();
        lm.clear();
        this.dateiListe.setCellRenderer(new OrdnerInhaltListRenderer());
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode enode = (DefaultMutableTreeNode)e.nextElement();
            if (enode.getUserObject().getClass().equals(Datei.class)) {
                Datei dat = (Datei)enode.getUserObject();
                lm.addElement(messages.getString("fileexplorer_msg10") + ";" + dat.getName());
                continue;
            }
            lm.addElement(messages.getString("fileexplorer_msg11") + ";" + enode.toString());
        }
    }

    public int selektierteZelle(int index, Point punkt) {
        int ergebnis = -1;
        if (this.dateiListe.indexToLocation(index) != null && this.dateiListe.indexToLocation(index).getY() + (double)this.dateiListe.getFixedCellHeight() > punkt.getY()) {
            ergebnis = index;
        }
        return ergebnis;
    }

    public void aktualisieren() {
        this.tv.updateUI();
        this.ordnerInhaltAnzeigen(this.aktuellerOrdner);
    }

    public DefaultMutableTreeNode tiefesKopieren(DefaultMutableTreeNode original) throws IOException, ClassNotFoundException {
        DefaultMutableTreeNode ergebnis = null;
        ByteArrayOutputStream bufOutStream = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(bufOutStream);
        outStream.writeObject(original);
        outStream.close();
        byte[] buffer = bufOutStream.toByteArray();
        ByteArrayInputStream bufInStream = new ByteArrayInputStream(buffer);
        ObjectInputStream inStream = new ObjectInputStream(bufInStream);
        ergebnis = (DefaultMutableTreeNode)inStream.readObject();
        return ergebnis;
    }

    public void fileImport() {
        this.fileImportFrame = new JInternalFrame(messages.getString("fileexplorer_msg12"));
        ImageIcon image = new ImageIcon(this.getClass().getResource("/gfx/desktop/icon_fileimporter.png"));
        image.setImage(image.getImage().getScaledInstance(16, 16, 16));
        this.setFrameIcon(image);
        this.backPanel = new JPanel(new BorderLayout());
        final JTextArea outputField = new JTextArea("");
        outputField.setEditable(false);
        outputField.setSize(new Dimension(300, 80));
        JLabel fileLabel = new JLabel(messages.getString("fileexplorer_msg13"));
        final JTextField inputField = new JTextField("");
        inputField.setSize(new Dimension(150, 30));
        inputField.setEditable(false);
        final JTextField renameField = new JTextField("");
        renameField.setSize(new Dimension(150, 30));
        JLabel renameLabel = new JLabel(messages.getString("fileexplorer_msg9"));
        JButton fileButton = new JButton(messages.getString("fileexplorer_msg14"));
        fileButton.setSize(new Dimension(100, 30));
        fileButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog(null) == 0) {
                    GUIApplicationFileExplorerWindow.this.datei = fc.getSelectedFile().getName();
                    GUIApplicationFileExplorerWindow.this.pfad = fc.getSelectedFile().getParent();
                    if (!GUIApplicationFileExplorerWindow.this.pfad.endsWith(System.getProperty("file.separator"))) {
                        GUIApplicationFileExplorerWindow.this.pfad = GUIApplicationFileExplorerWindow.this.pfad + System.getProperty("file.separator");
                    }
                }
                if (GUIApplicationFileExplorerWindow.this.datei != null) {
                    inputField.setText(GUIApplicationFileExplorerWindow.this.pfad + GUIApplicationFileExplorerWindow.this.datei);
                    renameField.setText(GUIApplicationFileExplorerWindow.this.datei);
                }
                try {
                    GUIApplicationFileExplorerWindow.this.fileImportFrame.setSelected(true);
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace(Main.debug);
                }
            }
        });
        Box importBox = Box.createHorizontalBox();
        importBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        importBox.add(fileLabel);
        importBox.add(Box.createHorizontalStrut(5));
        importBox.add(inputField);
        importBox.add(Box.createHorizontalStrut(5));
        importBox.add(fileButton);
        Box middleBox = Box.createHorizontalBox();
        middleBox.add(renameLabel);
        middleBox.add(Box.createHorizontalStrut(5));
        middleBox.add(renameField);
        middleBox.add(Box.createHorizontalStrut(5));
        Box upperBox = Box.createVerticalBox();
        upperBox.add(importBox);
        upperBox.add(middleBox);
        this.backPanel.add((Component)upperBox, "North");
        JButton importButton = new JButton(messages.getString("fileexplorer_msg15"));
        importButton.setSize(new Dimension(100, 30));
        importButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent z) {
                if (inputField.getText().equals("") || renameField.getText().equals("")) {
                    outputField.setText(I18n.messages.getString("fileexplorer_msg16"));
                } else if (GUIApplicationFileExplorerWindow.this.aktuellerOrdner == null) {
                    outputField.setText(I18n.messages.getString("fileexplorer_msg17"));
                } else {
                    outputField.setText(((FileExplorer)GUIApplicationFileExplorerWindow.this.holeAnwendung()).addFile(GUIApplicationFileExplorerWindow.this.pfad, GUIApplicationFileExplorerWindow.this.datei, GUIApplicationFileExplorerWindow.this.aktuellerOrdner, renameField.getText()));
                    GUIApplicationFileExplorerWindow.this.aktualisieren();
                }
            }
        });
        Box lowerBox = Box.createHorizontalBox();
        lowerBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        lowerBox.add(importButton);
        this.backPanel.add((Component)outputField, "Center");
        this.backPanel.add((Component)lowerBox, "South");
        this.fileImportFrame.getContentPane().add(this.backPanel);
        this.fileImportFrame.setClosable(true);
        this.fileImportFrame.setResizable(false);
        this.fileImportFrame.setBounds(30, 80, 350, 200);
        this.fileImportFrame.setVisible(true);
        this.addFrame(this.fileImportFrame);
        try {
            this.fileImportFrame.setSelected(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace(Main.debug);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.aktualisieren();
    }
}

