/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.Main;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.Anwendung;
import java.awt.Dimension;
import java.util.Map;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public abstract class GUIApplicationWindow
extends JInternalFrame
implements I18n,
Observer {
    private static final long serialVersionUID = 1L;
    private GUIDesktopPanel desktop;
    private Anwendung anwendung;

    public GUIApplicationWindow(GUIDesktopPanel desktop, String appKlasse) {
        this.setDefaultCloseOperation(1);
        this.desktop = desktop;
        this.desktop.getDesktopPane().add(this);
        this.anwendung = desktop.getBetriebssystem().holeSoftware(appKlasse);
        this.anwendung.hinzuBeobachter(this);
        this.setPreferredSize(new Dimension(550, 420));
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(false);
        this.setResizable(true);
        this.setTitle(this.anwendung.holeAnwendungsName());
        this.initIcon();
    }

    private void initIcon() {
        try {
            for (Map<String, String> tmpMap : Information.getInformation().ladeProgrammListe()) {
                String awName = tmpMap.get("Anwendung");
                if (!awName.equals(this.anwendung.holeAnwendungsName())) continue;
                ImageIcon image = new ImageIcon(this.getClass().getResource("/" + tmpMap.get("gfxFile")));
                image.setImage(image.getImage().getScaledInstance(16, 16, 16));
                this.setFrameIcon(image);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
        }
    }

    public Anwendung holeAnwendung() {
        return this.anwendung;
    }

    public void showMessageDialog(String msg) {
        JOptionPane.showMessageDialog(this.desktop, msg);
    }

    public int showOptionDialog(Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        return JOptionPane.showOptionDialog(this.desktop, message, title, optionType, messageType, icon, options, initialValue);
    }

    public int showConfirmDialog(String msg) {
        return JOptionPane.showConfirmDialog(this.desktop, msg);
    }

    public void addFrame(JInternalFrame frame) {
        this.desktop.getDesktopPane().add(frame);
    }

    public void removeFrame(JInternalFrame frame) {
        this.desktop.getDesktopPane().remove(frame);
    }

    public void starteExterneAnwendung(String softwareName) {
        this.desktop.starteAnwendung(softwareName);
    }

    public void starteExterneAnwendung(String softwareName, String[] param) {
        this.desktop.starteAnwendung(softwareName, param);
    }

    public String[] holeParameter() {
        return this.desktop.getParameter();
    }

    public void zeigePopupMenu(JPopupMenu menu, int x, int y) {
        menu.show(this.desktop, x, y);
    }

    public void starten(String[] param) {
    }
}

