/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.nachrichtensicht.ExchangeDialog;
import filius.rahmenprogramm.I18n;
import filius.software.system.SystemSoftware;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;

public class ButtonTabComponent
extends JPanel
implements I18n {
    private ExchangeDialog lauscherDialog;
    private SystemSoftware systemSoftware;
    private String macAddress;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
            }
        }
    };

    public ButtonTabComponent(ExchangeDialog dialog, SystemSoftware system, String macAddress) {
        super(new FlowLayout(0, 0, 0));
        this.lauscherDialog = dialog;
        this.systemSoftware = system;
        this.macAddress = macAddress;
        this.setOpaque(false);
        JLabel label = new JLabel();
        label.setText(this.systemSoftware.getKnoten().holeAnzeigeName());
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton button = new TabButton();
        this.add(button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText(I18n.messages.getString("buttontabcomponent_msg1"));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ButtonTabComponent.this.lauscherDialog.removeTable(ButtonTabComponent.this.macAddress, ButtonTabComponent.this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            int posX = 3;
            int posY = 3;
            int breite = 12;
            int hoehe = 12;
            Rectangle rechteck = new Rectangle(posX, posY, breite, hoehe);
            g2.setColor(new Color(255, 0, 0));
            g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g2.fillRoundRect(posX, posY, breite, hoehe, 3, 3);
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setColor(new Color(255, 255, 255));
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(posX + 3, posY + 3, posX + breite - 3, posY + hoehe - 3);
            g2.drawLine(posX + breite - 3, posY + 3, posX + 3, posY + hoehe - 3);
        }
    }
}

