/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.nachrichtensicht.ExchangeDialog;
import filius.gui.nachrichtensicht.LayeredMessageTable;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import filius.software.system.SystemSoftware;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class LayeredExchangeDialog
extends JDialog
implements ExchangeDialog,
I18n {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private static LayeredExchangeDialog lauscherDialog = null;
    private Hashtable<String, JPanel> openedTabs = new Hashtable();
    private Hashtable<String, LayeredMessageTable> tabellen = new Hashtable();

    public static synchronized LayeredExchangeDialog getInstance(Frame owner) {
        if (lauscherDialog == null) {
            lauscherDialog = new LayeredExchangeDialog(owner);
        }
        return lauscherDialog;
    }

    @Override
    public void reset() {
        if (lauscherDialog != null) {
            lauscherDialog.setVisible(false);
        }
        lauscherDialog = null;
    }

    private LayeredExchangeDialog(Frame owner) {
        super(owner);
        ((JFrame)owner).getLayeredPane().setLayer(this, JLayeredPane.PALETTE_LAYER);
        this.setTitle(messages.getString("lauscherdialog_msg1"));
        this.setBounds(20, (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 350, (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() - 40, 300);
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/gfx/allgemein/nachrichtenfenster_icon.png"));
        this.setIconImage(image);
        this.setModal(false);
        this.setDefaultCloseOperation(1);
        this.openedTabs.clear();
        this.tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.setVisible(false);
    }

    @Override
    public void addTable(SystemSoftware system, String identifier) {
        if (this.openedTabs.get(identifier) == null) {
            LayeredMessageTable tabelle = new LayeredMessageTable(this, identifier);
            tabelle.update();
            JPanel panel = new JPanel(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane(tabelle);
            tabelle.setScrollPane(scrollPane);
            panel.add((Component)scrollPane, "Center");
            String ipAddress = ((InternetKnoten)system.getKnoten()).getNetzwerkInterfaceByMac(identifier).getIp();
            String tabTitle = system.getKnoten() instanceof Host && ((Host)system.getKnoten()).isUseIPAsName() ? ipAddress : system.getKnoten().holeAnzeigeName() + " - " + ipAddress;
            this.tabbedPane.add(tabTitle, panel);
            this.tabbedPane.setSelectedComponent(panel);
            this.openedTabs.put(identifier, panel);
            this.tabellen.put(identifier, tabelle);
        } else {
            this.tabbedPane.setSelectedComponent(this.openedTabs.get(identifier));
            this.tabellen.get(identifier).update();
        }
    }

    @Override
    public void removeTable(String mac, JPanel panel) {
        if (mac != null) {
            this.openedTabs.remove(mac);
            this.tabellen.remove(mac);
            this.tabbedPane.remove(panel);
        }
    }
}

