/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.Main;
import filius.gui.JMainFrame;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class JSidebarButton
extends JLabel
implements Observer,
I18n {
    private static final long serialVersionUID = 1L;
    private String typ;
    private boolean selektiert;
    private boolean modemVerbunden;

    public boolean isSelektiert() {
        return this.selektiert;
    }

    public void setSelektiert(boolean selektiert) {
        this.selektiert = selektiert;
    }

    public String getTyp() {
        return this.typ;
    }

    public void setTyp(String typ) {
        this.typ = typ;
    }

    public JSidebarButton() {
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
    }

    private JSidebarButton(String text, Icon icon) {
        super(text, icon, 0);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
    }

    public JSidebarButton(String text, Icon icon, String typ) {
        this(text, icon);
        this.typ = typ;
        this.setAlignmentX(0.5f);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle((int)super.getBounds().getX(), (int)super.getBounds().getY(), this.getWidth(), this.getHeight());
    }

    public boolean inBounds(int x, int y) {
        return x >= this.getX() && x <= this.getX() + this.getWidth() && y >= this.getY() && y <= this.getY() + this.getHeight();
    }

    @Override
    public int getWidth() {
        int width = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
        if (this.getIcon() != null && this.getIcon().getIconWidth() > (width += 5)) {
            width = this.getIcon().getIconWidth();
        }
        return width;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public int getHeight() {
        int height = this.getFontMetrics(this.getFont()).getHeight();
        if (this.getIcon() != null) {
            height += this.getIcon().getIconHeight();
        }
        return height += 5;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.selektiert) {
            g.setColor(new Color(0, 0, 0));
            Graphics2D g2 = (Graphics2D)g;
            BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{2.0f}, 0.0f);
            g2.setStroke(stroke);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(new Color(128, 200, 255));
            g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
            g2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        if (this.modemVerbunden) {
            g2d.setColor(new Color(0, 255, 0));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fillOval(this.getWidth() / 2 - 6, this.getHeight() / 2 - 6, 12, 12);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JSidebarButton), update(" + o + "," + arg + ")");
        if (arg != null && arg.equals(Boolean.TRUE)) {
            this.modemVerbunden = true;
        } else if (arg != null && arg.equals(Boolean.FALSE)) {
            this.modemVerbunden = false;
        } else if (arg != null && arg instanceof String) {
            JOptionPane.showMessageDialog(JMainFrame.getJMainFrame(), arg);
        } else if (arg != null && arg instanceof Host) {
            this.setText(((Host)arg).holeAnzeigeName());
        }
        if (arg != null && arg instanceof InternetKnoten) {
            this.updateTooltip((InternetKnoten)arg);
        }
        this.updateUI();
    }

    void updateTooltip(InternetKnoten knoten) {
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html><pre>");
        tooltip.append(messages.getString("jsidebar_tooltip_ipAddress")).append(":");
        String gateway = null;
        String dns = null;
        for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
            tooltip.append("\n ").append(nic.getIp()).append(" / ").append(nic.getSubnetzMaske());
            tooltip.append(" (").append(nic.getMac()).append(")");
            gateway = nic.getGateway();
            dns = nic.getDns();
        }
        tooltip.append("\n").append(messages.getString("jsidebar_tooltip_gateway")).append(": ").append(gateway);
        if (knoten instanceof Host) {
            tooltip.append("\n").append(messages.getString("jsidebar_tooltip_dnsServer")).append(": ").append(dns);
        }
        tooltip.append("</pre></html>");
        this.setToolTipText(tooltip.toString());
    }
}

