/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dhcp;

import filius.software.dhcp.DHCPMessageType;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DHCPMessage {
    private static final String FIELD_SEPARATOR = "\n";
    private static final String PARAM_SERVERIDENT = "serverident";
    private static final String PARAM_REQUESTED = "requested";
    private static final String PARAM_DNSSERVER = "dnsserver";
    private static final String PARAM_SUBNETMASK = "subnetmask";
    private static final String PARAM_ROUTER = "router";
    private static final String PARAM_CHADDR = "chaddr";
    private static final String PARAM_YIADDR = "yiaddr";
    private static final String BLANK_IP_ADDRESS = "0.0.0.0";
    DHCPMessageType type = DHCPMessageType.DISCOVER;
    String yiaddr = "0.0.0.0";
    String chaddr;
    String optionSubnetMask;
    String optionRouter;
    String optionDnsServer;
    String optionServerIdentifier;
    String optionRequestedAddress;

    DHCPMessage() {
    }

    public DHCPMessageType getType() {
        return this.type;
    }

    public String getYiaddr() {
        return this.yiaddr;
    }

    public String getChaddr() {
        return this.chaddr;
    }

    public String getSubnetMask() {
        return this.optionSubnetMask;
    }

    public String getRouter() {
        return this.optionRouter;
    }

    public String getDnsServer() {
        return this.optionDnsServer;
    }

    public String getServerIdentifier() {
        return this.optionServerIdentifier;
    }

    public String getRequestedAddress() {
        return this.optionRequestedAddress;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.type.toString());
        builder.append(FIELD_SEPARATOR).append(PARAM_YIADDR).append("=").append(this.yiaddr);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.chaddr})) {
            builder.append(FIELD_SEPARATOR).append(PARAM_CHADDR).append("=").append(this.chaddr);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.optionRouter})) {
            builder.append(FIELD_SEPARATOR).append(PARAM_ROUTER).append("=").append(this.optionRouter);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.optionSubnetMask})) {
            builder.append(FIELD_SEPARATOR).append(PARAM_SUBNETMASK).append("=").append(this.optionSubnetMask);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.optionDnsServer})) {
            builder.append(FIELD_SEPARATOR).append(PARAM_DNSSERVER).append("=").append(this.optionDnsServer);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.optionRequestedAddress})) {
            builder.append(FIELD_SEPARATOR).append(PARAM_REQUESTED).append("=").append(this.optionRequestedAddress);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.optionServerIdentifier})) {
            builder.append(FIELD_SEPARATOR).append(PARAM_SERVERIDENT).append("=").append(this.optionServerIdentifier);
        }
        return builder.toString();
    }

    static DHCPMessage fromString(String dhcpMessageString) {
        DHCPMessage message = new DHCPMessage();
        StringTokenizer tokenizer = new StringTokenizer(dhcpMessageString, "\n=");
        if (tokenizer.hasMoreTokens()) {
            message.type = DHCPMessageType.fromString(tokenizer.nextToken());
        }
        while (tokenizer.hasMoreTokens()) {
            String keyToken = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            switch (keyToken) {
                case "chaddr": {
                    message.chaddr = tokenizer.nextToken();
                    break;
                }
                case "dnsserver": {
                    message.optionDnsServer = tokenizer.nextToken();
                    break;
                }
                case "requested": {
                    message.optionRequestedAddress = tokenizer.nextToken();
                    break;
                }
                case "router": {
                    message.optionRouter = tokenizer.nextToken();
                    break;
                }
                case "serverident": {
                    message.optionServerIdentifier = tokenizer.nextToken();
                    break;
                }
                case "subnetmask": {
                    message.optionSubnetMask = tokenizer.nextToken();
                    break;
                }
                case "yiaddr": {
                    message.yiaddr = tokenizer.nextToken();
                }
            }
        }
        return message;
    }

    public boolean equals(Object other) {
        boolean equals = true;
        if (!(other instanceof DHCPMessage)) {
            equals = false;
        } else if (ObjectUtils.notEqual((Object)this.chaddr, (Object)((DHCPMessage)other).chaddr)) {
            equals = false;
        } else if (ObjectUtils.notEqual((Object)this.optionDnsServer, (Object)((DHCPMessage)other).optionDnsServer)) {
            equals = false;
        } else if (ObjectUtils.notEqual((Object)this.optionRequestedAddress, (Object)((DHCPMessage)other).optionRequestedAddress)) {
            equals = false;
        } else if (ObjectUtils.notEqual((Object)this.optionRouter, (Object)((DHCPMessage)other).optionRouter)) {
            equals = false;
        } else if (ObjectUtils.notEqual((Object)this.optionServerIdentifier, (Object)((DHCPMessage)other).optionServerIdentifier)) {
            equals = false;
        } else if (ObjectUtils.notEqual((Object)this.optionSubnetMask, (Object)((DHCPMessage)other).optionSubnetMask)) {
            equals = false;
        } else if (ObjectUtils.notEqual((Object)this.yiaddr, (Object)((DHCPMessage)other).yiaddr)) {
            equals = false;
        }
        return equals;
    }

    public int hashCode() {
        return Objects.hash(this.chaddr, this.optionDnsServer, this.optionRequestedAddress, this.optionRouter, this.optionServerIdentifier, this.optionSubnetMask, this.yiaddr);
    }

    static DHCPMessage createDiscoverMessage(String clientMacAddress) {
        DHCPMessage discoverMessage = new DHCPMessage();
        discoverMessage.type = DHCPMessageType.DISCOVER;
        discoverMessage.chaddr = clientMacAddress;
        return discoverMessage;
    }

    static DHCPMessage createOfferMessage(String clientMacAddress, String offeredIpAddress, String subnetMask, String router, String dnsServer, String serverIdentifier) {
        DHCPMessage offerMessage = new DHCPMessage();
        offerMessage.type = DHCPMessageType.OFFER;
        offerMessage.chaddr = clientMacAddress;
        offerMessage.yiaddr = offeredIpAddress;
        offerMessage.optionSubnetMask = subnetMask;
        offerMessage.optionRouter = router;
        offerMessage.optionDnsServer = dnsServer;
        offerMessage.optionServerIdentifier = serverIdentifier;
        return offerMessage;
    }

    static DHCPMessage createRequestMessage(String clientMacAddress, String requestedIpAddress, String serverIdentifier) {
        DHCPMessage requestMessage = new DHCPMessage();
        requestMessage.type = DHCPMessageType.REQUEST;
        requestMessage.chaddr = clientMacAddress;
        requestMessage.optionRequestedAddress = requestedIpAddress;
        requestMessage.optionServerIdentifier = serverIdentifier;
        return requestMessage;
    }

    static DHCPMessage createDeclineMessage(String clientMacAddress, String requestedIpAddress, String serverIdentifier) {
        DHCPMessage declineMessage = new DHCPMessage();
        declineMessage.type = DHCPMessageType.DECLINE;
        declineMessage.chaddr = clientMacAddress;
        declineMessage.optionRequestedAddress = requestedIpAddress;
        declineMessage.optionServerIdentifier = serverIdentifier;
        return declineMessage;
    }

    static DHCPMessage createAckMessage(String clientMacAddress, String acknowledgedIpAddress, String serverIdentifier) {
        DHCPMessage ackMessage = new DHCPMessage();
        ackMessage.type = DHCPMessageType.ACK;
        ackMessage.chaddr = clientMacAddress;
        ackMessage.yiaddr = acknowledgedIpAddress;
        ackMessage.optionServerIdentifier = serverIdentifier;
        return ackMessage;
    }

    static DHCPMessage createNackMessage(String clientMacAddress, String notAcknowledgedIpAddress, String serverIdentifier) {
        DHCPMessage nackMessage = new DHCPMessage();
        nackMessage.type = DHCPMessageType.NACK;
        nackMessage.chaddr = clientMacAddress;
        nackMessage.yiaddr = notAcknowledgedIpAddress;
        nackMessage.optionServerIdentifier = serverIdentifier;
        return nackMessage;
    }
}

