/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dhcp;

import filius.exception.AddressRequestNotAcceptedException;
import filius.exception.NoAvailableAddressException;
import filius.software.clientserver.ServerMitarbeiter;
import filius.software.dhcp.DHCPMessage;
import filius.software.dhcp.DHCPMessageType;
import filius.software.dhcp.DHCPServer;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.UDPSocket;
import org.apache.commons.lang3.StringUtils;

public class DHCPServerMitarbeiter
extends ServerMitarbeiter {
    public DHCPServerMitarbeiter(DHCPServer server, Socket socket) {
        super(server, socket);
    }

    @Override
    protected void verarbeiteNachricht(String nachricht) {
        DHCPMessage dhcpMessage = DHCPMessage.fromString(nachricht);
        if (DHCPMessageType.DISCOVER.equals((Object)dhcpMessage.getType())) {
            this.processDiscover(dhcpMessage.getChaddr());
        } else if (DHCPMessageType.REQUEST.equals((Object)dhcpMessage.getType())) {
            this.processRequest(dhcpMessage.getChaddr(), dhcpMessage.getRequestedAddress(), dhcpMessage.getServerIdentifier());
        }
    }

    void processDiscover(String mac) {
        DHCPServer dhcpServer = (DHCPServer)this.server;
        UDPSocket udpSocket = (UDPSocket)this.socket;
        try {
            String serverIpAddress = dhcpServer.holeServerIpAddress();
            DHCPMessage response = DHCPMessage.createOfferMessage(mac, dhcpServer.offerAddress(mac), dhcpServer.getSubnetzmaske(), dhcpServer.getGatewayip(), dhcpServer.getDnsserverip(), serverIpAddress);
            udpSocket.sendeBroadcast(serverIpAddress, response.toString());
        }
        catch (NoAvailableAddressException noAvailableAddressException) {
            // empty catch block
        }
    }

    void processRequest(String mac, String ip, String serverIdentifier) {
        DHCPServer dhcpServer = (DHCPServer)this.server;
        UDPSocket udpSocket = (UDPSocket)this.socket;
        String serverIpAddress = dhcpServer.holeServerIpAddress();
        if (StringUtils.equalsIgnoreCase((CharSequence)serverIdentifier, (CharSequence)serverIpAddress)) {
            DHCPMessage response;
            try {
                response = DHCPMessage.createAckMessage(mac, dhcpServer.requestAddress(mac, ip).getIp(), serverIpAddress);
            }
            catch (AddressRequestNotAcceptedException e) {
                response = DHCPMessage.createNackMessage(mac, ip, serverIpAddress);
            }
            udpSocket.sendeBroadcast(serverIpAddress, response.toString());
        } else {
            dhcpServer.blacklistAddress(ip);
        }
    }
}

