/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.Main;
import filius.software.clientserver.UDPServerAnwendung;
import filius.software.dns.DNSServerMitarbeiter;
import filius.software.dns.ResourceRecord;
import filius.software.system.Datei;
import filius.software.system.Dateisystem;
import filius.software.transportschicht.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class DNSServer
extends UDPServerAnwendung {
    private boolean recursiveResolutionEnabled = false;

    public boolean isRecursiveResolutionEnabled() {
        return this.recursiveResolutionEnabled;
    }

    public void setRecursiveResolutionEnabled(boolean recursiveResolutionEnabled) {
        this.recursiveResolutionEnabled = recursiveResolutionEnabled;
    }

    public DNSServer() {
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), constr: DNSServer()");
        this.setPort(53);
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), starten()");
        super.starten();
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        if (!dateisystem.dateiVorhanden("/dns", "hosts")) {
            dateisystem.erstelleVerzeichnis(dateisystem.getRoot(), "dns");
            Datei hostsFile = new Datei();
            hostsFile.setName("hosts");
            hostsFile.setDateiInhalt("");
            dateisystem.speicherDatei("/dns", hostsFile);
        }
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), beenden()");
        super.beenden();
    }

    public List<ResourceRecord> holeResourceRecords() {
        return this.leseRecordListe();
    }

    public void hinzuRecord(String domainname, String typ, String rdata) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), hinzuRecord(" + domainname + "," + typ + "," + rdata + ")");
        ResourceRecord rr = new ResourceRecord(domainname, typ, rdata);
        List<ResourceRecord> rrList = this.leseRecordListe();
        rrList.add(rr);
        this.schreibeRecordListe(rrList);
    }

    private List<ResourceRecord> leseRecordListe() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + ", initialisiereRecordListe()");
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        Datei hosts = dateisystem.holeDatei("/dns/hosts");
        LinkedList<ResourceRecord> resourceRecords = new LinkedList<ResourceRecord>();
        if (hosts != null) {
            StringTokenizer tokenizer = new StringTokenizer(hosts.getDateiInhalt(), "\n");
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken().trim();
                if (line.equals("") || line.split(" ", 5).length < 4) continue;
                ResourceRecord rr = new ResourceRecord(line);
                resourceRecords.add(rr);
            }
        }
        return resourceRecords;
    }

    private void schreibeRecordListe(List<ResourceRecord> records) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), schreibeRecordListe()");
        StringBuffer text = new StringBuffer();
        for (ResourceRecord resourceRecord : records) {
            text.append(resourceRecord.toString() + "\n");
        }
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        Datei hostsFile = dateisystem.holeDatei(dateisystem.holeRootPfad() + "/" + "dns", "hosts");
        if (hostsFile == null) {
            hostsFile = new Datei();
            hostsFile.setName("hosts");
            dateisystem.speicherDatei(dateisystem.holeRootPfad() + "/" + "dns", hostsFile);
        }
        hostsFile.setDateiInhalt(text.toString());
    }

    public void changeSingleEntry(int recordIdx, int partIdx, String type, String newValue) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", changeSingleEntry(" + recordIdx + "," + partIdx + "," + type + "," + newValue + ")");
        List<ResourceRecord> rrList = this.leseRecordListe();
        int countA = 0;
        for (ResourceRecord rrec : rrList) {
            if (rrec.getType().equals(type)) {
                ++countA;
            }
            if (countA - 1 != recordIdx) continue;
            if (partIdx == 0) {
                rrec.setDomainname(newValue);
                continue;
            }
            if (partIdx != 3) continue;
            rrec.setRdata(newValue);
        }
        this.schreibeRecordListe(rrList);
        this.benachrichtigeBeobachter(type);
    }

    public void loescheResourceRecord(String domainname, String typ) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), loescheResourceRecord(" + domainname + "," + typ + ")");
        List<ResourceRecord> rrList = this.leseRecordListe();
        for (ResourceRecord rr : rrList) {
            if (!rr.getDomainname().equalsIgnoreCase(domainname) || !rr.getType().equals(typ)) continue;
            rrList.remove(rr);
            break;
        }
        this.schreibeRecordListe(rrList);
    }

    public ResourceRecord holeRecord(String domainname, String typ) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), holeRecord(" + domainname + "," + typ + ")");
        for (ResourceRecord rr : this.leseRecordListe()) {
            if (!rr.getDomainname().equalsIgnoreCase(domainname) || !rr.getType().equals(typ)) continue;
            return rr;
        }
        return null;
    }

    public ResourceRecord holeNSRecord(String domainname) {
        String[] parts = domainname.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            String domain = this.implodeDomain(parts, i);
            for (ResourceRecord rr : this.leseRecordListe()) {
                if (!rr.getDomainname().equalsIgnoreCase(domain) || !rr.getType().equals("NS")) continue;
                return rr;
            }
        }
        for (ResourceRecord rr : this.leseRecordListe()) {
            if (!rr.getDomainname().equalsIgnoreCase(".")) continue;
            return rr;
        }
        return null;
    }

    private String implodeDomain(String[] parts, int start) {
        StringBuffer domain = new StringBuffer();
        for (int i = start; i < parts.length; ++i) {
            domain.append(parts[i]);
            domain.append(".");
        }
        return domain.toString();
    }

    @Override
    protected void neuerMitarbeiter(Socket socket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), neuerMitarbeiter(" + socket + ")");
        DNSServerMitarbeiter dnsMitarbeiter = new DNSServerMitarbeiter(this, socket);
        dnsMitarbeiter.starten();
        this.mitarbeiter.add(dnsMitarbeiter);
    }
}

