/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.Main;
import java.util.StringTokenizer;

public class ResourceRecord {
    public static final String ADDRESS = "A";
    public static final String MAIL_EXCHANGE = "MX";
    public static final String NAME_SERVER = "NS";
    private String domainname = null;
    private String type = null;
    private int ttl = 3600;
    private String rdata = null;

    public ResourceRecord(String domainname, String typ, String rdata) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ResourceRecord), constr: ResourceRecord(" + domainname + "," + typ + "," + rdata + ")");
        this.setDomainname(domainname);
        this.type = typ;
        this.setRdata(rdata);
    }

    public ResourceRecord(String rr) {
        String token;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ResourceRecord), constr: ResourceRecord(" + rr + ")");
        StringTokenizer tokenizer = new StringTokenizer(rr, " ");
        if (tokenizer.hasMoreTokens()) {
            this.domainname = token = tokenizer.nextToken().trim();
        }
        if (tokenizer.hasMoreTokens()) {
            this.type = token = tokenizer.nextToken().trim();
        }
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().trim();
            try {
                this.ttl = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                Main.debug.println("EXCEPTION: NumberFormatException, TTL field: '" + token + "'");
                e.printStackTrace(Main.debug);
            }
        }
        if (tokenizer.hasMoreTokens()) {
            this.rdata = token = tokenizer.nextToken().trim();
        }
    }

    public String toString() {
        return this.getDomainname() + " " + this.type + " " + this.ttl + " " + this.getRdata();
    }

    public String getDomainname() {
        if (this.domainname.matches(".*\\.$")) {
            return this.domainname;
        }
        return this.domainname + ".";
    }

    public void setDomainname(String domainname) {
        this.domainname = domainname.matches(".*\\.$") ? domainname : domainname + ".";
    }

    public String getRdata() {
        if ((this.type.equals(NAME_SERVER) || this.type.equals(MAIL_EXCHANGE)) && !this.rdata.matches(".*\\.")) {
            return this.rdata + ".";
        }
        return this.rdata;
    }

    public void setRdata(String rdata) {
        this.rdata = (this.type.equals(NAME_SERVER) || this.type.equals(MAIL_EXCHANGE)) && !rdata.matches(".*\\.") ? rdata + "." : rdata;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

