/*
 * Decompiled with CFR 0.152.
 */
package filius.software.firewall;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.Anwendung;
import filius.software.firewall.FirewallRule;
import filius.software.firewall.FirewallThread;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Segment;
import filius.software.transportschicht.TcpSegment;
import filius.software.transportschicht.UdpSegment;
import filius.software.vermittlungsschicht.IpPaket;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Firewall
extends Anwendung
implements I18n {
    public static int PERSONAL = 1;
    public static int GATEWAY = 2;
    public static String ABSENDER_FILTER = "Quelle";
    public static String EMPFAENGER_FILTER = "Ziel";
    private Vector<FirewallRule> ruleset;
    private short defaultPolicy = 0;
    private boolean verbindungsaufbauAblehnen = false;
    private boolean activated = true;
    private boolean doDropICMP = false;
    private boolean allowRelatedPackets = true;
    private int modus = PERSONAL;
    private LinkedList<FirewallThread> threads = new LinkedList();
    private Vector<Integer> inactiveNics = new Vector();

    public Firewall() {
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), constr: Firewall()");
        this.defaultPolicy = 0;
        this.ruleset = new Vector();
    }

    @Override
    public void starten() {
        if (this.holeNetzwerkInterfaces() != null) {
            Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), starten()");
            super.starten();
            for (NetzwerkInterface nic : this.holeNetzwerkInterfaces()) {
                this.starteFirewallThread(nic);
            }
        }
    }

    private void starteFirewallThread(NetzwerkInterface nic) {
        FirewallThread thread = new FirewallThread(this, nic);
        thread.starten();
        this.threads.add(thread);
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), beenden()");
        super.beenden();
        this.beendeFirewallThread(null);
    }

    private void beendeFirewallThread(NetzwerkInterface nic) {
        for (FirewallThread thread : this.threads) {
            if (nic == null) {
                thread.beenden();
                continue;
            }
            if (nic != thread.getNetzwerkInterface()) continue;
            thread.beenden();
            break;
        }
    }

    public boolean allowedIPpacket(IpPaket ipPacket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), allowedIPpacket(" + ipPacket + ")");
        if (this.isActivated()) {
            if (this.getAllowRelatedPackets() && ipPacket.getProtocol() == 6) {
                boolean isSyn = ((TcpSegment)ipPacket.getSegment()).isSyn();
                boolean isAck = ((TcpSegment)ipPacket.getSegment()).isAck();
                if (!isSyn || isAck) {
                    return true;
                }
            }
            if (this.modus == PERSONAL && ipPacket.getSegment() instanceof UdpSegment) {
                return true;
            }
            boolean ruleMatch = true;
            for (int i = 0; i < this.ruleset.size(); ++i) {
                ruleMatch = true;
                if (!this.ruleset.get((int)i).srcIP.isEmpty()) {
                    if (this.ruleset.get((int)i).srcIP.equals(FirewallRule.SAME_NETWORK)) {
                        ListIterator<NetzwerkInterface> it = ((InternetKnoten)this.getSystemSoftware().getKnoten()).getNetzwerkInterfaces().listIterator();
                        boolean foundNIC = false;
                        while (it.hasNext() && !foundNIC) {
                            NetzwerkInterface iface = it.next();
                            if (!VermittlungsProtokoll.gleichesRechnernetz(ipPacket.getSender(), iface.getIp(), iface.getSubnetzMaske())) continue;
                            foundNIC = true;
                        }
                        ruleMatch = ruleMatch && foundNIC;
                    } else {
                        boolean bl = ruleMatch = ruleMatch && VermittlungsProtokoll.gleichesRechnernetz(ipPacket.getSender(), this.ruleset.get((int)i).srcIP, this.ruleset.get((int)i).srcMask);
                    }
                }
                if (!this.ruleset.get((int)i).destIP.isEmpty()) {
                    boolean bl = ruleMatch = ruleMatch && VermittlungsProtokoll.gleichesRechnernetz(ipPacket.getEmpfaenger(), this.ruleset.get((int)i).destIP, this.ruleset.get((int)i).destMask);
                }
                if (this.ruleset.get((int)i).protocol != -1) {
                    boolean bl = ruleMatch = ruleMatch && ipPacket.getProtocol() == this.ruleset.get((int)i).protocol;
                }
                if (this.ruleset.get((int)i).port != -1) {
                    boolean bl = ruleMatch = ruleMatch && (((Segment)ipPacket.getSegment()).getZielPort() == this.ruleset.get((int)i).port || ((Segment)ipPacket.getSegment()).getQuellPort() == this.ruleset.get((int)i).port);
                }
                if (!ruleMatch) continue;
                this.benachrichtigeBeobachter(messages.getString("sw_firewall_msg8") + " #" + (i + 1) + " (" + this.ruleset.get(i).toString(this.holeNetzwerkInterfaces()) + ")  -> " + (this.ruleset.get((int)i).action == 1 ? messages.getString("jfirewalldialog_msg33") : messages.getString("jfirewalldialog_msg34")));
                return this.ruleset.get((int)i).action == 1;
            }
            this.benachrichtigeBeobachter(messages.getString("sw_firewall_msg9") + " " + (this.defaultPolicy == 1 ? messages.getString("jfirewalldialog_msg33") : messages.getString("jfirewalldialog_msg34")));
            return this.defaultPolicy == 1;
        }
        return true;
    }

    public boolean moveUp(int id) {
        if (id <= this.ruleset.size() && id > 1) {
            FirewallRule currRule = this.ruleset.get(id - 1);
            this.ruleset.remove(id - 1);
            this.ruleset.insertElementAt(currRule, id - 2);
            return true;
        }
        return false;
    }

    public boolean moveDown(int id) {
        if (id >= 0 && id < this.ruleset.size()) {
            FirewallRule currRule = this.ruleset.get(id - 1);
            this.ruleset.remove(id - 1);
            this.ruleset.insertElementAt(currRule, id);
            return true;
        }
        return false;
    }

    public void addRule() {
        this.ruleset.add(new FirewallRule());
    }

    public void addRule(FirewallRule rule) {
        this.ruleset.add(rule);
    }

    public void delRule(int id) {
        if (id >= 0 && id <= this.ruleset.size()) {
            this.ruleset.remove(id - 1);
        }
    }

    public String changeSingleEntry(int row, int col, String value) {
        if (row > this.ruleset.size() - 1) {
            return "";
        }
        if (col != 0) {
            if (col == 1) {
                this.ruleset.get((int)row).srcIP = value;
            } else if (col == 2) {
                this.ruleset.get((int)row).srcMask = value;
            } else if (col == 3) {
                this.ruleset.get((int)row).destIP = value;
            } else if (col == 4) {
                this.ruleset.get((int)row).destMask = value;
            } else if (col == 5) {
                if (value.equals("TCP")) {
                    this.ruleset.get((int)row).protocol = (short)6;
                } else if (value.equals("UDP")) {
                    this.ruleset.get((int)row).protocol = (short)17;
                } else if (value.equals("ICMP")) {
                    this.ruleset.get((int)row).protocol = 1;
                } else if (value.equals("*")) {
                    this.ruleset.get((int)row).protocol = (short)-1;
                    return "";
                }
            } else if (col == 6) {
                try {
                    int portInt;
                    this.ruleset.get((int)row).port = portInt = Integer.parseInt(value);
                }
                catch (Exception exception) {}
            } else if (col == 7) {
                this.ruleset.get((int)row).action = value.equals(messages.getString("jfirewalldialog_msg33")) ? (short)1 : 0;
            }
        }
        return value;
    }

    public void eintragHinzufuegen(String von, String bis, String typ) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), eintragHinzufuegen(" + von + "," + bis + "," + typ + ")");
        if (!EingabenUeberpruefung.isGueltig(von, EingabenUeberpruefung.musterIpAdresse) || !EingabenUeberpruefung.isGueltig(bis, EingabenUeberpruefung.musterIpAdresseAuchLeer)) {
            return;
        }
        if (bis.equals("")) {
            bis = " ";
        }
        if (typ.equals(ABSENDER_FILTER)) {
            FirewallRule newRule = new FirewallRule(von, "", "", "", -1, -1, 1);
            newRule.srcMask = bis.equals(" ") ? "255.255.255.255" : "255.255.255.0";
            this.ruleset.add(newRule);
            this.benachrichtigeBeobachter(messages.getString("sw_firewall_msg4") + von + " - " + bis);
        } else if (typ.equals(EMPFAENGER_FILTER)) {
            FirewallRule newRule = new FirewallRule("", "", von, "", -1, -1, 1);
            newRule.destMask = bis.equals(" ") ? "255.255.255.255" : "255.255.255.0";
            this.ruleset.add(newRule);
            this.benachrichtigeBeobachter(messages.getString("sw_firewall_msg4") + von + " - " + bis);
        }
    }

    public void eintragHinzufuegenPort(String port) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), eintragHinzufuegenPort(" + port + ")");
        this.eintragHinzufuegenPort(port, Boolean.FALSE);
    }

    public void eintragHinzufuegenPort(String port, boolean unterscheideNetzwerk) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), eintragHinzufuegenPort(" + port + "," + unterscheideNetzwerk + ")");
        if (port != null) {
            int portNum = -1;
            try {
                portNum = Integer.parseInt(port);
                FirewallRule newRule = new FirewallRule("", "", "", "", portNum, -1, 1);
                if (unterscheideNetzwerk) {
                    newRule.srcIP = FirewallRule.SAME_NETWORK;
                }
                this.ruleset.add(newRule);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.benachrichtigeBeobachter(messages.getString("sw_firewall_msg5") + port);
        }
    }

    public void entferneRegelPort(int nummer) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), entferneRegel(" + nummer + ")");
        if (nummer < this.ruleset.size()) {
            this.ruleset.remove(nummer);
        }
    }

    private boolean inPruefbereich(String untereGrenze, String obereGrenze, String pruefWert) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (Firewall), inPruefbereich(" + untereGrenze + "," + obereGrenze + "," + pruefWert + ")");
        boolean pruef = false;
        StringTokenizer untereTokens = new StringTokenizer(untereGrenze, ".");
        double ersteZahl = Integer.parseInt(untereTokens.nextToken());
        double zweiteZahl = Integer.parseInt(untereTokens.nextToken());
        double dritteZahl = Integer.parseInt(untereTokens.nextToken());
        double vierteZahl = Integer.parseInt(untereTokens.nextToken());
        double untereSumme = (ersteZahl *= 1.6777216E7) + (zweiteZahl *= 65536.0) + (dritteZahl *= 256.0) + vierteZahl;
        StringTokenizer obereTokens = new StringTokenizer(obereGrenze, ".");
        double ersteObereZahl = Integer.parseInt(obereTokens.nextToken());
        double zweiteObereZahl = Integer.parseInt(obereTokens.nextToken());
        double dritteObereZahl = Integer.parseInt(obereTokens.nextToken());
        double vierteObereZahl = Integer.parseInt(obereTokens.nextToken());
        double obereSumme = (ersteObereZahl *= 1.6777216E7) + (zweiteObereZahl *= 65536.0) + (dritteObereZahl *= 256.0) + vierteObereZahl;
        StringTokenizer pruefTokens = new StringTokenizer(pruefWert, ".");
        double erstePruefZahl = Integer.parseInt(pruefTokens.nextToken());
        double zweitePruefZahl = Integer.parseInt(pruefTokens.nextToken());
        double drittePruefZahl = Integer.parseInt(pruefTokens.nextToken());
        double viertePruefZahl = Integer.parseInt(pruefTokens.nextToken());
        double pruefZahlSumme = (erstePruefZahl *= 1.6777216E7) + (zweitePruefZahl *= 65536.0) + (drittePruefZahl *= 256.0) + viertePruefZahl;
        if (pruefZahlSumme >= untereSumme && pruefZahlSumme <= obereSumme) {
            pruef = true;
        }
        return pruef;
    }

    @Override
    public void setSystemSoftware(InternetKnotenBetriebssystem bs) {
        super.setSystemSoftware(bs);
    }

    public boolean getRejectIncomingConnections() {
        return this.verbindungsaufbauAblehnen;
    }

    public void setRejectIncomingConnections(boolean active) {
        this.verbindungsaufbauAblehnen = active;
    }

    public Vector<FirewallRule> getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Vector<FirewallRule> rules) {
        this.ruleset = rules;
    }

    public void setModus(int modus) {
        this.modus = modus;
    }

    public int getModus() {
        return this.modus;
    }

    public void setzeNetzwerkInterfaces(LinkedList<NetzwerkInterface> netzwerkInterfaces) {
        List<NetzwerkInterface> allNics = this.getAllNetworkInterfaces();
        this.inactiveNics.removeAllElements();
        for (NetzwerkInterface nic : allNics) {
            if (netzwerkInterfaces.indexOf(nic) != -1) continue;
            this.inactiveNics.add(new Integer(allNics.indexOf(nic)));
        }
    }

    public List<NetzwerkInterface> holeNetzwerkInterfaces() {
        List<NetzwerkInterface> allNics = this.getAllNetworkInterfaces();
        LinkedList<NetzwerkInterface> result = new LinkedList<NetzwerkInterface>();
        for (NetzwerkInterface nic : allNics) {
            try {
                if (this.inactiveNics.contains(new Integer(allNics.indexOf(nic)))) continue;
                result.add(nic);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return result;
    }

    private List<NetzwerkInterface> getAllNetworkInterfaces() {
        InternetKnoten host = (InternetKnoten)this.getSystemSoftware().getKnoten();
        return host.getNetzwerkInterfaces();
    }

    public boolean hinzuNetzwerkInterface(NetzwerkInterface nic) {
        int idx = this.getAllNetworkInterfaces().indexOf(nic);
        if (this.inactiveNics.contains(new Integer(idx))) {
            this.inactiveNics.remove(new Integer(idx));
            if (this.running) {
                this.starteFirewallThread(nic);
            }
            return true;
        }
        return false;
    }

    public boolean entferneNetzwerkInterface(NetzwerkInterface nic) {
        int idx = this.getAllNetworkInterfaces().indexOf(nic);
        if (!this.inactiveNics.contains(new Integer(idx))) {
            this.inactiveNics.add(new Integer(idx));
            if (this.running) {
                this.beendeFirewallThread(nic);
            }
            return true;
        }
        return false;
    }

    public Vector<Integer> getInactiveNics() {
        return this.inactiveNics;
    }

    public void setInactiveNics(Vector<Integer> inactiveNics) {
        this.inactiveNics = inactiveNics;
    }

    public void setDefaultPolicyString(String langPolicy) {
        this.defaultPolicy = langPolicy.equals(messages.getString("jfirewalldialog_msg33")) ? (short)1 : 0;
    }

    public void setDefaultPolicy(short defPol) {
        this.defaultPolicy = defPol;
    }

    public short getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public String getDefaultPolicyString() {
        if (this.defaultPolicy == 1) {
            return messages.getString("jfirewalldialog_msg33");
        }
        if (this.defaultPolicy == 0) {
            return messages.getString("jfirewalldialog_msg34");
        }
        return "";
    }

    public void setDropICMP(boolean selState) {
        this.doDropICMP = selState;
    }

    public boolean getDropICMP() {
        return this.doDropICMP;
    }

    public void setAllowRelatedPackets(boolean selState) {
        this.allowRelatedPackets = selState;
    }

    public boolean getAllowRelatedPackets() {
        return this.allowRelatedPackets;
    }

    public void setActivated(boolean selState) {
        this.activated = selState;
    }

    public boolean isActivated() {
        return this.activated;
    }
}

