/*
 * Decompiled with CFR 0.152.
 */
package filius.software.firewall;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.I18n;
import filius.software.ProtokollThread;
import filius.software.firewall.Firewall;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.LinkedList;

public class FirewallThread
extends ProtokollThread
implements I18n {
    private LinkedList<EthernetFrame> ausgangsPuffer;
    private Firewall firewall;
    private NetzwerkInterface netzwerkInterface = null;

    public NetzwerkInterface getNetzwerkInterface() {
        return this.netzwerkInterface;
    }

    public FirewallThread(Firewall firewall, NetzwerkInterface nic) {
        super(new LinkedList());
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (FirewallThread), constr: FirewallThread(" + firewall + ")");
        this.firewall = firewall;
        this.netzwerkInterface = nic;
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (FirewallThread), starten()");
        super.starten();
        this.ausgangsPuffer = this.netzwerkInterface.getPort().holeEingangsPuffer();
        LinkedList<EthernetFrame> eingangsPuffer = this.holeEingangsPuffer();
        this.netzwerkInterface.getPort().setzeEingangsPuffer(eingangsPuffer);
    }

    @Override
    public void beenden() {
        super.beenden();
        this.netzwerkInterface.getPort().setzeEingangsPuffer(this.ausgangsPuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verarbeiteDatenEinheit(Object datenEinheit) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (FirewallThread), verarbeiteDatenEinheit(" + datenEinheit.toString() + ")");
        Object ipPaket = null;
        EthernetFrame frame = (EthernetFrame)datenEinheit;
        boolean isIcmp = frame.getDaten() instanceof IcmpPaket;
        if (this.firewall.isActivated() && this.firewall.getDropICMP() && isIcmp) {
            IcmpPaket icmp = (IcmpPaket)frame.getDaten();
            this.firewall.benachrichtigeBeobachter(messages.getString("firewallthread_msg1") + icmp.getQuellIp() + " -> " + icmp.getZielIp() + " (code: " + icmp.getIcmpCode() + ", type: " + icmp.getIcmpType() + ")");
            return;
        }
        if (frame.getDaten() != null && frame.getDaten() instanceof IpPaket && !this.firewall.allowedIPpacket((IpPaket)frame.getDaten())) {
            return;
        }
        LinkedList<EthernetFrame> linkedList = this.ausgangsPuffer;
        synchronized (linkedList) {
            this.ausgangsPuffer.add(frame);
            this.ausgangsPuffer.notify();
        }
    }
}

