/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.Protokoll;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.netzzugangsschicht.EthernetThread;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.LinkedList;

public class Ethernet
extends Protokoll {
    public static final String ETHERNET_BROADCAST = "FF:FF:FF:FF:FF:FF";
    private LinkedList<EthernetThread> threads = new LinkedList();
    private LinkedList<ArpPaket> arpPakete = new LinkedList();
    private LinkedList<IpPaket> ipPakete = new LinkedList();
    private LinkedList<IcmpPaket> icmpPakete = new LinkedList();

    public Ethernet(SystemSoftware systemSoftware) {
        super(systemSoftware);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (Ethernet), constr: Ethernet(" + systemSoftware + ")");
    }

    public LinkedList<ArpPaket> holeARPPuffer() {
        return this.arpPakete;
    }

    public LinkedList<IpPaket> holeIPPuffer() {
        return this.ipPakete;
    }

    public LinkedList<IcmpPaket> holeICMPPuffer() {
        return this.icmpPakete;
    }

    public void setzeIPPuffer(LinkedList<IpPaket> puffer) {
        this.ipPakete = puffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void senden(Object daten, String startMAC, String zielMAC, String typ) {
        LinkedList<EthernetFrame> linkedList;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Ethernet), senden(" + daten + "," + startMAC + "," + zielMAC + "," + typ + ")");
        boolean gesendet = false;
        EthernetFrame ethernetFrame = new EthernetFrame(daten, startMAC, zielMAC, typ, daten instanceof IcmpPaket);
        for (NetzwerkInterface nic : ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces()) {
            if (!nic.getMac().equalsIgnoreCase(zielMAC)) continue;
            linkedList = nic.getPort().holeEingangsPuffer();
            synchronized (linkedList) {
                nic.getPort().holeEingangsPuffer().add(ethernetFrame);
                nic.getPort().holeEingangsPuffer().notify();
            }
            gesendet = true;
        }
        if (!gesendet) {
            for (NetzwerkInterface nic : ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces()) {
                if (!nic.getMac().equalsIgnoreCase(startMAC)) continue;
                linkedList = nic.getPort().holeAusgangsPuffer();
                synchronized (linkedList) {
                    nic.getPort().holeAusgangsPuffer().add(ethernetFrame);
                    nic.getPort().holeAusgangsPuffer().notify();
                }
                Lauscher.getLauscher().addDatenEinheit(nic.getMac(), ethernetFrame);
            }
        }
    }

    public LinkedList<EthernetThread> getEthernetThreads() {
        return this.threads;
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Ethernet), starten()");
        if (this.holeSystemSoftware().getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.holeSystemSoftware().getKnoten();
            for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
                EthernetThread interfaceBeobachter = new EthernetThread(this, nic);
                interfaceBeobachter.starten();
                try {
                    this.threads.add(interfaceBeobachter);
                }
                catch (Exception e) {
                    e.printStackTrace(Main.debug);
                }
            }
        }
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Ethernet), beenden()");
        for (int x = 0; x < this.threads.size(); ++x) {
            EthernetThread interfaceBeobachter = this.threads.get(x);
            interfaceBeobachter.beenden();
        }
    }
}

