/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.Main;
import filius.hardware.Port;
import filius.hardware.knoten.Switch;
import filius.rahmenprogramm.I18n;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.netzzugangsschicht.SwitchPortBeobachter;
import filius.software.system.SystemSoftware;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;

public class SwitchFirmware
extends SystemSoftware
implements I18n {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Port> sat = null;
    private LinkedList<SwitchPortBeobachter> switchBeobachter;
    private LinkedList<EthernetFrame> durchgelaufeneFrames = new LinkedList();

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (SwitchFirmware), starten()");
        this.sat = new HashMap();
        this.switchBeobachter = new LinkedList();
        for (Port anschluss : ((Switch)this.getKnoten()).getAnschluesse()) {
            SwitchPortBeobachter anschlussBeobachter = new SwitchPortBeobachter(this, anschluss);
            anschlussBeobachter.starten();
            this.switchBeobachter.add(anschlussBeobachter);
        }
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (SwitchFirmware), beenden()");
        for (SwitchPortBeobachter anschlussBeobachter : this.switchBeobachter) {
            anschlussBeobachter.beenden();
        }
    }

    public Vector<Vector<String>> holeSAT() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (SwitchFirmware), holeSAT()");
        Vector<Vector<String>> eintraege = new Vector<Vector<String>>();
        for (String elem : this.sat.keySet()) {
            Port anschluss = this.sat.get(elem);
            String ausgabe = messages.getString("sw_switchfirmware_msg1") + " " + ((Switch)this.getKnoten()).getAnschluesse().indexOf(anschluss);
            Vector<String> eintrag = new Vector<String>();
            eintrag.add(elem.toUpperCase());
            eintrag.add(ausgabe);
            eintraege.add(eintrag);
        }
        return eintraege;
    }

    public void hinzuSatEintrag(String macAdresse, Port anschluss) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (SwitchFirmware), hinzuSatEintrag(" + macAdresse + "," + anschluss + ")");
        if (this.sat.containsKey(macAdresse)) {
            this.sat.remove(macAdresse);
        }
        this.sat.put(macAdresse, anschluss);
    }

    public Port holeAnschlussFuerMAC(String macAdresse) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (SwitchFirmware), holeAnschlussFuerMAC(" + macAdresse + ")");
        if (this.sat.containsKey(macAdresse)) {
            return this.sat.get(macAdresse);
        }
        return null;
    }

    public LinkedList<EthernetFrame> holeDurchgelaufeneFrames() {
        return this.durchgelaufeneFrames;
    }
}

