/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.Main;
import filius.exception.SocketException;
import filius.rahmenprogramm.I18n;
import filius.software.Protokoll;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.SocketSchnittstelle;
import filius.software.transportschicht.TransportProtokollThread;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Random;

public abstract class TransportProtokoll
extends Protokoll
implements I18n,
Runnable {
    private static final int PORT_UNTERE_GRENZE = 1024;
    private static final int PORT_OBERE_GRENZE = 65535;
    protected static final int TTL = 64;
    private int typ;
    private LinkedList<Object[]> segmentListe = new LinkedList();
    private Hashtable<Integer, SocketSchnittstelle> portTabelle;
    private TransportProtokollThread thread;
    private Thread sendeThread = null;
    private boolean running = false;

    public TransportProtokoll(InternetKnotenBetriebssystem betriebssystem, int typ) {
        super(betriebssystem);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), constr: TransportProtokoll(" + betriebssystem + "," + typ + ")");
        this.typ = typ;
        this.portTabelle = new Hashtable();
    }

    public Hashtable<Integer, SocketSchnittstelle> holeAktiveSockets() {
        return this.portTabelle;
    }

    public int holeTyp() {
        return this.typ;
    }

    public int reserviereFreienPort(Socket socket) {
        int freienPort;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), reserviereFreienPort(" + socket + ")");
        boolean portGefunden = false;
        do {
            if (this.portTabelle.containsKey(freienPort = this.sucheFreienPort())) continue;
            portGefunden = true;
        } while (!portGefunden);
        this.reservierePort(freienPort, socket);
        return freienPort;
    }

    public SocketSchnittstelle holeSocket(int port) throws SocketException {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), holeSocket(" + port + ")");
        if (port == -1) {
            throw new SocketException(messages.getString("sw_transportprotokoll_msg3"));
        }
        if (!this.portTabelle.containsKey(port)) {
            throw new SocketException(messages.getString("sw_transportprotokoll_msg1") + " " + port + " " + messages.getString("sw_transportprotokoll_msg2"));
        }
        return this.portTabelle.get(port);
    }

    public boolean isUsed(int port) {
        return this.portTabelle.containsKey(port);
    }

    private int sucheFreienPort() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), sucheFreienPort()");
        int spanne = 64511;
        Random random = new Random();
        int zufallsZahl = Math.abs(random.nextInt());
        int zahl = zufallsZahl % spanne;
        return 1024 + zahl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reservierePort(int port, SocketSchnittstelle socket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), reservierePort(" + port + "," + socket + ")");
        Hashtable<Integer, SocketSchnittstelle> hashtable = this.portTabelle;
        synchronized (hashtable) {
            if (this.portTabelle.containsKey(port)) {
                Main.debug.println("ERROR (" + this.hashCode() + "): Port " + port + " ist bereits belegt!");
                return false;
            }
            this.portTabelle.put(port, socket);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gibPortFrei(int port) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), gibPortFrei(" + port + ")");
        Hashtable<Integer, SocketSchnittstelle> hashtable = this.portTabelle;
        synchronized (hashtable) {
            if (this.portTabelle.containsKey(port)) {
                this.portTabelle.remove(port);
                return true;
            }
            return false;
        }
    }

    protected void senden(String zielIp, Object segment) {
        this.senden(zielIp, null, segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void senden(String zielIp, String quellIp, Object segment) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), senden(" + zielIp + "," + segment + ")");
        LinkedList<Object[]> linkedList = this.segmentListe;
        synchronized (linkedList) {
            this.segmentListe.addLast(new Object[]{zielIp, quellIp, segment});
            this.segmentListe.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), run()");
        while (this.running) {
            LinkedList<Object[]> linkedList = this.segmentListe;
            synchronized (linkedList) {
                if (this.segmentListe.size() < 1) {
                    try {
                        this.segmentListe.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.segmentListe.size() > 0) {
                    Object[] temp = this.segmentListe.removeFirst();
                    InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.holeSystemSoftware();
                    bs.holeIP().senden((String)temp[0], (String)temp[1], this.holeTyp(), 64, temp[2]);
                }
            }
        }
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), starten()");
        this.portTabelle = new Hashtable();
        this.thread = new TransportProtokollThread(this);
        this.thread.starten();
        if (!this.running) {
            this.running = true;
            if (this.sendeThread == null || !this.sendeThread.getState().equals((Object)Thread.State.WAITING) && !this.sendeThread.getState().equals((Object)Thread.State.BLOCKED)) {
                this.sendeThread = new Thread(this);
                this.sendeThread.start();
            }
        }
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), beenden()");
        this.thread.beenden();
        this.running = false;
        if (this.sendeThread != null && (this.sendeThread.getState().equals((Object)Thread.State.WAITING) || this.sendeThread.getState().equals((Object)Thread.State.BLOCKED))) {
            this.sendeThread.interrupt();
        }
    }
}

