/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.Main;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.gui.anwendungssicht.JTableEditable;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.dns.DNSServer;
import filius.software.dns.ResourceRecord;
import filius.software.vermittlungsschicht.IP;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GUIApplicationDNSServerWindow
extends GUIApplicationWindow {
    private static final long serialVersionUID = 1L;
    private JPanel backPanel;
    private JPanel aPanel;
    private JPanel mxPanel;
    private JPanel nsPanel;
    private JTextField aDomainField;
    private JTextField mxURLField;
    private JTextField aIpField;
    private JTextField mxMaildomainField;
    private JTextField nsDomainField;
    private JTextField nsDomainServerField;
    private JLabel aDomainLabel;
    private JLabel aIpLabel;
    private JLabel mxURLLabel;
    private JLabel mxMaildomainLabel;
    private JLabel nsDomainLabel;
    private JLabel nsDomainServerLabel;
    private JTabbedPane tabbedPane;
    private JCheckBox recResolution;
    private JButton mxAddButton;
    private JButton aAddButton;
    private JButton buttonStart;
    private JButton buttonEntfernen;
    private JButton buttonMXEntfernen;
    private JButton nsAddButton;
    private JButton nsRemoveButton;
    private JTableEditable aRecordsTable;
    private JTableEditable mxRecordsTable;
    private JTableEditable nsRecordsTable;

    public GUIApplicationDNSServerWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.initialisiereKomponenten();
    }

    private void initialisiereKomponenten() {
        this.tabbedPane = new JTabbedPane();
        this.backPanel = new JPanel(new BorderLayout());
        this.buttonStart = new JButton(messages.getString("dnsserver_msg1"));
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).isAktiv()) {
                    ((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).setAktiv(false);
                } else {
                    ((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).setAktiv(true);
                }
            }
        });
        Box hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        hBox.add(this.buttonStart);
        this.recResolution = new JCheckBox();
        this.recResolution.setText(messages.getString("dnsserver_msg20"));
        DNSServer dnsServer = (DNSServer)this.holeAnwendung();
        this.recResolution.setSelected(dnsServer.isRecursiveResolutionEnabled());
        this.recResolution.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = GUIApplicationDNSServerWindow.this.recResolution;
                boolean activated = checkBox.isSelected();
                DNSServer dnsServer = (DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung();
                dnsServer.setRecursiveResolutionEnabled(activated);
                checkBox.setSelected(dnsServer.isRecursiveResolutionEnabled());
            }
        });
        hBox.add(Box.createHorizontalStrut(20));
        hBox.add(this.recResolution);
        this.backPanel.add((Component)hBox, "North");
        this.initAPanel();
        this.initMXPanel();
        this.initNSPanel();
        this.tabbedPane.addTab(messages.getString("dnsserver_msg2"), new ImageIcon(this.getClass().getResource("/gfx/desktop/peertopeer_netzwerk_klein.png")), this.aPanel);
        this.tabbedPane.addTab(messages.getString("dnsserver_msg3"), new ImageIcon(this.getClass().getResource("/gfx/desktop/peertopeer_netzwerk_klein.png")), this.mxPanel);
        this.tabbedPane.addTab(messages.getString("dnsserver_msg15"), new ImageIcon(this.getClass().getResource("/gfx/desktop/peertopeer_netzwerk_klein.png")), this.nsPanel);
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        hBox.add(this.tabbedPane);
        this.backPanel.add((Component)hBox, "Center");
        this.getContentPane().add(this.backPanel);
        this.pack();
        this.updateMXRecordsTable();
        this.updateARecordsTable();
        this.updateNSRecordsTable();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                GUIApplicationDNSServerWindow.this.aktualisieren();
            }
        });
        this.aktualisieren();
    }

    private void initAPanel() {
        this.aPanel = new JPanel(new BorderLayout());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.aDomainLabel = new JLabel(messages.getString("dnsserver_msg4"));
        this.aDomainLabel.setPreferredSize(new Dimension(170, 25));
        hBox.add(this.aDomainLabel);
        hBox.add(Box.createHorizontalStrut(5));
        this.aDomainField = new JTextField();
        this.aDomainField.setPreferredSize(new Dimension(275, 25));
        this.aDomainField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.aDomainField);
            }
        });
        hBox.add(this.aDomainField);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.aIpLabel = new JLabel(messages.getString("dnsserver_msg5"));
        this.aIpLabel.setPreferredSize(new Dimension(170, 25));
        hBox.add(this.aIpLabel);
        hBox.add(Box.createHorizontalStrut(5));
        this.aIpField = new JTextField(this.holeAnwendung().getSystemSoftware().holeIPAdresse());
        this.aIpField.setPreferredSize(new Dimension(275, 25));
        this.aIpField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationDNSServerWindow.this.checkIP(GUIApplicationDNSServerWindow.this.aIpField);
            }
        });
        hBox.add(this.aIpField);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.aAddButton = new JButton(messages.getString("dnsserver_msg6"));
        this.aAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.aDomainField) && GUIApplicationDNSServerWindow.this.checkIP(GUIApplicationDNSServerWindow.this.aIpField) && IP.ipCheck(GUIApplicationDNSServerWindow.this.aIpField.getText()) != null) {
                    ((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).hinzuRecord(GUIApplicationDNSServerWindow.this.aDomainField.getText(), "A", GUIApplicationDNSServerWindow.this.aIpField.getText());
                    GUIApplicationDNSServerWindow.this.aDomainField.setText("");
                    GUIApplicationDNSServerWindow.this.aIpField.setText("");
                    GUIApplicationDNSServerWindow.this.updateARecordsTable();
                } else {
                    GUIApplicationDNSServerWindow.this.showMessageDialog(I18n.messages.getString("dnsserver_msg21"));
                }
            }
        });
        hBox.add(this.aAddButton);
        hBox.add(Box.createHorizontalStrut(5));
        this.buttonEntfernen = new JButton(messages.getString("dnsserver_msg7"));
        this.buttonEntfernen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int zeilenNummer = GUIApplicationDNSServerWindow.this.aRecordsTable.getSelectedRow();
                if (zeilenNummer != -1) {
                    String domainname = GUIApplicationDNSServerWindow.this.aRecordsTable.getValueAt(zeilenNummer, 0).toString();
                    ((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).loescheResourceRecord(domainname, "A");
                    Main.debug.println("GUIApplicationDNSServerWindow: A-Eintrag " + domainname + " geloescht");
                    GUIApplicationDNSServerWindow.this.updateARecordsTable();
                }
            }
        });
        hBox.add(this.buttonEntfernen);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        DefaultTableModel tabellenModell = new DefaultTableModel(0, 2);
        this.aRecordsTable = new JTableEditable((TableModel)tabellenModell, true, "A");
        this.aRecordsTable.setParentGUI(this);
        this.aRecordsTable.setIntercellSpacing(new Dimension(5, 5));
        this.aRecordsTable.setRowHeight(30);
        this.aRecordsTable.setShowGrid(false);
        this.aRecordsTable.setFillsViewportHeight(true);
        this.aRecordsTable.setBackground(Color.WHITE);
        this.aRecordsTable.setShowHorizontalLines(true);
        TableColumnModel tcm = this.aRecordsTable.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("dnsserver_msg8"));
        tcm.getColumn(1).setHeaderValue(messages.getString("dnsserver_msg9"));
        JScrollPane scrollPane = new JScrollPane(this.aRecordsTable);
        vBox.add(scrollPane);
        this.aPanel.add((Component)vBox, "Center");
    }

    private void initMXPanel() {
        this.mxPanel = new JPanel(new BorderLayout());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.mxMaildomainLabel = new JLabel(messages.getString("dnsserver_msg10"));
        this.mxMaildomainLabel.setPreferredSize(new Dimension(170, 25));
        hBox.add(this.mxMaildomainLabel);
        hBox.add(Box.createHorizontalStrut(5));
        this.mxMaildomainField = new JTextField();
        this.mxMaildomainField.setPreferredSize(new Dimension(275, 25));
        this.mxMaildomainField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.mxMaildomainField);
            }
        });
        hBox.add(this.mxMaildomainField);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.mxURLLabel = new JLabel(messages.getString("dnsserver_msg11"));
        this.mxURLLabel.setPreferredSize(new Dimension(170, 25));
        hBox.add(this.mxURLLabel);
        hBox.add(Box.createHorizontalStrut(5));
        this.mxURLField = new JTextField();
        this.mxURLField.setPreferredSize(new Dimension(275, 25));
        this.mxURLField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.mxURLField);
            }
        });
        hBox.add(this.mxURLField);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.mxAddButton = new JButton(messages.getString("dnsserver_msg6"));
        this.mxAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.mxMaildomainField) && GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.mxURLField)) {
                    ((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).hinzuRecord(GUIApplicationDNSServerWindow.this.mxMaildomainField.getText(), "MX", GUIApplicationDNSServerWindow.this.mxURLField.getText());
                    GUIApplicationDNSServerWindow.this.mxMaildomainField.setText("");
                    GUIApplicationDNSServerWindow.this.mxURLField.setText("");
                    GUIApplicationDNSServerWindow.this.updateMXRecordsTable();
                } else {
                    GUIApplicationDNSServerWindow.this.showMessageDialog(I18n.messages.getString("dnsserver_msg23"));
                }
            }
        });
        hBox.add(this.mxAddButton);
        this.buttonMXEntfernen = new JButton(messages.getString("dnsserver_msg7"));
        this.buttonMXEntfernen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int zeilenNummer = GUIApplicationDNSServerWindow.this.mxRecordsTable.getSelectedRow();
                if (zeilenNummer != -1) {
                    String domainname = GUIApplicationDNSServerWindow.this.mxRecordsTable.getValueAt(zeilenNummer, 0).toString();
                    ((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).loescheResourceRecord(domainname, "MX");
                    Main.debug.println("GUIApplicationDNSServerWindow: MX-Eintrag " + domainname + " geloescht");
                    GUIApplicationDNSServerWindow.this.updateMXRecordsTable();
                }
            }
        });
        hBox.add(this.buttonMXEntfernen);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        DefaultTableModel tabellenModell = new DefaultTableModel(0, 2);
        this.mxRecordsTable = new JTableEditable((TableModel)tabellenModell, true, "MX");
        this.mxRecordsTable.setParentGUI(this);
        this.mxRecordsTable.setIntercellSpacing(new Dimension(5, 5));
        this.mxRecordsTable.setRowHeight(30);
        this.mxRecordsTable.setShowGrid(false);
        this.mxRecordsTable.setFillsViewportHeight(true);
        this.mxRecordsTable.setBackground(Color.WHITE);
        this.mxRecordsTable.setShowHorizontalLines(true);
        TableColumnModel tcm = this.mxRecordsTable.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("dnsserver_msg12"));
        tcm.getColumn(1).setHeaderValue(messages.getString("dnsserver_msg13"));
        JScrollPane scrollPane = new JScrollPane(this.mxRecordsTable);
        vBox.add(scrollPane);
        this.mxPanel.add((Component)vBox, "Center");
    }

    private void initNSPanel() {
        this.nsPanel = new JPanel(new BorderLayout());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.nsDomainLabel = new JLabel(messages.getString("dnsserver_msg16"));
        this.nsDomainLabel.setPreferredSize(new Dimension(170, 25));
        hBox.add(this.nsDomainLabel);
        hBox.add(Box.createHorizontalStrut(5));
        this.nsDomainField = new JTextField();
        this.nsDomainField.setPreferredSize(new Dimension(275, 25));
        this.nsDomainField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.nsDomainField);
            }
        });
        hBox.add(this.nsDomainField);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.nsDomainServerLabel = new JLabel(messages.getString("dnsserver_msg17"));
        this.nsDomainServerLabel.setPreferredSize(new Dimension(170, 25));
        hBox.add(this.nsDomainServerLabel);
        hBox.add(Box.createHorizontalStrut(5));
        this.nsDomainServerField = new JTextField();
        this.nsDomainServerField.setPreferredSize(new Dimension(275, 25));
        this.nsDomainServerField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.nsDomainServerField);
            }
        });
        hBox.add(this.nsDomainServerField);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        this.nsAddButton = new JButton(messages.getString("dnsserver_msg6"));
        this.nsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.nsDomainField) && GUIApplicationDNSServerWindow.this.checkFQDN(GUIApplicationDNSServerWindow.this.nsDomainServerField)) {
                    ((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).hinzuRecord(GUIApplicationDNSServerWindow.this.nsDomainField.getText(), "NS", GUIApplicationDNSServerWindow.this.nsDomainServerField.getText());
                    GUIApplicationDNSServerWindow.this.nsDomainField.setText("");
                    GUIApplicationDNSServerWindow.this.nsDomainServerField.setText("");
                    GUIApplicationDNSServerWindow.this.updateNSRecordsTable();
                } else {
                    GUIApplicationDNSServerWindow.this.showMessageDialog(I18n.messages.getString("dnsserver_msg22"));
                }
            }
        });
        hBox.add(this.nsAddButton);
        this.nsRemoveButton = new JButton(messages.getString("dnsserver_msg7"));
        this.nsRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int zeilenNummer = GUIApplicationDNSServerWindow.this.nsRecordsTable.getSelectedRow();
                if (zeilenNummer != -1) {
                    String domainname = GUIApplicationDNSServerWindow.this.nsRecordsTable.getValueAt(zeilenNummer, 0).toString();
                    ((DNSServer)GUIApplicationDNSServerWindow.this.holeAnwendung()).loescheResourceRecord(domainname, "NS");
                    Main.debug.println("GUIApplicationDNSServerWindow: NS-Eintrag " + domainname + " geloescht");
                    GUIApplicationDNSServerWindow.this.updateNSRecordsTable();
                }
            }
        });
        hBox.add(this.nsRemoveButton);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        DefaultTableModel tabellenModell = new DefaultTableModel(0, 2);
        this.nsRecordsTable = new JTableEditable((TableModel)tabellenModell, true, "NS");
        this.nsRecordsTable.setParentGUI(this);
        this.nsRecordsTable.setIntercellSpacing(new Dimension(5, 5));
        this.nsRecordsTable.setRowHeight(30);
        this.nsRecordsTable.setShowGrid(false);
        this.nsRecordsTable.setFillsViewportHeight(true);
        this.nsRecordsTable.setBackground(Color.WHITE);
        this.nsRecordsTable.setShowHorizontalLines(true);
        TableColumnModel tcm = this.nsRecordsTable.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("dnsserver_msg18"));
        tcm.getColumn(1).setHeaderValue(messages.getString("dnsserver_msg19"));
        JScrollPane scrollPane = new JScrollPane(this.nsRecordsTable);
        vBox.add(scrollPane);
        this.nsPanel.add((Component)vBox, "Center");
    }

    public void updateARecordsTable() {
        this.updateRecordsTable(this.aRecordsTable);
    }

    public void updateNSRecordsTable() {
        this.updateRecordsTable(this.nsRecordsTable);
    }

    public void updateMXRecordsTable() {
        this.updateRecordsTable(this.mxRecordsTable);
    }

    private synchronized void updateRecordsTable(JTableEditable table) {
        String type = table.getType();
        List<ResourceRecord> tempListe = ((DNSServer)this.holeAnwendung()).holeResourceRecords();
        ArrayList<ResourceRecord> recordsOfSelectedType = new ArrayList<ResourceRecord>();
        for (ResourceRecord rr : tempListe) {
            if (!rr.getType().equals(type)) continue;
            recordsOfSelectedType.add(rr);
        }
        ((DefaultTableModel)table.getModel()).setRowCount(recordsOfSelectedType.size());
        int row = 0;
        for (ResourceRecord rr : recordsOfSelectedType) {
            table.setValueAt(rr.getDomainname(), row, 0);
            table.setValueAt(rr.getRdata(), row, 1);
            ++row;
        }
    }

    private boolean checkIP(JTextField feld) {
        feld.setText(feld.getText().trim());
        boolean validAddress = EingabenUeberpruefung.isGueltig(feld.getText(), EingabenUeberpruefung.musterIpAdresse);
        if (validAddress) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
        } else {
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
        }
        return validAddress;
    }

    private boolean checkFQDN(JTextField feld) {
        feld.setText(feld.getText().trim());
        boolean validFqdn = EingabenUeberpruefung.isGueltig(feld.getText(), EingabenUeberpruefung.musterDomain);
        if (validFqdn) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
        } else {
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
        }
        return validFqdn;
    }

    private void aktualisieren() {
        if (((DNSServer)this.holeAnwendung()).isAktiv()) {
            this.buttonStart.setText(messages.getString("dnsserver_msg14"));
        } else {
            this.buttonStart.setText(messages.getString("dnsserver_msg1"));
        }
        if (this.ui != null) {
            this.updateARecordsTable();
            this.updateMXRecordsTable();
            this.updateNSRecordsTable();
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if ("A".equals(arg1)) {
            this.updateARecordsTable();
        } else if ("NS".equals(arg1)) {
            this.updateNSRecordsTable();
        } else if ("MX".equals(arg1)) {
            this.updateMXRecordsTable();
        } else if (arg1 != null) {
            this.aktualisieren();
        }
    }
}

