/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.Main;
import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.gui.netzwerksicht.JDHCPKonfiguration;
import filius.gui.netzwerksicht.JKonfiguration;
import filius.hardware.Hardware;
import filius.hardware.knoten.Host;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.system.Betriebssystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class JHostKonfiguration
extends JKonfiguration
implements I18n {
    private static final int LABEL_WIDTH = 160;
    private JTextField name;
    private JTextField macAdresse;
    private JTextField ipAdresse;
    private JTextField netzmaske;
    private JTextField gateway;
    private JTextField dns;
    private JCheckBox dhcp;
    private JButton btDhcp;
    private JCheckBox useIpAsName;

    protected JHostKonfiguration(Hardware hardware) {
        super(hardware);
    }

    private void aendereAnzeigeName() {
        if (this.holeHardware() != null) {
            Host host = (Host)this.holeHardware();
            host.setUseIPAsName(this.useIpAsName.isSelected());
        }
        GUIContainer.getGUIContainer().updateViewport();
        this.updateAttribute();
    }

    @Override
    public void aenderungenAnnehmen() {
        if (this.holeHardware() != null) {
            Host host = (Host)this.holeHardware();
            if (!this.useIpAsName.isSelected()) {
                host.setName(this.name.getText());
            }
            Betriebssystem bs = (Betriebssystem)host.getSystemSoftware();
            bs.setzeIPAdresse(this.ipAdresse.getText());
            bs.setzeNetzmaske(this.netzmaske.getText());
            bs.setStandardGateway(this.gateway.getText());
            bs.setDNSServer(this.dns.getText());
            bs.setDHCPKonfiguration(this.dhcp.isSelected());
            if (this.dhcp.isSelected()) {
                bs.getDHCPServer().setAktiv(false);
            }
        } else {
            Main.debug.println("GUIRechnerKonfiguration: Aenderungen konnten nicht uebernommen werden.");
        }
        GUIContainer.getGUIContainer().updateViewport();
        this.updateAttribute();
    }

    @Override
    protected void initAttributEingabeBox(Box box, Box rightBox) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JHostKonfiguration.this.aenderungenAnnehmen();
            }
        };
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                JHostKonfiguration.this.aenderungenAnnehmen();
            }
        };
        JLabel tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg1"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.name = new JTextField(messages.getString("jhostkonfiguration_msg2"));
        this.name.addActionListener(actionListener);
        this.name.addFocusListener(focusListener);
        Box tempBox = Box.createHorizontalBox();
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.name);
        box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg9"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.macAdresse = new JTextField("");
        this.macAdresse.setEditable(false);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.macAdresse);
        box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg3"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.ipAdresse = new JTextField("192.168.0.1");
        this.ipAdresse.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JHostKonfiguration.this.checkIpAddress();
            }
        });
        this.ipAdresse.addActionListener(actionListener);
        this.ipAdresse.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.ipAdresse);
        box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg4"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.netzmaske = new JTextField("255.255.255.0");
        this.netzmaske.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JHostKonfiguration.this.checkNetmask();
            }
        });
        this.netzmaske.addActionListener(actionListener);
        this.netzmaske.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.netzmaske);
        box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg5"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.gateway = new JTextField("192.168.0.1");
        this.gateway.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JHostKonfiguration.this.checkGatewayAddress();
            }
        });
        this.gateway.addActionListener(actionListener);
        this.gateway.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.gateway);
        box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg6"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.dns = new JTextField("192.168.0.1");
        this.dns.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JHostKonfiguration.this.checkDnsAddress();
            }
        });
        this.dns.addActionListener(actionListener);
        this.dns.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.dns);
        box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg10"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setOpaque(false);
        tempLabel.setAlignmentX(1.0f);
        this.useIpAsName = new JCheckBox();
        this.useIpAsName.setOpaque(false);
        this.useIpAsName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JHostKonfiguration.this.aendereAnzeigeName();
            }
        });
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.useIpAsName);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(tempLabel);
        rightBox.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg7"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setOpaque(false);
        tempLabel.setAlignmentX(1.0f);
        this.dhcp = new JCheckBox();
        this.dhcp.setSelected(false);
        this.dhcp.setOpaque(false);
        this.dhcp.addActionListener(actionListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.dhcp);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(tempLabel);
        rightBox.add((Component)tempBox, "North");
        rightBox.add(Box.createVerticalStrut(10));
        tempBox = Box.createHorizontalBox();
        tempBox.setAlignmentX(0.0f);
        tempBox.setOpaque(false);
        this.btDhcp = new JButton(messages.getString("jhostkonfiguration_msg8"));
        this.btDhcp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JHostKonfiguration.this.showDhcpConfiguration();
            }
        });
        tempBox.add(this.btDhcp);
        rightBox.add(tempBox);
        tempBox = Box.createVerticalBox();
        tempBox.setOpaque(false);
        tempBox.setPreferredSize(new Dimension(400, 120));
        rightBox.add(tempBox);
        this.updateAttribute();
    }

    private void showDhcpConfiguration() {
        JDHCPKonfiguration dhcpKonfig = new JDHCPKonfiguration(JMainFrame.getJMainFrame(), messages.getString("jhostkonfiguration_msg8"), (Betriebssystem)((Host)this.holeHardware()).getSystemSoftware());
        dhcpKonfig.setVisible(true);
    }

    private void checkIpAddress() {
        this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, this.ipAdresse);
    }

    private void checkDnsAddress() {
        this.ueberpruefen(EingabenUeberpruefung.musterIpAdresseAuchLeer, this.dns);
    }

    private void checkGatewayAddress() {
        this.ueberpruefen(EingabenUeberpruefung.musterIpAdresseAuchLeer, this.gateway);
    }

    private void checkNetmask() {
        this.ueberpruefen(EingabenUeberpruefung.musterSubNetz, this.netzmaske);
    }

    @Override
    public void updateAttribute() {
        if (this.holeHardware() != null) {
            Host host = (Host)this.holeHardware();
            this.name.setText(host.holeAnzeigeName());
            this.useIpAsName.setSelected(host.isUseIPAsName());
            this.name.setEnabled(!host.isUseIPAsName());
            Betriebssystem bs = (Betriebssystem)host.getSystemSoftware();
            this.macAdresse.setText(bs.holeMACAdresse());
            this.ipAdresse.setText(bs.holeIPAdresse());
            this.netzmaske.setText(bs.holeNetzmaske());
            this.gateway.setText(bs.getStandardGateway());
            this.dns.setText(bs.getDNSServer());
            this.dhcp.setSelected(bs.isDHCPKonfiguration());
            this.btDhcp.setEnabled(!this.dhcp.isSelected());
            this.ipAdresse.setEnabled(!bs.isDHCPKonfiguration());
            this.netzmaske.setEnabled(!bs.isDHCPKonfiguration());
            this.gateway.setEnabled(!bs.isDHCPKonfiguration());
            this.dns.setEnabled(!bs.isDHCPKonfiguration());
            this.checkIpAddress();
            this.checkDnsAddress();
            this.checkGatewayAddress();
            this.checkNetmask();
        } else {
            Main.debug.println("GUIRechnerKonfiguration: keine Hardware-Komponente vorhanden");
        }
    }
}

