/*
 * Decompiled with CFR 0.152.
 */
package filius.software.www;

import filius.Main;
import filius.rahmenprogramm.Base64;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.ResourceUtil;
import filius.software.clientserver.TCPServerAnwendung;
import filius.software.system.Datei;
import filius.software.system.Dateisystem;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.TCPSocket;
import filius.software.www.WebServerMitarbeiter;
import filius.software.www.WebServerPlugIn;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;

public class WebServer
extends TCPServerAnwendung {
    private DefaultMutableTreeNode verzeichnis;
    private HashMap<String, WebServerPlugIn> plugins = new HashMap();
    private String[][] vHostArray = new String[5][2];

    public WebServer() {
        this.port = 80;
        this.resetVHosts();
    }

    public void resetVHosts() {
        for (int i = 0; i < this.vHostArray.length; ++i) {
            this.vHostArray[i][0] = "";
            this.vHostArray[i][1] = "";
        }
        this.benachrichtigeBeobachter();
    }

    @Override
    public void setSystemSoftware(InternetKnotenBetriebssystem betriebssystem) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), setSystemSoftware(" + betriebssystem + ")");
        super.setSystemSoftware(betriebssystem);
        this.erzeugeStandardVerzeichnis();
    }

    public void setzePlugIn(WebServerPlugIn pi) {
        this.plugins.put(pi.getPfad(), pi);
    }

    public void erzeugeIndexDatei(String dateipfad) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), erzeugeIndexDatei(" + dateipfad + ")");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dateipfad), Charset.forName("UTF-8")));){
            String input;
            StringBuffer fullFile = new StringBuffer();
            while ((input = reader.readLine()) != null) {
                fullFile.append(input + "\n");
            }
            this.erzeugeDatei("index", "html", fullFile.toString());
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
        }
    }

    public byte[] inputStreamToBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            Main.debug.println("EXCEPTION (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer):  IOException in conversion of InputStream to Byte[]");
            e.printStackTrace(Main.debug);
        }
        return out.toByteArray();
    }

    private void erzeugeStandardVerzeichnis() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), erzeugeStandardVerzeichnis()");
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        dateisystem.erstelleVerzeichnis(dateisystem.getRoot(), "webserver");
        this.verzeichnis = dateisystem.verzeichnisKnoten(dateisystem.holeRootPfad() + "/" + "webserver");
        try {
            if (!dateisystem.dateiVorhanden(this.verzeichnis, "index.html")) {
                this.erzeugeIndexDatei(ResourceUtil.getResourcePath("tmpl/webserver_index_" + Information.getInformation().getLocale() + ".txt"));
                this.erzeugeDatei("splashscreen-mini", "png", Base64.encodeBytes(this.inputStreamToBytes(this.getClass().getResourceAsStream("/gfx/allgemein/splashscreen-mini.png"))));
            }
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
        }
    }

    private void erzeugeDatei(String dateiname, String endung, String quellcode) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), erzeugeDatei(" + dateiname + "," + endung + "," + quellcode + ")");
        String kompletteDateiName = dateiname + "." + endung;
        Datei datei = new Datei(kompletteDateiName, endung, quellcode);
        this.getSystemSoftware().getDateisystem().speicherDatei(this.verzeichnis, datei);
    }

    protected Datei dateiLiefern(String relativerPfad) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), dateiLiefern(" + relativerPfad + ")");
        Datei tmpDatei = this.getSystemSoftware().getDateisystem().holeDatei(this.verzeichnis, relativerPfad);
        return tmpDatei;
    }

    public WebServerPlugIn holePlugin(String key) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), holePlugin(" + key + ")");
        WebServerPlugIn plugIn = null;
        if (this.plugins.containsKey(key)) {
            plugIn = this.plugins.get(key);
        }
        return plugIn;
    }

    public HashMap<String, WebServerPlugIn> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(HashMap<String, WebServerPlugIn> plugins) {
        this.plugins = plugins;
    }

    public String printVHostTable() {
        String result = "";
        for (int i = 0; i < this.vHostArray.length; ++i) {
            result = result + i + ":\t";
            result = this.vHostArray[i][0] == null ? result + "<null>\t" : result + this.vHostArray[i][0] + "\t";
            result = this.vHostArray[i][1] == null ? result + "<null>\n" : result + this.vHostArray[i][1] + "\n";
        }
        return result;
    }

    public void changeVHostTable(int row, int col, String val) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), changeVHostTable(" + row + "," + col + "," + val + ")");
        this.vHostArray[row][col] = val != null ? val : "";
        this.saveVHosts();
    }

    public String vhostPrefix(String vhost) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), vhostPrefix(" + vhost + ")");
        for (int i = 0; i < this.vHostArray.length; ++i) {
            if (this.vHostArray[i][0] == null || !this.vHostArray[i][0].equalsIgnoreCase(vhost) || this.vHostArray[i][1] == null) continue;
            return this.vHostArray[i][1];
        }
        return "";
    }

    public String[][] getVHostArray() {
        return this.vHostArray;
    }

    @Override
    protected void neuerMitarbeiter(Socket socket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), neuerMitarbeiter(" + socket + ")");
        if (socket instanceof TCPSocket) {
            WebServerMitarbeiter wsMitarbeiter = new WebServerMitarbeiter(this, (TCPSocket)socket);
            wsMitarbeiter.starten();
            this.mitarbeiter.add(wsMitarbeiter);
        }
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), starten()");
        super.starten();
        if (!this.getSystemSoftware().getDateisystem().dateiVorhanden("www.conf", "vhosts")) {
            this.getSystemSoftware().getDateisystem().erstelleVerzeichnis("root", "www.conf");
        }
        this.initialisiereVHosts();
    }

    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebServer), beenden()");
        super.beenden();
    }

    private void saveVHosts() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), schreibeRecordListe()");
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.vHostArray.length; ++i) {
            String host = this.vHostArray[i][0];
            String directory = this.vHostArray[i][1];
            text.append((host != null ? host : "") + "\n" + (directory != null ? directory : "") + "\n");
        }
        Datei vhosts = new Datei();
        vhosts.setDateiInhalt(text.toString());
        vhosts.setName("vhosts");
        dateisystem.speicherDatei(dateisystem.holeRootPfad() + "/" + "www.conf", vhosts);
    }

    private void initialisiereVHosts() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + ", initialisiereVHosts()");
        this.vHostArray = new String[5][2];
        int row = 0;
        int col = 0;
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        Datei vhosts = dateisystem.holeDatei(dateisystem.holeRootPfad() + "/" + "www.conf" + "/" + "vhosts");
        if (vhosts != null) {
            StringTokenizer tokenizer = new StringTokenizer(vhosts.getDateiInhalt(), "\n");
            while (tokenizer.hasMoreTokens()) {
                String line;
                this.vHostArray[row][col] = line = tokenizer.nextToken().trim();
                if (col == 0) {
                    ++col;
                    continue;
                }
                col = 0;
                ++row;
            }
        }
        while (row < 5) {
            this.vHostArray[row][0] = "";
            this.vHostArray[row][1] = "";
            ++row;
        }
    }
}

