from microbit import *

timeRes = 100  # en ms
zeroVoltage = 0

# *****************
def lecture():
    global zeroVoltage
    global tempsPrec
    tensionInt = pin0.read_analog()
    tension = (tensionInt-zeroVoltage)*3.3/1024
    print(tension, end=',')
    print(temperature())
    tempsPrec += timeRes

# ************
uart.init(115200)
tempsPrec = running_time()
while True:
    if uart.any():
        rec = uart.read(1)
        if rec == b'Z':   # b pour bytes
            zeroVoltage = pin0.read_analog()
    elif running_time() >= tempsPrec:
        lecture()
