// Envoide données et dialogue avec Regressi

const int waitSerial = 5; // ms
int timeRes = 100; // en ms
word zeroVoltage = 0; // en ms
unsigned long tempsPrec;

void setup() {
  Serial.begin(9600); 
}

void getCommand()
{
  delay(waitSerial); // Let all chars arrive
  String rec = Serial.readString();

  if (rec='Set') {
     etalonne();
  }
}

void lecture()
{
  word tensionInt,temperatureInt;
  float tension, temperature;
  tensionInt = analogRead(0); 
  tension = (tensionInt-zeroVoltage)*5.0/1024;
  temperatureInt = analogRead(1); // LM35 sur A1
  temperature = temperatureInt*5.0/1024*100; // 10 mV/°C
  // Envoie les données
  // acquisition basse vitesse, on a le temps d'utiliser des flottants
  Serial.print(tension);
  Serial.print(',');
  Serial.print(temperature);
  Serial.println(); // Carriage return
}

void etalonne()
{
   zeroVoltage = analogRead(0); 
}

void loop() {
  if (Serial.available() > 0) {
     getCommand(); // On lit les commandes
  }
  else  {
    unsigned long tempsCourant = millis();
    if (tempsCourant >= tempsPrec) {
      lecture();
    }
  } // else
}
