from microbit import *

# Activer le mode REPL
# Restart your micro:bit by pressing the reset button on the backet
# Activer le graphique
# La désactivation du graphique générera le fichier csv
# dans "utilisateur"/mu_code/data_capture

# Constantes
maxS = 1024
attenteTrig = 0
attenteStart = 1
acquisition = 2
trigRelaxe = 0
trigMontant = 1
trigDescendant = 2

# ******************
def start():
    global trigMode
    if trigMode == 0:
        lecture()
    else:
        trigger()


# ******************
def setTrigger(t):
    global etat
    global trigMode
    if not(type(t) is int):
        return
    etat = attenteStart
    display.show(Image.ASLEEP)
    if t == 0:
        trigMode = trigRelaxe
    if t == 1:
        trigMode = trigMontant
    if t == 2:
        trigMode = trigDescendant
    # print(t)


# ******************
def setSeuil(s):
    global trigVal
    global etat
    if not(type(s) is int):
        return
    etat = attenteStart
    display.show(Image.ASLEEP)
    if s < 24:
        s = 24  # un peu de marge
    if s > 1000:
        s = 1000
    trigVal = s
    # print(trigVal)


# ******************
def Tech(t):
    global etat
    global timeRes
    if not(type(t) is int):
        return
    etat = attenteStart
    display.show(Image.ASLEEP)
    if t < 1:
        t = 1  # fech=1 kHz maxi
    if t > 1000:
        t = 1000  # 1 s soit fech=1 Hz mini
    timeRes = t
    # print(timeRes)


# ******************
def stop():
    global etat
    etat = attenteStart

# *************
def trigger():
    global oldVal
    global etat
    global trigVal
    etat = attenteTrig
    if trigMode == trigMontant:
        display.show(Image.ARROW_N)
    else:  # descendant !
        display.show(Image.ARROW_S)
    while etat == attenteTrig:
        sleep(timeRes)
        val = pin0.read_analog()  # synchro sur voie P0
        if trigMode == trigMontant:
            seuilFranchi = (oldVal < trigVal) and (val >= trigVal)
        else:  # descendant !
            seuilFranchi = (oldVal >= trigVal) and (val < trigVal)
        if seuilFranchi:
            lecture()
        oldVal = val  # Sauve échantillon courant


# ***************
def lecture():
    global etat
    etat = acquisition
    display.show(Image.DIAMOND)
    pointCourant = 0
    t0 = running_time()
    while etat == acquisition:
        sleep(timeRes)
        data0 = pin0.read_analog()
        data1 = pin1.read_analog()
        temps = running_time() - t0
        # la vraie valeur de t : sleep approximatif, il faudrait un timer
        print((temps / 1000.0, data0, data1))

        pointCourant += 1
        if pointCourant == maxS:
            etat = attenteStart  # C'est la commande start qui redémarre
            display.show(Image.ASLEEP)


# début programme principal

# Variables globales
timeRes = 10  # en microseconde avec utime
trigVal = 512  # seuil synchro au milieu (10 bits)
trigMode = trigRelaxe   # mode synchro
etat = attenteStart
oldVal = pin0.read_analog()  # point précédent pour synchro seuil
display.show(Image.ASLEEP)

while True:
    if button_a.is_pressed():
        start()
