from microbit import *
import utime

# D'après Scopino - Scope application By Amit Zohar
# pour Arduino adapté pour Regressi J.M. Millet 13/01/2019
# asapté pour mcro:bit 3/04/2019

# Constantes
maxS = 256  # mémoire 3*4*256=3ko
# à ne pas dépasser !
attenteTrig = 0
attenteStart = 1
acquisition = 2
attenteEnvoi = 3
trigRelaxe = 0
trigMontant = 1
trigDescendant = 2

# Variables globales
timeRes = 10000  # en microseconde avec utime
P1actif = True
pointCourant = 0
envoiCourant = 0
trigVal = 512  # seuil synchro au milieu (10 bits)
trigMode = trigRelaxe
etat = attenteStart
t0 = 0
commande = ''
data0 = [0]*maxS
data1 = [0]*maxS
temps = [0]*maxS

# Process serial input
# Protocol: C<channel><NL> or T<time resolution><NL> or
# G<trigger value><NL> or H<trigger mode><NL>
# (C) Channel 1 ou 2
# (T) Time resolution: en micros
# (G) Trigger value: value needed to be crossed for trigger (0-1023)
# (H) Trigger mode: 0=free run, 1=positive slope, 2=negative slope

# ******************
def traiteCommande():
    global pointCourant
    global commande
    global etat
    global t0
    global P1actif
    global trigMode
    global trigVal
    # print(commande)
    if len(commande) >= 2:
        carac = commande[0]
        print(carac)
        if carac == 'C':  # Channel
            param = commande[1]
            if param == '1':
                P1actif = False
            if param == '2':
                P1actif = True
        elif carac == 'T':  # Time resolution en micro seconde
            timeRes = int(commande[1:])
            print(timeRes)
            if timeRes < 100:
                timeRes = 100  # f=10 kHz maxi
            if timeRes > 10000:
                timeRes = 10000  # 0.01 s 100 Hz mini
        elif carac == 'G':  # Trigger value
            trigVal = int(commande[1:])
            print(trigVal)
            if trigVal < 24:
                trigVal = 24  # un peu de marge
            if trigVal > 1000:
                trigVal = 1000
        elif carac == 'H':  # Trigger mode
            param = commande[1]
            if param == '0':
                trigMode = trigRelaxe
            if param == '1':
                trigMode = trigMontant
            if param == '2':
                trigMode = trigDescendant
        elif commande == 'Start':
            if trigMode == 0:
                pointCourant = 0
                t0 = utime.ticks_us()
                etat = acquisition
            else:
                etat = attenteTrig
        elif commande == "Stop":
            etat = attenteStart
    commande = ''

# *************
def trigger():
    global pointCourant
    global oldVal
    global trigVal
    global etat
    global t0
    val = pin0.read_analog()  # synchro sur voie P0
    if trigMode == trigMontant:
        seuilFranchi = (oldVal < trigVal) and (val >= trigVal)
    else:  # descendant !
        seuilFranchi = (oldVal >= trigVal) and (val < trigVal)
    if seuilFranchi:
        pointCourant = 0
        t0 = utime.ticks_us()
        etat = acquisition
    oldVal = val  # Sauve échantillon courant

# ***************
def lecture():
    global etat
    global pointCourant
    global envoiCourant
    data0[pointCourant] = pin0.read_analog()
    data1[pointCourant] = pin1.read_analog()
    temps[pointCourant] = utime.ticks_us()-t0
    # la vraie valeur de t : sleep approximatif, il faudrait un timer
    pointCourant += 1
    if pointCourant == maxS:
        envoiCourant = 0
        etat = attenteEnvoi  # C'est le programme principal qui envoie

# **************
def sendData():
    global envoiCourant
    # ligne par ligne pour pouvoir interrompre l'envoi par stop
    global etat
    print(temps[envoiCourant]/1e6, end=',')
    if P1actif:
        print(data0[envoiCourant], end=',')
        print(data1[envoiCourant])
    else:
        print(data0[envoiCourant])
    envoiCourant += 1
    if (envoiCourant == maxS) and (etat == attenteEnvoi):
        etat = attenteStart

# début programme principal

uart.init(115200)
oldVal = pin0.read_analog()   # point précédent pour synchro seuil

while True:
    if uart.any():
        received = uart.read(1)
        if (received == b'\r') or (received == b'\n'):
            # carriage return = #13 = '\r' = CR = $0D
            # new Line = line Feed = #10 = '\n' = LF = $0A
            traiteCommande()
        else:
            etat = attenteStart  # une commande arrête l'acquisition
            commande = commande + str(received, 'ASCII')
        sleep(10)
    elif etat == attenteEnvoi:
        sendData()
    else:
        utime.sleep_us(timeRes)
        if etat == acquisition:
            lecture()
        if etat == trigger:
            trigger()
