/* Scopino - Scope application
 By Amit Zohar
 Ver 2.0, October 2014
 adapté pour Regressi J.M. Millet 13/01/2019
 si quelqu'un améliore, envoyer la nouvelle version à regressi@orange.fr
*/

#include <TimerOne.h> // inclusion de la librairie Timer1

// Defines for setting A2D register bits
#define a2dBitClr(bit) (_SFR_BYTE(ADCSRA) &= ~_BV(bit))
#define a2dBitSet(bit) (_SFR_BYTE(ADCSRA) |= _BV(bit))

const int maxChannel = 2; // deux voies 0 et 1
const int maxSamples = 300; // mémoire dynamique 2048
word samples[maxChannel][maxSamples];
// Volatile pour utilisation dans une interruption timer ?
unsigned long timeRes = 1000; // en microseconde donc 1 kHz

int channel = 2;
int pointCourant = 0;
int envoiCourant = 0;
int ancienneValeur; // point précédent pour synchro seuil

int a2d = 4; // clock division factor pour CAN
/* fréquence de l'horloge utilisée pour CAN = fréquence principale divisée par un facteur 2,4,8,16,32,64,128.
 Les trois premiers bits du registre ADCSRA définissent le code correspondant (1,2,3,4,5,6,7).
 1 -> 2 ; 7 -> 128
 4 -> 16 ; freq UNO:16 MHz, soit 1 MHz pour le DAC
*/
int trigValue = 512; // seuil synchro au milieu (10 bits)
int trigMode = 0; // mode synchro 0 : relaxé

const int attenteTrig = 0;
const int attenteStart = 1;
const int acquisition = 2;
const int attenteEnvoi = 3;

const int ledStart = 11;
const int ledEnvoi = 12;

int etat = 1;

String chaine;

void setup() {
  Serial.begin(38400);
  etat = attenteStart;
  //  pinMode(ledStart, OUTPUT);
  //  pinMode(ledEnvoi, OUTPUT);
  ancienneValeur = analogRead(0);
  a2dSetup(a2d);
  Timer1.initialize(timeRes); // période 1ms
  Timer1.attachInterrupt(Echant); // active Timer
  //  digitalWrite(ledEnvoi, HIGH);
  //  digitalWrite(ledStart, HIGH);
}

// Set A2D register clock division factor, enabling faster sampling
// Prévu pour Arduino Uno, avec un Arduino Due ou Curie, on peut s'en passer
void a2dSetup(int factor) {
  if (factor & 1) a2dBitSet(ADPS0);
  else a2dBitClr(ADPS0);
  if (factor & 2) a2dBitSet(ADPS1);
  else a2dBitClr(ADPS1);
  if (factor & 4) a2dBitSet(ADPS2);
  else a2dBitClr(ADPS2);
}

/* Process serial input
 Protocol: C<channel><NL> or T<time resolution><NL> or A<A2D register><NL> or
 G<trigger value><NL> or H<trigger mode>
 (C) Channel: 0..1
 (T) Time resolution: en micros
 (A) A2D sampling speed: 1-7 ; 7 défaut 125 kHz ; 4 1 MHz
 (G) Trigger value: value needed to be crossed for trigger (0-1023)
 (H) Trigger mode: 0=free run, 1=positive slope, 2=negative slope
*/
void commande()
{
  // Serial.print("commande : ");
  // Serial.println(chaine);
  if (chaine.length() < 2) {
    chaine = "";
    return;
  }
  //  digitalWrite(ledEnvoi, LOW);
  //  digitalWrite(ledStart, LOW);
  String paramStr = chaine.substring(1);
  byte carac = chaine[0];
  chaine = "";

  switch (carac) {
    case 'C' : // Channel
      channel = paramStr.toInt();
      if (channel <= 1) {
        channel = 1;
      }
      if (channel >= 2) {
        channel = 2;
      }
      break;

    case 'T' : // Time resolution en micro seconde
      timeRes = paramStr.toInt();
      if (timeRes < 100) {
        timeRes = 100; // f=10 kHz
      }
      if (timeRes > 10000) {
        timeRes = 10000; // 0.01 s 100 Hz
      }
      Timer1.setPeriod(timeRes);
      break;

    case 'G' : // Trigger value
      trigValue = paramStr.toInt();
      if (trigValue < 24) {
        trigValue = 24; // un peu de marge
      }
      if (trigValue > 1000) {
        trigValue = 1000;
      }
      break;

    case 'H' :   // Trigger mode
      trigMode = paramStr.toInt();
      if (trigMode < 0) {
        trigMode = 0;
      }
      if (trigMode > 2) {
        trigMode = 2;
      }
      break;

    case 'A' : // A2D speed (1=faster sampling)
      a2d = paramStr.toInt();
      if (a2d < 1) { // 8 MHz
        a2d = 1;
      }
      if (a2d > 7) { // 16/128=125 kHz
        a2d = 7;
      }
      a2dSetup(a2d);
      break;


    case 'S' :
      if (paramStr == "tart") {
        if (trigMode == 0) {
          pointCourant = 0;
          etat = acquisition;
        }
        else {
          etat = attenteTrig;
        }
        // digitalWrite(ledStart, HIGH);
      }

      if (paramStr == "top") {
        etat = attenteStart;
        //  Serial.println("stop");
      }
      break;

  } // switch commande

}

void trigger()
{ boolean seuilFranchi;
  int valeurCourante = analogRead(0); // synchro sur voie A0
  if ( trigMode == 1 ) { // montant
    seuilFranchi = (ancienneValeur < trigValue) && (valeurCourante >= trigValue);
  }
  else { // descendant
    seuilFranchi = (ancienneValeur >= trigValue) && (valeurCourante < trigValue);
  }
  if (seuilFranchi) {
    pointCourant = 0;
    Serial.println("seuil franchi");
    etat = acquisition;
  }
  ancienneValeur = valeurCourante; // Save échantillon courant
}

void lecture()
{
  for (int c = 0; c < channel; c++) // Sampling loop
  {
    samples[c][pointCourant] = analogRead(c); // Sampling channel c
  }
  pointCourant ++;
  if (pointCourant == maxSamples) {
    envoiCourant = 0;
    etat = attenteEnvoi; // C'est le programme principal qui envoie
    //  digitalWrite(ledEnvoi, HIGH);
    //  digitalWrite(ledStart, LOW);
  }
}

void sendData()
{
  // ligne par ligne pour pouvoir interrompre l'envoi par stop
  Serial.print(timeRes * envoiCourant); // on fait confiance au timer !
  for (int c = 0; c < channel; c++) { // boucle voies
    Serial.print(',');
    Serial.print(samples[c][envoiCourant]);
  }
  Serial.println();
  envoiCourant ++;
  if ((envoiCourant == maxSamples) && (etat == attenteEnvoi)) {
    //  digitalWrite(ledEnvoi, LOW);
    etat = attenteStart;
  }
}

void Echant() {
  if (etat == attenteTrig) {
    trigger();
  }
  if (etat == acquisition) {
    lecture();
  }
}

void loop() {
  if (Serial.available() > 0) {
    char received = Serial.read();
    // or = || ; and = && ; not = !
    if ((received == '\n') || (received == '\r')) {
      // carriage return = #13 = '\r' = CR
      // new Line = line Feed = #10 = '\n' = LF
      commande();
    } // LineFeed
    else {
      etat = attenteStart; // une commande arrête l'acquisition
      chaine += received;
    }
  }// serial available
  else {
    if (etat == attenteEnvoi) {
      sendData();
    }
  }
}
