/* Scopino - Scope application
 By Amit Zohar
 Ver 2.0, October 2014
 adapté pour Regressi J.M. Millet et Arduino 101 (Curie) 13/01/2019
*/

#include <CurieTimerOne.h> // inclusion de la librairie CurieTimer

const int maxChannel = 2; // deux voies 0 et 1
const int maxSamples = 512;
word samples[maxChannel][maxSamples];
// Volatile pour utilisation dans une interruption timer ?
unsigned long timeRes = 1000; // en microseconde donc 1 kHz
int channel = 2;
int pointCourant = 0;
int envoiCourant = 0;
int ancienneValeur; // point précédent pour synchro seuil

int trigValue = 512; // seuil synchro au milieu (10 bits)
int trigMode = 0; // mode synchro 0 : relaxé

const int attenteTrig = 0;
const int attenteStart = 1;
const int acquisition = 2;
const int attenteEnvoi = 3;

int etat = 1;

String chaine = "";

void setup() {
  Serial.begin(115200);
  etat = attenteStart;
  ancienneValeur = analogRead(0);
  CurieTimerOne.start(timeRes, Echant); // active Timer
}

/* Process serial input
 Protocol: C<channel><NL> or T<time resolution><NL> or
 G<trigger value><NL> or H<trigger mode>
 (C) Channel: 0..1
 (T) Time resolution: en micros
 (G) Trigger value: value needed to be crossed for trigger (0-1023)
 (H) Trigger mode: 0=free run, 1=positive slope, 2=negative slope
*/
void commande()
{
  if (chaine.length() < 2) {
    chaine = "";
    return;
  }
 // Serial.print("commande ");
 // Serial.println(chaine);
  int carac = chaine[0];
  String paramStr = chaine.substring(1);
  chaine = "";

  switch (carac) {
    case 'C' :  // Channel
      channel = paramStr.toInt();
      if (channel < 1) {
        channel = 1;
      }
      if (channel > 2) {
        channel = 2;
      }
      break;

    case 'T' : // Time resolution en micro seconde
      timeRes = paramStr.toInt();
      if (timeRes < 100) {
        timeRes = 100;  // 10 kHz
      }
      if (timeRes > 10000) {
        timeRes = 10000;   // 0.01 s ; 100 Hz
      }
      CurieTimerOne.setPeriod(timeRes);
      break;

    case 'G' : // Trigger value
      trigValue = paramStr.toInt();
      if (trigValue < 24) {
        trigValue = 24;  // un peu de marge
      }
      if (trigValue > 1000) {
        trigValue = 1000;  // 10 bits 1024
      }
      break;

    case 'H' : // Trigger mode
      trigMode = paramStr.toInt();
      if (trigMode < 0) {
        trigMode = 0;
      }
      if (trigMode > 2) {
        trigMode = 2;
      }
      break;

    case 'S' :
      if (paramStr == "tart") {
        if (trigMode == 0) {
          pointCourant = 0;
          etat = acquisition;
      //    Serial.println("acq");
        }
        else {
          etat = attenteTrig;
     //     Serial.println("trig");
        }
      }

      if (paramStr == "top") {
        etat = attenteStart;
    //    Serial.println("stop");
      }
  }// switch
  chaine = "";
}

void trigger()
{ boolean seuilFranchi;
  int valeurCourante = analogRead(0); // synchro sur voie A0
  if ( trigMode == 1 ) { // montant
    seuilFranchi = (ancienneValeur < trigValue) && (valeurCourante >= trigValue);
  }
  else { // descendant
    seuilFranchi = (ancienneValeur >= trigValue) && (valeurCourante < trigValue);
  }
  if (seuilFranchi) {
    pointCourant = 0;
    etat = acquisition;
  }
  ancienneValeur = valeurCourante; // Sauve échantillon courant
}

void lecture()
{
  for (int c = 0; c < channel; c++) // Sampling loop
  {
    samples[c][pointCourant] = analogRead(c); // Sampling channel c
  }
  pointCourant ++;
  if (pointCourant == maxSamples) {
    envoiCourant = 0;
    etat = attenteEnvoi; // C'est le programme principal qui envoie les données
  }
}

void sendData()
{ // ligne par ligne pour pouvoir interrompre l'envoi par stop
  Serial.print(timeRes * envoiCourant); // on fait confiance au timer !
  for (int c = 0; c < channel; c++) { // boucle voies
    Serial.print(',');
    Serial.print(samples[c][envoiCourant]);
  }
  Serial.println();
  envoiCourant ++;
  if ((envoiCourant == maxSamples) && (etat = attenteEnvoi)) {
    etat = attenteStart;
  }
}

void Echant() {
  if (etat == attenteTrig) {
    trigger();
  }
  if (etat == acquisition) {
    lecture();
  }
}

void loop() {
  if (Serial.available() > 0) {
    char received = Serial.read();
    if ((received == '\n') || (received == '\r')) {
      // carriage return = #13 = '\r' = CR
      // new Line = line Feed = #10 = '\n' = LF
      commande();
    } // LineFeed or CarriageReturn
    else {
      etat = attenteStart;
      chaine += received;
    }
  }// serial available
  else {
    if (etat == attenteEnvoi) {
      sendData();
    }
  }
}
