/* Scopino - Scope application
 By Amit Zohar
 Ver 2.0, October 2014
 adapté pour Regressi J.M. Millet et Arduino Due 13/01/2019
 si quelqu'un améliore, envoyer la nouvelle version à regressi@orange.fr
*/

#include <DueTimer.h> // inclusion de la librairie Timer3

const int maxChannel = 4; // quatre voies A0 A1 A2 A3
const int maxSamples = 1024; // mémoire dynamique 4*1024*2 octets=8 ko
word samples[maxChannel][maxSamples];
// Volatile pour utilisation dans une interruption timer ?
unsigned long timeRes = 1000; // en microsec
int channel = 2;
int pointCourant = 0;
int envoiCourant = 0;
int ancienneValeur; // point précédent pour synchro seuil

int trigValue = 2048; // seuil synchro au milieu (12 bits)
int trigMode = 0; // mode synchro 0 : relaxé
const int waitSerial = 5; // ms
const int attenteTrig = 0;
const int attenteStart = 1;
const int acquisition = 2;
const int attenteEnvoi = 3;

int etat = 1;

String chaine;

void Trigger()
{ boolean seuilFranchi;
  int valeurCourante = analogRead(0); // synchro sur voie A0
  if ( trigMode == 1 ) { // montant
    seuilFranchi = (ancienneValeur < trigValue) && (valeurCourante >= trigValue);
  }
  else { // descendant
    seuilFranchi = (ancienneValeur >= trigValue) && (valeurCourante < trigValue);
  }
  if (seuilFranchi) {
    etat = acquisition;
    pointCourant = 0;
  }
  ancienneValeur = valeurCourante; // Save échantillon courant
}

void Echant() {
  if (etat == attenteTrig) {
    Trigger();
  }
  if (etat == acquisition) {
    Lecture();
  }
}

void Lecture()
{
  for (int c = 0; c < channel; c++) // Sampling loop
  {
    samples[c][pointCourant] = analogRead(c); // Sampling channel c
  }
  pointCourant ++;
  if (pointCourant == maxSamples) {
    envoiCourant = 0;
    etat = attenteEnvoi; // C'est le programme principal qui envoie les donnes
  }
}

void setup() {
  Serial.begin(115200);
  etat = attenteStart;
  analogReadResolution(12);
  ancienneValeur = analogRead(0);
  Timer3.setPeriod(timeRes);
  Timer3.attachInterrupt(Echant);
  Timer3.start();
}

/* Process serial input
 Protocol: C<channel><NL> or T<time resolution><NL> or 
 G<trigger value><NL> or H<trigger mode>
 (C) Channel: 0..1
 (T) Time resolution: en micros
 (G) Trigger value: value needed to be crossed for trigger (0-2047)
 (H) Trigger mode: 0=free run, 1=positive slope, 2=negative slope
*/

void Commande()
{
  if (chaine.length() < 2) {
    chaine = "";
    return;
  }
  etat = attenteStart; // une commande arrête l'acquisition
  //  noInterrupts();
  int carac = chaine[0];
  String paramStr = chaine.substring(1);
  Serial.println(chaine);
  chaine = "";

  switch (carac) {
    case 'C' : // Channel
      channel = paramStr.toInt();
      if (channel < 1) {
        channel = 1;
      }
      if (channel > 4) {
        channel = 4;
      }
      break;

    case 'T' : // Time resolution en micro seconde
      timeRes = paramStr.toInt();
      if (timeRes < 5) {
        timeRes = 5; // 200 kHz
      }
      if (timeRes > 10000) {
        timeRes = 10000; // 0.01 s ; 100 Hz
      }
      Timer3.stop(); // utile ?
      Timer3.setPeriod(timeRes);
      Timer3.start();
      break;

    case 'G' : // Trigger value
      trigValue = paramStr.toInt();
      if (trigValue < 96) {
        trigValue = 96; // un peu de marge
      }
      if (trigValue > 4000) { // 12 bits 4096
        trigValue = 4000;
      }
      break;

    case 'H' : // Trigger mode
      trigMode = paramStr.toInt();
      if (trigMode < 0) {
        trigMode = 0;
      }
      if (trigMode > 2) {
        trigMode = 2;
      }
      break;

    case 'S' :
      if (paramStr == "tart") {
        if (trigMode == 0) {
          // Serial.println("start relaxe");
          pointCourant = 0;
          etat = acquisition;
          Serial.println("start");
        }
        else {
          etat = attenteTrig;
          Serial.println("start trig");
        }
      }// Start
      if (paramStr == "top") {
        etat = attenteStart;
        Serial.println("stop");
      }
      break;
  }// switch
  chaine = "";
}

void sendData() {
  // envoi ligne par ligne pour pouvoir interrompre l'envoi par stop
  Serial.print(timeRes * envoiCourant); // on fait confiance au timer !
  for (int c = 0; c < channel; c++) { // boucle voies
    Serial.print(',');
    Serial.print(samples[c][envoiCourant]);
  }
  Serial.println();

  envoiCourant ++;
  if ((envoiCourant == maxSamples) && (etat = attenteEnvoi)) {
    etat = attenteStart;
  }

}

void loop() {
  if (Serial.available() > 0) {
    char received = Serial.read();
    if ((received == '\n') || (received == '\r')) {
      // carriage return = #13 = '\r' = CR
      // new Line = line Feed = #10 = '\n' = LF
      Commande();
    } // LineFeed
    else {
      etat = attenteStart;
      chaine += received;
    }
  }
  else {
    if (etat == attenteEnvoi) {
      sendData();
    }
  }
}
