/*
  WiFi UDP Send and Receive String
  This sketch wait an UDP packet on localPort using the WiFi module.
  When a packet is received an Acknowledge packet is sent to the client on port remotePort
  created 30 December 2012
  by dlf (Metodo2 srl)
*/

#include <SPI.h>
#include <WiFiNINA.h>
#include <WiFiUdp.h>
#include <arduino_secrets.h>

const int maxChannel = 2; // deux voies 0 et 1
const int maxSamples = 512; // mémoire dynamique 2048
const int attenteTrig = 0;
const int attenteStart = 1;
const int acquisition = 2;
const int attenteEnvoi = 3;

unsigned long tPrec, tZero; // gestion manuelle en attendant une bibliothèque d'interruption pour MKR1010

word samples[maxChannel][maxSamples];
unsigned long tacq[maxSamples];
unsigned long timeRes = 1000; // en microseconde donc 1 kHz
int etat = 1;
int channel = 2;
int pointCourant = 0;
int envoiCourant = 0;
int ancienneValeur; // point précédent pour synchro seuil 
int trigValue = 512; // seuil synchro au milieu (10 bits)
int trigMode = 0; // mode synchro 0 : relaxé

int status = WL_IDLE_STATUS;
char ssid[] = SECRET_SSID;
char pass[] = SECRET_PASS;
unsigned int localPort = 2390; // local port to listen on
IPAddress acquisitionIp; // le client qui a demandé une acquisition
unsigned int acquisitionPort;

char inBuffer[255]; //buffer to hold incoming packet

WiFiUDP Udp;

void setup() {
  //Initialize serial and wait for port to open:
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }

  // check for the WiFi module:
  if (WiFi.status() == WL_NO_MODULE) {
    Serial.println("Communication with WiFi module failed!");
    // don't continue
    while (true);
  }

  String fv = WiFi.firmwareVersion();
  if (fv < "1.0.0") {
    Serial.println("Please upgrade the firmware");
  }

  // attempt to connect to Wifi network:
  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    status = WiFi.begin(ssid, pass);

    // wait 5 seconds for connection:
    delay(5000);
  }
  Serial.println("Connected to wifi");
  printWifiStatus();

  Udp.begin(localPort);

  tPrec = micros() + timeRes;
}

void lecture()
{
  for (int c = 0; c < channel; c++) // Sampling loop
  {
    samples[c][pointCourant] = analogRead(c); // Sampling channel c
  }
  pointCourant ++;
  if (pointCourant == maxSamples) {
    envoiCourant = 0;
    Serial.println("envoi");
    etat = attenteEnvoi; // C'est le programme principal qui envoie
  }
}

void trigger()
{ boolean seuilFranchi;
  int valeurCourante = analogRead(0); // synchro sur voie A0
  if ( trigMode == 1 ) { // montant
    seuilFranchi = (ancienneValeur < trigValue) && (valeurCourante >= trigValue);
  }
  else { // descendant
    seuilFranchi = (ancienneValeur >= trigValue) && (valeurCourante < trigValue);
  }
  if (seuilFranchi) {
    pointCourant = 0;
    //   Serial.println("seuil franchi");
    etat = acquisition;
  }
  ancienneValeur = valeurCourante; // Save échantillon courant
}

void Echant() {
  if (etat == attenteTrig) {
    trigger();
  }
  if (etat == acquisition) {
    if (pointCourant == 0) {
      tacq[0] = 0;
      tZero = micros();
    }
    else {
      tacq[pointCourant] = micros() - tZero;
    }
    lecture();
  }
}

void writeUdp(String command) { // send command to the IP address and port
  int dataSize = command.length() + 1;
  char data[dataSize];
  command.toCharArray(data, dataSize);
  Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
  Udp.write(data, dataSize); // send the read character to the WifiSerial
  Udp.endPacket();
}

void sendData()
{ // ligne par ligne pour pouvoir interrompre l'envoi par stop
  String dataStr = String(tacq[envoiCourant]); // temps
  for (int c = 0; c < channel; c++) { // boucle voies
    dataStr = dataStr + "," + String(samples[c][envoiCourant]);
  }
  writeUdp(dataStr);
  envoiCourant ++;
  if ((envoiCourant == maxSamples) && (etat = attenteEnvoi)) {
    etat = attenteStart;
    acquisitionIp = IPAddress(0, 0, 0, 0);
    acquisitionPort = 0;
  }
}

void command() {
  String chaine = String(inBuffer);
  Serial.print("commande : ");
  Serial.println(chaine);
  if (chaine.length() < 2) {
    return;
  }
  String paramStr = chaine.substring(1);
  byte carac = inBuffer[0];

  switch (carac) {
    case 'C' : // Channel
      channel = paramStr.toInt();
      if (channel <= 1) {
        channel = 1;
      }
      if (channel >= 2) {
        channel = 2;
      }
      break;

    case 'T' : // Time resolution en micro seconde
      timeRes = paramStr.toInt();
      if (timeRes < 100) {
        timeRes = 100; // f=10 kHz
      }
      if (timeRes > 10000) {
        timeRes = 10000; // 0.01 s 100 Hz
      }
      break;

    case 'G' : // Trigger value
      trigValue = paramStr.toInt();
      if (trigValue < 24) {
        trigValue = 24; // un peu de marge
      }
      if (trigValue > 1000) {
        trigValue = 1000;
      }
      break;

    case 'H' :   // Trigger mode
      trigMode = paramStr.toInt();
      if (trigMode < 0) {
        trigMode = 0;
      }
      if (trigMode > 2) {
        trigMode = 2;
      }
      break;

    case 'S' :
      if (paramStr == "tart") {
        if (trigMode == 0) {
          pointCourant = 0;
          etat = acquisition;
          acquisitionIp = Udp.remoteIP();
          acquisitionPort = Udp.remotePort();
          Serial.println("acquisition");
        }
        else {
          etat = attenteTrig;
          acquisitionIp = Udp.remoteIP();
          acquisitionPort = Udp.remotePort();
        }

      }

      if (paramStr == "top") {
        etat = attenteStart;
        Serial.println("stop");
        acquisitionIp = IPAddress(0, 0, 0, 0);
        acquisitionPort = 0;
      }
      break;

  } // switch commande

}


void loop() {

  // if there's data available, read a packet
  int packetSize = Udp.parsePacket();
  if (packetSize) {
    IPAddress remoteIp = Udp.remoteIP();
    // read the packet into packetBufffer
    int len = Udp.read(inBuffer, 255);
    if (len > 0) {
      inBuffer[len] = 0;
    }
    //  Serial.print("Contents:");
    //  Serial.println(inBuffer);
    if (etat == attenteStart) {
      command();
      writeUdp("OK");
    }
    else {
      if (remoteIp = acquisitionIp) {
        command();
        writeUdp("OK");
      }
      else {
        writeUdp("Busy");
        // seul le client qui a lancé l'acquisition peut l'arrêter
      }
    }// acquisition ou envoi de données en cours
  }// if packetSize
  else {
    if (etat == attenteEnvoi) {
      sendData();
    }
  }
  unsigned long deltat = micros()-tPrec;
  if (deltat >= timeRes) {
    Echant();
    tPrec += timeRes;
  }
}

void printWifiStatus() {
  // print the SSID of the network you're attached to:
  Serial.print("SSID: ");
  Serial.println(WiFi.SSID());

  // print your board's IP address:
  IPAddress ip = WiFi.localIP();

  Serial.print("IP Address: ");
  Serial.println(ip);

  Serial.print("Port :");
  Serial.println(localPort);
}
