/*
  WiFi UDP Send and Receive String
  This sketch wait an UDP packet on localPort using the WiFi module.
  When a packet is received an Acknowledge packet is sent to the client on port remotePort
  created 30 December 2012
  by dlf (Metodo2 srl)
*/

#include <SPI.h>
#include <WiFiNINA.h>
#include <WiFiUdp.h>
#include <arduino_secrets.h>

int status = WL_IDLE_STATUS;
char ssid[] = SECRET_SSID;
char pass[] = SECRET_PASS;

unsigned int localPort = 2390;      // local port to listen on

char packetBuffer[255]; //buffer to hold incoming packet

WiFiUDP Udp;

void setup() {
  //Initialize serial and wait for port to open:
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }

  // check for the WiFi module:
  if (WiFi.status() == WL_NO_MODULE) {
    Serial.println("Communication with WiFi module failed!");
    // don't continue
    while (true);
  }

  String fv = WiFi.firmwareVersion();
  if (fv < "1.0.0") {
    Serial.println("Please upgrade the firmware");
  }

  // attempt to connect to Wifi network:
  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    status = WiFi.begin(ssid, pass);

    // wait 5 seconds for connection:
    delay(5000);
  }
  Serial.println("Connected to wifi");
  printWifiStatus();

  Udp.begin(localPort);
}

String getTemp() // get temperature
{
  int a =  analogRead(A0);
  float temperature = a * 5.0 / 1024;
  int b =  analogRead(A1);
  float humidite = a * 100 / 1024;
  String reponse = String(temperature, 2) + "," + String(humidite, 1);
  return reponse;
}

void sendData(String command) {
  int dataSize = command.length() + 1;
  char data[dataSize];
  command.toCharArray(data, dataSize);
  Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
  Udp.write(data, dataSize); // send the read character to the WifiSerial
  Udp.endPacket();
}

void loop() {
  // if there's data available, read a packet
  int packetSize = Udp.parsePacket();
  if (packetSize) {
    int len = Udp.read(packetBuffer, 255);
    if (len > 0) {
      packetBuffer[len] = 0;
    }

    String ordre = packetBuffer;
    Serial.println(ordre);

    if (ordre.startsWith("Stop")) {
    }
    if (ordre.startsWith("Get")) {
      sendData(getTemp());
    }

  }
}

void printWifiStatus() {
  // print the SSID of the network you're attached to:
  Serial.print("SSID : ");
  Serial.println(WiFi.SSID());

  // print your board's IP address:
  IPAddress ip = WiFi.localIP();
  Serial.print("IP Address : ");
  Serial.println(ip);

  // print the received signal strength:
  /*
    long rssi = WiFi.RSSI();
    Serial.print("signal strength (RSSI):");
    Serial.print(rssi);
    Serial.println(" dBm");
  */
  Serial.print("Port : ");
  Serial.println(localPort);
}
