// Acqusition lente avec Regressi

const int waitSerial = 5; // ms

int timeRes = 500; // en ms
bool acquisition = true;
unsigned long tempsPrec;

void setup() {
  Serial.begin(9600); 
  tempsPrec = millis();
}

void getCommand()
{
  bool sauveAcq = acquisition;
  acquisition = false; // le temps de traiter la commande
  String rec;
  int posC;
  delay(waitSerial); // Let all chars arrive
  rec = Serial.readString();

  if (rec == "Start") {
     acquisition = true;
  }
  else { 
     if (rec == "Stop") {
        acquisition = false;
     }
     else {
        acquisition = sauveAcq;
     }
  }

}

void lecture()
{
  word tensionInt,temperatureInt;
  float tension, temperature;
  tensionInt = analogRead(0); 
  tension = tensionInt*5.0/1024;
  temperatureInt = analogRead(1); // LM35 sur A1
  temperature = temperatureInt*5.0/1024*100; // 10 mV/°C
  // Envoie les données
  // acquisition basse vitesse, on a le temps d'utiliser des flottants
  Serial.print(tension);
  Serial.print(',');
  Serial.print(temperature);
  Serial.println(); // Carriage return
  tempsPrec += timeRes;
}

void loop() {
  if (Serial.available() > 0) {
     getCommand(); // On lit les commandes
  }
  else {
    unsigned long tempsCourant = millis();
    if ((tempsCourant >= tempsPrec) && (acquisition)) {
     lecture();
    }
  }
}
