/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.TileRendererBase;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES3;
import javax.media.opengl.GLException;

public class RandomTileRenderer
extends TileRendererBase {
    private boolean tileRectSet = false;

    @Override
    public final int getParam(int n) {
        switch (n) {
            case 1: {
                return this.imageSize.getWidth();
            }
            case 2: {
                return this.imageSize.getHeight();
            }
            case 3: {
                return this.currentTileXPos;
            }
            case 4: {
                return this.currentTileYPos;
            }
            case 5: {
                return this.currentTileWidth;
            }
            case 6: {
                return this.currentTileHeight;
            }
        }
        throw new IllegalArgumentException("Invalid pname: " + n);
    }

    public void setTileRect(int n, int n2, int n3, int n4) throws IllegalStateException, IllegalArgumentException {
        if (0 > n || 0 > n2) {
            throw new IllegalArgumentException("Tile pos must be >= 0/0");
        }
        if (0 >= n3 || 0 >= n4) {
            throw new IllegalArgumentException("Tile size must be > 0x0");
        }
        this.currentTileXPos = n;
        this.currentTileYPos = n2;
        this.currentTileWidth = n3;
        this.currentTileHeight = n4;
        this.tileRectSet = true;
    }

    @Override
    public final boolean isSetup() {
        return 0 < this.imageSize.getWidth() && 0 < this.imageSize.getHeight() && this.tileRectSet;
    }

    @Override
    public final boolean eot() {
        return false;
    }

    @Override
    public final void reset() {
    }

    @Override
    public final void beginTile(GL gL) throws IllegalStateException, GLException {
        if (0 >= this.imageSize.getWidth() || 0 >= this.imageSize.getHeight()) {
            throw new IllegalStateException("Image size has not been set");
        }
        if (!this.tileRectSet) {
            throw new IllegalStateException("tileRect has not been set");
        }
        this.validateGL(gL);
        gL.glViewport(0, 0, this.currentTileWidth, this.currentTileHeight);
        if (DEBUG) {
            System.err.println("TileRenderer.begin.X: " + this.toString());
        }
        this.beginCalled = true;
    }

    @Override
    public void endTile(GL gL) throws IllegalStateException, GLException {
        int n;
        int n2;
        int n3;
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes;
        int n4;
        GL2ES3 gL2ES3;
        if (!this.beginCalled) {
            throw new IllegalStateException("beginTile(..) has not been called");
        }
        this.validateGL(gL);
        gL.glFlush();
        this.psm.save(gL);
        this.psm.setPackAlignment(gL, 1);
        if (gL.isGL2ES3()) {
            gL2ES3 = gL.getGL2ES3();
            n4 = gL2ES3.getDefaultReadBuffer();
            gL2ES3.glReadBuffer(n4);
        } else {
            gL2ES3 = null;
            n4 = 0;
        }
        if (DEBUG) {
            System.err.println("TileRenderer.end.0: readBuffer 0x" + Integer.toHexString(n4) + ", " + this.toString());
        }
        int[] nArray = new int[1];
        if (this.tileBuffer != null) {
            gLPixelAttributes = this.tileBuffer.pixelAttributes;
            n3 = this.currentTileWidth;
            n2 = this.currentTileHeight;
            n = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.bytesPerPixel, n3, n2, 1, true);
            this.tileBuffer.clear();
            if (this.tileBuffer.requiresNewBuffer(gL, n3, n2, n)) {
                throw new IndexOutOfBoundsException("Required " + n + " bytes of buffer, only had " + this.tileBuffer);
            }
            gL.glReadPixels(0, 0, n3, n2, gLPixelAttributes.format, gLPixelAttributes.type, this.tileBuffer.buffer);
            gL.glFlush();
            this.tileBuffer.position(n);
            this.tileBuffer.flip();
        }
        if (this.imageBuffer != null) {
            gLPixelAttributes = this.imageBuffer.pixelAttributes;
            n3 = this.currentTileWidth;
            n2 = this.currentTileHeight;
            n = this.imageSize.getWidth();
            this.psm.setPackRowLength(gL2ES3, n);
            int n5 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.bytesPerPixel, n3, n2, 1, true);
            int n6 = (this.currentTileXPos + this.currentTileYPos * n) * gLPixelAttributes.bytesPerPixel;
            int n7 = n6 + n5;
            this.imageBuffer.clear();
            if (this.imageBuffer.requiresNewBuffer(gL, n3, n2, n5)) {
                throw new IndexOutOfBoundsException("Required " + n7 + " bytes of buffer, only had " + this.imageBuffer);
            }
            this.imageBuffer.position(n6);
            gL.glReadPixels(0, 0, n3, n2, gLPixelAttributes.format, gLPixelAttributes.type, this.imageBuffer.buffer);
            gL.glFlush();
            this.imageBuffer.position(n7);
            this.imageBuffer.flip();
        }
        this.psm.restore(gL);
        this.beginCalled = false;
    }

    public void display(int n, int n2, int n3, int n4) throws IllegalStateException {
        this.setTileRect(n, n2, n3, n4);
        this.display();
    }
}

