/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.Main;
import filius.gui.netzwerksicht.GUIKnotenItem;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class JCablePanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private GUIKnotenItem ziel1;
    private GUIKnotenItem ziel2;
    private QuadCurve2D currCurve = null;
    private Color kabelFarbe = new Color(64, 64, 64);
    private final Color farbeStandard = new Color(64, 64, 64);
    private final Color farbeBlinken = new Color(0, 255, 64);

    public JCablePanel() {
        this.setOpaque(false);
    }

    public void updateBounds() {
        int t1;
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JCablePanel), updateBounds()");
        int x1 = this.ziel1.getImageLabel().getX();
        int x2 = this.ziel2.getImageLabel().getX();
        int y1 = this.ziel1.getImageLabel().getY();
        int y2 = this.ziel2.getImageLabel().getY();
        x1 = (int)((double)x1 + 0.5 * (double)this.ziel1.getImageLabel().getWidth());
        y1 = (int)((double)y1 + 0.5 * (double)this.ziel1.getImageLabel().getHeight());
        x2 = (int)((double)x2 + 0.5 * (double)this.ziel2.getImageLabel().getWidth());
        y2 = (int)((double)y2 + 0.5 * (double)this.ziel2.getImageLabel().getHeight());
        if (x1 > x2) {
            t1 = x1;
            x1 = x2;
            x2 = t1;
        }
        if (y1 > y2) {
            t1 = y1;
            y1 = y2;
            y2 = t1;
        }
        this.setBounds(x1 - 2, y1 - 2, x2 - x1 + 4, y2 - y1 + 4);
        Main.debug.println("JCablePanel (" + this.hashCode() + "), bounds: " + x1 + "/" + y1 + ", " + x2 + "/" + y2 + "  (W:" + (x2 - x1) + ", H:" + (y2 - y1) + ")");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int x1 = (int)((double)this.ziel1.getImageLabel().getX() + 0.5 * (double)this.ziel1.getImageLabel().getWidth());
        int x2 = (int)((double)this.ziel2.getImageLabel().getX() + 0.5 * (double)this.ziel2.getImageLabel().getWidth());
        int y1 = (int)((double)this.ziel1.getImageLabel().getY() + 0.5 * (double)this.ziel1.getImageLabel().getHeight());
        int y2 = (int)((double)this.ziel2.getImageLabel().getY() + 0.5 * (double)this.ziel2.getImageLabel().getHeight());
        g.setColor(this.kabelFarbe);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(2.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int kp1 = (x1 - this.getX() + x2 - this.getX()) / 4;
        if (x1 > x2 && y1 > y2 || x1 < x2 && y1 < y2) {
            kp1 = 3 * kp1;
        }
        int kp2 = (y1 - this.getY() + y2 - this.getY()) / 4;
        QuadCurve2D.Double myCurve = new QuadCurve2D.Double(x1 - this.getX(), y1 - this.getY(), kp1, kp2, x2 - this.getX(), y2 - this.getY());
        g2.draw(myCurve);
        this.currCurve = myCurve;
        this.setOpaque(false);
    }

    public boolean clicked(int x, int y) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JCablePanel), clicked(" + x + "," + y + ")");
        int delta = 10;
        Rectangle2D.Double absolutePointerRect = new Rectangle2D.Double(x - delta, y - delta, 2 * delta, 2 * delta);
        boolean hitPanel = this.getBounds().intersects(absolutePointerRect);
        Rectangle2D.Double relativePointerRect = new Rectangle2D.Double(x - this.getX() - delta, y - this.getY() - delta, 2 * delta, 2 * delta);
        boolean hitCurve = this.currCurve.intersects(relativePointerRect);
        return hitCurve && hitPanel;
    }

    public GUIKnotenItem getZiel1() {
        return this.ziel1;
    }

    public void setZiel1(GUIKnotenItem ziel1) {
        this.ziel1 = ziel1;
    }

    public GUIKnotenItem getZiel2() {
        return this.ziel2;
    }

    public void setZiel2(GUIKnotenItem ziel2) {
        this.ziel2 = ziel2;
        this.updateBounds();
    }

    @Override
    public void update(Observable o, Object arg) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JCablePanel), update(" + o + "," + arg + ")");
        if (arg.equals(Boolean.TRUE)) {
            this.kabelFarbe = this.farbeBlinken;
            this.setLocation(this.getX() - 1, this.getY());
            this.setLocation(this.getX() + 1, this.getY());
        } else {
            this.kabelFarbe = this.farbeStandard;
        }
        this.updateUI();
    }
}

