/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.SzenarioVerwaltung;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;

public class JDocuElement
extends JPanel
implements I18n {
    private static final long serialVersionUID = 1L;
    private boolean selected = false;
    private int updateType;
    private Dimension elemMoveOffset;
    private boolean enabled = true;
    private JTextArea textArea;
    private static final int TEXT_BORDER_WIDTH = 5;

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setFocusable(enabled);
        if (this.textArea != null) {
            this.textArea.setEditable(enabled);
            this.textArea.setFocusable(enabled);
            if (enabled) {
                this.textArea.setBackground(new Color(0.9f, 0.9f, 0.9f, 0.5f));
            } else {
                this.textArea.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            }
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean result = this.textArea != null ? this.textArea.requestFocusInWindow() : super.requestFocusInWindow();
        return result;
    }

    private void initRectangle() {
        this.setSize(100, 50);
        Color color = new Color(0.8f, 0.8f, 0.8f, 0.8f);
        this.setBackground(color);
    }

    public JDocuElement(boolean text) {
        if (!text) {
            this.initRectangle();
        } else {
            this.initTextfield();
        }
        this.initListener();
    }

    private void initTextfield() {
        this.setSize(100, 50);
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEnabled(this.enabled);
        this.add((Component)this.textArea, "Center");
    }

    private void initListener() {
        JComponent comp = this.textArea != null ? this.textArea : this;
        comp.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JDocuElement.this.enabled) {
                    JDocuElement.this.selected = false;
                    JDocuElement.this.updateType = 0;
                    JDocuElement.this.updateUI();
                    SzenarioVerwaltung.getInstance().setzeGeaendert();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (JDocuElement.this.enabled) {
                    JDocuElement.this.selected = true;
                    if (e.getButton() == 3) {
                        JMenuItem pmLoeschen = new JMenuItem(I18n.messages.getString("guievents_msg7"));
                        pmLoeschen.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                GUIContainer.getGUIContainer().removeDocuElement(JDocuElement.this);
                                GUIContainer.getGUIContainer().updateViewport();
                            }
                        });
                        JPopupMenu popmen = new JPopupMenu();
                        popmen.add(pmLoeschen);
                        JDocuElement.this.add(popmen);
                        popmen.setVisible(true);
                        popmen.show(JDocuElement.this, e.getX(), e.getY());
                    } else if (JDocuElement.this.updateType == 1) {
                        JDocuElement.this.elemMoveOffset = new Dimension(e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (JDocuElement.this.enabled) {
                    JMainFrame.getJMainFrame().setCursor(new Cursor(0));
                }
            }
        });
        comp.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JDocuElement.this.enabled) {
                    if (JDocuElement.this.updateType == 1) {
                        JDocuElement.this.setLocation(e.getX() - (int)JDocuElement.this.elemMoveOffset.getWidth() + JDocuElement.this.getX(), e.getY() - (int)JDocuElement.this.elemMoveOffset.getHeight() + JDocuElement.this.getY());
                    } else if (JDocuElement.this.updateType == 2) {
                        JDocuElement.this.setBounds(JDocuElement.this.getX() + e.getX(), JDocuElement.this.getY(), JDocuElement.this.getWidth() - e.getX(), JDocuElement.this.getHeight());
                    } else if (JDocuElement.this.updateType == 3) {
                        JDocuElement.this.setBounds(JDocuElement.this.getX(), JDocuElement.this.getY(), e.getX(), JDocuElement.this.getHeight());
                    } else if (JDocuElement.this.updateType == 5) {
                        JDocuElement.this.setBounds(JDocuElement.this.getX(), JDocuElement.this.getY(), JDocuElement.this.getWidth(), e.getY());
                    } else if (JDocuElement.this.updateType == 4) {
                        JDocuElement.this.setBounds(JDocuElement.this.getX(), JDocuElement.this.getY() + e.getY(), JDocuElement.this.getWidth(), JDocuElement.this.getHeight() - e.getY());
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (JDocuElement.this.enabled) {
                    block24: {
                        int x = e.getX();
                        int y = e.getY();
                        if (x <= 5) {
                            JDocuElement.this.updateType = 2;
                        } else if (x >= JDocuElement.this.getWidth() - 5) {
                            JDocuElement.this.updateType = 3;
                        } else if (y <= 5) {
                            JDocuElement.this.updateType = 4;
                        } else if (y >= JDocuElement.this.getHeight() - 5) {
                            JDocuElement.this.updateType = 5;
                        } else if (JDocuElement.this.textArea != null) {
                            try {
                                Rectangle charPos = JDocuElement.this.textArea.modelToView(JDocuElement.this.textArea.viewToModel(e.getPoint()));
                                if ((double)e.getY() >= charPos.getY() && (double)e.getY() <= charPos.getY() + charPos.getHeight()) {
                                    JDocuElement.this.updateType = 0;
                                    break block24;
                                }
                                JDocuElement.this.updateType = 1;
                            }
                            catch (BadLocationException badLocationException) {}
                        } else {
                            JDocuElement.this.updateType = 1;
                        }
                    }
                    if (JDocuElement.this.updateType == 1) {
                        JMainFrame.getJMainFrame().setCursor(new Cursor(13));
                    } else if (JDocuElement.this.updateType == 3) {
                        JMainFrame.getJMainFrame().setCursor(new Cursor(11));
                    } else if (JDocuElement.this.updateType == 2) {
                        JMainFrame.getJMainFrame().setCursor(new Cursor(10));
                    } else if (JDocuElement.this.updateType == 4) {
                        JMainFrame.getJMainFrame().setCursor(new Cursor(8));
                    } else if (JDocuElement.this.updateType == 5) {
                        JMainFrame.getJMainFrame().setCursor(new Cursor(9));
                    } else {
                        JMainFrame.getJMainFrame().setCursor(new Cursor(0));
                    }
                }
            }
        });
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public String getText() {
        if (this.textArea != null) {
            return this.textArea.getText();
        }
        return null;
    }

    public void setText(String text) {
        if (this.textArea != null) {
            this.textArea.setText(text);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.selected) {
            g.setColor(new Color(0, 0, 0));
            Graphics2D g2 = (Graphics2D)g;
            BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{2.0f}, 0.0f);
            g2.setStroke(stroke);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(new Color(128, 200, 255));
            g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
            g2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

