/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.Main;
import filius.gui.anwendungssicht.JTableEditable;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.firewall.Firewall;
import filius.software.firewall.FirewallRule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JFirewallDialog
extends JDialog
implements I18n {
    private static final long serialVersionUID = 1L;
    private static final Color TAB_COLOR = new Color(240, 240, 240);
    JFirewallDialog jfd = null;
    private Firewall firewall;
    DefaultTableModel dtmTabelle;
    DefaultTableModel dtmTabellePort;
    JScrollPane spTabelle;
    JScrollPane spTabellePort;
    Box boxFirewall;
    Box boxTabellen;
    private JTableEditable ruleTable;
    private JComboBox defaultPolicyCombo;
    private JCheckBox rejectConnections;
    private JCheckBox activateFirewall;
    private JCheckBox dropICMP;
    private JCheckBox onlyFilterSYN;

    public JFirewallDialog(Firewall firewall, JFrame dummyFrame) {
        super(dummyFrame, messages.getString("jfirewalldialog_msg1"), true);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + ", constr: JFirewallDialog(" + firewall + "," + dummyFrame + ")");
        this.firewall = firewall;
        this.jfd = this;
        this.erzeugeFenster();
    }

    private Box erzeugeNicBox() {
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(10));
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        this.activateFirewall = new JCheckBox(messages.getString("jfirewalldialog_msg38"));
        this.activateFirewall.setOpaque(false);
        this.activateFirewall.setSelected(this.firewall.getRejectIncomingConnections());
        this.activateFirewall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFirewallDialog.this.firewall.setActivated(((JCheckBox)e.getSource()).isSelected());
            }
        });
        hBox.add(this.activateFirewall);
        hBox.add(Box.createHorizontalGlue());
        vBox.add(hBox);
        JTextArea label = new JTextArea();
        label.setEditable(false);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setOpaque(false);
        label.setFont(new Font("Dialog", 0, 12));
        label.setText(messages.getString("jfirewalldialog_msg39"));
        hBox = Box.createHorizontalBox();
        hBox.add(label);
        hBox.add(Box.createHorizontalStrut(10));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        this.dropICMP = new JCheckBox(messages.getString("jfirewalldialog_msg40"));
        this.dropICMP.setOpaque(false);
        this.dropICMP.setSelected(this.firewall.getRejectIncomingConnections());
        this.dropICMP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFirewallDialog.this.firewall.setDropICMP(((JCheckBox)e.getSource()).isSelected());
            }
        });
        hBox.add(this.dropICMP);
        hBox.add(Box.createHorizontalGlue());
        vBox.add(hBox);
        label = new JTextArea();
        label.setEditable(false);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setOpaque(false);
        label.setFont(new Font("Dialog", 0, 12));
        label.setText(messages.getString("jfirewalldialog_msg41"));
        hBox = Box.createHorizontalBox();
        hBox.add(label);
        hBox.add(Box.createHorizontalStrut(10));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        this.onlyFilterSYN = new JCheckBox(messages.getString("jfirewalldialog_msg42"));
        this.onlyFilterSYN.setOpaque(false);
        this.onlyFilterSYN.setSelected(this.firewall.getRejectIncomingConnections());
        this.onlyFilterSYN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFirewallDialog.this.firewall.setAllowRelatedPackets(((JCheckBox)e.getSource()).isSelected());
            }
        });
        hBox.add(this.onlyFilterSYN);
        hBox.add(Box.createHorizontalGlue());
        vBox.add(hBox);
        label = new JTextArea();
        label.setEditable(false);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setOpaque(false);
        label.setFont(new Font("Dialog", 0, 12));
        label.setText(messages.getString("jfirewalldialog_msg43"));
        hBox = Box.createHorizontalBox();
        hBox.add(label);
        hBox.add(Box.createHorizontalStrut(10));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(Box.createVerticalStrut(1000));
        return vBox;
    }

    private Box firewallRuleBox() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", firewallRuleBox()");
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(10));
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        JTextArea textArea = new JTextArea();
        textArea.setText(messages.getString("jfirewalldialog_msg37"));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFont(new Font("Dialog", 0, 12));
        textArea.setEditable(false);
        textArea.setOpaque(false);
        hBox.add(textArea);
        hBox.add(Box.createHorizontalStrut(10));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        JLabel label = new JLabel(messages.getString("jfirewalldialog_msg36"));
        hBox.add(label);
        hBox.add(Box.createHorizontalStrut(10));
        this.defaultPolicyCombo = new JComboBox();
        this.defaultPolicyCombo.addItem(messages.getString("jfirewalldialog_msg33"));
        this.defaultPolicyCombo.addItem(messages.getString("jfirewalldialog_msg34"));
        this.defaultPolicyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFirewallDialog.this.firewall.setDefaultPolicyString((String)JFirewallDialog.this.defaultPolicyCombo.getSelectedItem());
                JFirewallDialog.this.updateRuleTable();
            }
        });
        hBox.add(this.defaultPolicyCombo);
        hBox.add(Box.createHorizontalStrut(10));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        DefaultTableModel model = new DefaultTableModel(0, 8);
        this.ruleTable = new JTableEditable((TableModel)model, true);
        this.ruleTable.setParentGUI(this);
        this.ruleTable.setSelectionMode(0);
        this.ruleTable.setIntercellSpacing(new Dimension(10, 5));
        this.ruleTable.setRowHeight(30);
        this.ruleTable.setShowGrid(true);
        this.ruleTable.setFillsViewportHeight(true);
        this.ruleTable.setBackground(Color.WHITE);
        this.ruleTable.setShowHorizontalLines(true);
        TableColumnModel columnModel = this.ruleTable.getColumnModel();
        columnModel.getColumn(0).setHeaderValue(messages.getString("jfirewalldialog_msg26"));
        columnModel.getColumn(0).setCellEditor(null);
        columnModel.getColumn(1).setHeaderValue(messages.getString("jfirewalldialog_msg27"));
        columnModel.getColumn(2).setHeaderValue(messages.getString("jfirewalldialog_msg28"));
        columnModel.getColumn(3).setHeaderValue(messages.getString("jfirewalldialog_msg29"));
        columnModel.getColumn(4).setHeaderValue(messages.getString("jfirewalldialog_msg30"));
        columnModel.getColumn(5).setHeaderValue(messages.getString("jfirewalldialog_msg31"));
        String[] protValues = new String[]{"*", "TCP", "UDP"};
        columnModel.getColumn(5).setCellEditor(new ComboBoxTableCellEditor(protValues));
        columnModel.getColumn(6).setHeaderValue(messages.getString("jfirewalldialog_msg35"));
        columnModel.getColumn(7).setHeaderValue(messages.getString("jfirewalldialog_msg32"));
        String[] actionValues = new String[]{messages.getString("jfirewalldialog_msg33"), messages.getString("jfirewalldialog_msg34")};
        columnModel.getColumn(7).setCellEditor(new ComboBoxTableCellEditor(actionValues));
        columnModel.getColumn(0).setPreferredWidth(30);
        columnModel.getColumn(1).setPreferredWidth(130);
        columnModel.getColumn(2).setPreferredWidth(130);
        columnModel.getColumn(3).setPreferredWidth(130);
        columnModel.getColumn(4).setPreferredWidth(130);
        columnModel.getColumn(5).setPreferredWidth(80);
        columnModel.getColumn(6).setPreferredWidth(60);
        columnModel.getColumn(7).setPreferredWidth(80);
        JScrollPane scrollPane = new JScrollPane(this.ruleTable);
        scrollPane.setPreferredSize(new Dimension(555, 300));
        vBox.add(scrollPane);
        vBox.add(Box.createVerticalStrut(10));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        JButton button = new JButton(messages.getString("jfirewalldialog_msg22"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowSel = -1;
                boolean success = false;
                try {
                    if (JFirewallDialog.this.ruleTable.getSelectedRowCount() == 1) {
                        rowSel = JFirewallDialog.this.ruleTable.getSelectedRow();
                        String idStr = (String)JFirewallDialog.this.ruleTable.getValueAt(rowSel, 0);
                        success = JFirewallDialog.this.firewall.moveUp(Integer.parseInt(idStr));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JFirewallDialog.this.updateRuleTable();
                if (rowSel >= 0 && success) {
                    JFirewallDialog.this.ruleTable.setRowSelectionInterval(rowSel - 1, rowSel - 1);
                }
            }
        });
        hBox.add(button);
        hBox.add(Box.createHorizontalStrut(10));
        button = new JButton(messages.getString("jfirewalldialog_msg23"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowSel = -1;
                boolean success = false;
                try {
                    if (JFirewallDialog.this.ruleTable.getSelectedRowCount() == 1) {
                        rowSel = JFirewallDialog.this.ruleTable.getSelectedRow();
                        String idStr = (String)JFirewallDialog.this.ruleTable.getValueAt(rowSel, 0);
                        success = JFirewallDialog.this.firewall.moveDown(Integer.parseInt(idStr));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JFirewallDialog.this.updateRuleTable();
                if (rowSel >= 0 && success) {
                    JFirewallDialog.this.ruleTable.setRowSelectionInterval(rowSel + 1, rowSel + 1);
                }
            }
        });
        hBox.add(button);
        hBox.add(Box.createHorizontalStrut(30));
        button = new JButton(messages.getString("jfirewalldialog_msg24"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFirewallDialog.this.firewall.addRule();
                JFirewallDialog.this.updateRuleTable();
            }
        });
        hBox.add(button);
        hBox.add(Box.createHorizontalStrut(10));
        button = new JButton(messages.getString("jfirewalldialog_msg25"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowSel = -1;
                try {
                    if (JFirewallDialog.this.ruleTable.getSelectedRowCount() == 1) {
                        rowSel = JFirewallDialog.this.ruleTable.getSelectedRow();
                        String idStr = (String)JFirewallDialog.this.ruleTable.getValueAt(rowSel, 0);
                        Main.debug.println("DEBUG (" + this.hashCode() + ") " + this.getClass() + ", del action: rowSel=" + rowSel + ", rows count=" + JFirewallDialog.this.firewall.getRuleset().size());
                        JFirewallDialog.this.firewall.delRule(Integer.parseInt(idStr));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JFirewallDialog.this.updateRuleTable();
                if (rowSel >= 0) {
                    if (rowSel < JFirewallDialog.this.firewall.getRuleset().size()) {
                        JFirewallDialog.this.ruleTable.setRowSelectionInterval(rowSel, rowSel);
                    } else if (JFirewallDialog.this.firewall.getRuleset().size() > 0) {
                        JFirewallDialog.this.ruleTable.setRowSelectionInterval(JFirewallDialog.this.firewall.getRuleset().size() - 1, JFirewallDialog.this.firewall.getRuleset().size() - 1);
                    }
                }
            }
        });
        hBox.add(button);
        hBox.add(Box.createHorizontalStrut(10));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        this.updateRuleTable();
        return vBox;
    }

    private void erzeugeFenster() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", erzeugeFenster()");
        JPanel hauptPanel = new JPanel(new BorderLayout());
        JTabbedPane tp = new JTabbedPane();
        tp.add(messages.getString("jfirewalldialog_msg18"), this.erzeugeNicBox());
        tp.setBackgroundAt(0, TAB_COLOR);
        tp.add(messages.getString("jfirewalldialog_msg21"), this.firewallRuleBox());
        tp.setBackgroundAt(1, TAB_COLOR);
        hauptPanel.add((Component)tp, "Center");
        hauptPanel.setBackground(TAB_COLOR);
        this.getContentPane().add(hauptPanel);
    }

    private void updateCellColors() {
        TableColumnModel colModel = this.ruleTable.getColumnModel();
        JTableEditable.ColorTableCellRenderer cellSrcIP = (JTableEditable.ColorTableCellRenderer)colModel.getColumn(1).getCellRenderer();
        JTableEditable.ColorTableCellRenderer cellSrcMask = (JTableEditable.ColorTableCellRenderer)colModel.getColumn(2).getCellRenderer();
        JTableEditable.ColorTableCellRenderer cellDestIP = (JTableEditable.ColorTableCellRenderer)colModel.getColumn(3).getCellRenderer();
        JTableEditable.ColorTableCellRenderer cellDestMask = (JTableEditable.ColorTableCellRenderer)colModel.getColumn(4).getCellRenderer();
        JTableEditable.ColorTableCellRenderer cellPort = (JTableEditable.ColorTableCellRenderer)colModel.getColumn(6).getCellRenderer();
        for (int i = 0; i < this.ruleTable.getRowCount(); ++i) {
            if (EingabenUeberpruefung.isGueltig((String)this.ruleTable.getValueAt(i, 1), EingabenUeberpruefung.musterIpAdresseAuchLeer)) {
                cellSrcIP.resetColor(i, 1);
            } else {
                cellSrcIP.setColor(i, 1, EingabenUeberpruefung.farbeFalsch);
            }
            if (!((String)this.ruleTable.getValueAt(i, 1)).isEmpty()) {
                if (((String)this.ruleTable.getValueAt(i, 2)).isEmpty()) {
                    cellSrcMask.setColor(i, 2, EingabenUeberpruefung.farbeFalsch);
                } else if (!EingabenUeberpruefung.isValidSubnetmask((String)this.ruleTable.getValueAt(i, 2))) {
                    cellSrcMask.setColor(i, 2, EingabenUeberpruefung.farbeFalsch);
                } else {
                    cellSrcMask.resetColor(i, 2);
                }
            } else {
                cellSrcMask.resetColor(i, 2);
            }
            if (EingabenUeberpruefung.isGueltig((String)this.ruleTable.getValueAt(i, 3), EingabenUeberpruefung.musterIpAdresseAuchLeer)) {
                cellDestIP.resetColor(i, 3);
            } else {
                cellDestIP.setColor(i, 3, EingabenUeberpruefung.farbeFalsch);
            }
            if (!((String)this.ruleTable.getValueAt(i, 3)).isEmpty()) {
                if (((String)this.ruleTable.getValueAt(i, 4)).isEmpty()) {
                    cellDestMask.setColor(i, 4, EingabenUeberpruefung.farbeFalsch);
                } else if (!EingabenUeberpruefung.isValidSubnetmask((String)this.ruleTable.getValueAt(i, 4))) {
                    cellDestMask.setColor(i, 4, EingabenUeberpruefung.farbeFalsch);
                } else {
                    cellDestMask.resetColor(i, 4);
                }
            } else {
                cellDestMask.resetColor(i, 4);
            }
            if (EingabenUeberpruefung.isGueltig(((String)this.ruleTable.getValueAt(i, 6)).trim(), EingabenUeberpruefung.musterPortAuchLeer)) {
                cellPort.resetColor(i, 6);
                continue;
            }
            cellPort.setColor(i, 6, EingabenUeberpruefung.farbeFalsch);
        }
    }

    public void updateRuleTable() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", updateRuleTable()");
        Vector<FirewallRule> ruleset = this.firewall.getRuleset();
        DefaultTableModel model = (DefaultTableModel)this.ruleTable.getModel();
        model.setRowCount(0);
        for (int i = 0; i < ruleset.size(); ++i) {
            Main.debug.println("DEBUG Rule #" + (i + 1) + ": " + ruleset.get(i).toString());
            model.addRow(ruleset.get(i).getVector(i + 1));
        }
        this.updateCellColors();
        this.defaultPolicyCombo.setSelectedItem(this.firewall.getDefaultPolicyString());
        this.activateFirewall.setSelected(this.firewall.isActivated());
        this.dropICMP.setSelected(this.firewall.getDropICMP());
        this.onlyFilterSYN.setSelected(this.firewall.getAllowRelatedPackets());
    }

    public Firewall getFirewall() {
        return this.firewall;
    }

    public class ComboBoxTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -4372708685136408285L;
        private JComboBox cmbBox;

        public ComboBoxTableCellEditor(String[] values) {
            this.cmbBox = new JComboBox<String>(values);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
            if (isSelected) {
                this.cmbBox.setSelectedItem(value);
                TableModel model = table.getModel();
                model.setValueAt(value, rowIndex, colIndex);
            }
            return this.cmbBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.cmbBox.getSelectedItem();
        }
    }
}

