/*
 * Decompiled with CFR 0.152.
 */
package filius.software.clientserver;

import filius.Main;
import filius.exception.VerbindungsException;
import filius.rahmenprogramm.I18n;
import filius.software.clientserver.ServerAnwendung;
import filius.software.transportschicht.Socket;

public abstract class ServerMitarbeiter
extends Thread
implements I18n {
    protected ServerAnwendung server;
    protected Socket socket;
    protected boolean running = false;

    public ServerMitarbeiter(ServerAnwendung server, Socket socket) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ServerMitarbeiter), constr: ServerMitarbeiter(" + server + "," + socket + ")");
        this.server = server;
        this.socket = socket;
    }

    protected abstract void verarbeiteNachricht(String var1);

    protected void sendeNachricht(String nachricht) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ServerMitarbeiter), sendeNachricht(" + nachricht + ")");
        try {
            this.socket.senden(nachricht);
            this.server.benachrichtigeBeobachter("<<" + nachricht);
        }
        catch (Exception e) {
            this.server.benachrichtigeBeobachter(e.getMessage());
            e.printStackTrace(Main.debug);
        }
    }

    @Override
    public void run() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ServerMitarbeiter), run()");
        String nachricht = null;
        while (this.running) {
            try {
                if (this.socket.istVerbunden()) {
                    nachricht = this.socket.empfangen();
                }
                if (nachricht != null) {
                    this.server.benachrichtigeBeobachter(">>" + nachricht);
                    this.verarbeiteNachricht(nachricht);
                } else if (this.socket != null) {
                    this.socket.schliessen();
                    this.running = false;
                    this.server.benachrichtigeBeobachter(messages.getString("sw_servermitarbeiter_msg1") + " " + this.socket.holeZielIPAdresse() + ":" + this.socket.holeZielPort() + " " + messages.getString("sw_servermitarbeiter_msg2"));
                }
                nachricht = null;
            }
            catch (VerbindungsException e) {
                e.printStackTrace(Main.debug);
                this.server.benachrichtigeBeobachter(e.getMessage());
                this.socket.schliessen();
                this.running = false;
                this.server.entferneMitarbeiter(this);
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
                this.server.benachrichtigeBeobachter(e.getMessage());
                this.socket.schliessen();
                this.running = false;
                this.server.entferneMitarbeiter(this);
            }
        }
    }

    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ServerMitarbeiter), starten()");
        if (!this.running) {
            this.running = true;
            if (!this.getState().equals((Object)Thread.State.WAITING) && !this.getState().equals((Object)Thread.State.BLOCKED)) {
                this.start();
            }
        }
    }

    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ServerMitarbeiter), beenden()");
        this.running = false;
        if (this.socket != null) {
            this.socket.beenden();
        }
        if (this.getState().equals((Object)Thread.State.WAITING) || this.getState().equals((Object)Thread.State.BLOCKED)) {
            this.interrupt();
        }
    }
}

