/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.Main;
import filius.hardware.Verbindung;
import filius.software.ProtokollThread;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.ICMP;
import filius.software.vermittlungsschicht.IcmpPaket;
import java.util.LinkedList;

public class ICMPThread
extends ProtokollThread {
    private ICMP vermittlung;
    private LinkedList<IcmpPaket> rcvdPackets;

    public ICMPThread(ICMP vermittlung) {
        super(((InternetKnotenBetriebssystem)vermittlung.holeSystemSoftware()).holeEthernet().holeICMPPuffer());
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ICMPThread), constr: ICMPThread(" + vermittlung + ")");
        this.rcvdPackets = new LinkedList();
        this.vermittlung = vermittlung;
    }

    @Override
    protected void verarbeiteDatenEinheit(Object datenEinheit) {
        IcmpPaket icmpPaket = ((IcmpPaket)datenEinheit).clone();
        if (this.vermittlung.isLocalAddress(icmpPaket.getZielIp()) || this.vermittlung.isApplicableBroadcast(icmpPaket.getZielIp())) {
            if (icmpPaket.isEchoRequest()) {
                icmpPaket.decrementTtl();
                this.vermittlung.sendEchoReply(icmpPaket);
            } else {
                this.addIcmpResponse(icmpPaket);
            }
        } else {
            icmpPaket.decrementTtl();
            this.vermittlung.weiterleitenPaket(icmpPaket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIcmpResponse(IcmpPaket icmpPaket) {
        LinkedList<IcmpPaket> linkedList = this.rcvdPackets;
        synchronized (linkedList) {
            this.rcvdPackets.add(icmpPaket);
            this.rcvdPackets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetIcmpResponseQueue() {
        LinkedList<IcmpPaket> linkedList = this.rcvdPackets;
        synchronized (linkedList) {
            this.rcvdPackets.clear();
            this.rcvdPackets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcmpPaket waitForIcmpResponse() {
        IcmpPaket response = null;
        LinkedList<IcmpPaket> linkedList = this.rcvdPackets;
        synchronized (linkedList) {
            try {
                this.rcvdPackets.wait(Verbindung.holeRTT());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.rcvdPackets.size() > 0) {
                response = this.rcvdPackets.removeFirst();
            }
        }
        return response;
    }
}

