/*
 * Decompiled with CFR 0.152.
 */
package filius.software.www;

import filius.Main;
import filius.exception.VerbindungsException;
import filius.rahmenprogramm.Base64;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.ResourceUtil;
import filius.software.clientserver.ClientAnwendung;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.TCPSocket;
import filius.software.www.HTTPNachricht;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.visitors.TagFindingVisitor;

public class WebBrowser
extends ClientAnwendung
implements I18n {
    private static final int ABRUF_HTML = 1;
    private static final int ABRUF_IMG = 2;
    private LinkedList<String> bilddateien = new LinkedList();
    private int zustand;
    private String host;

    public void holeWebseite(URL url) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), holeWebseite(" + url + ")");
        this.zustand = 1;
        if (this.socket != null) {
            this.socket.schliessen();
            this.socket = null;
        }
        Object[] args = new Object[]{url, ""};
        this.ausfuehren("internHoleRessource", args);
    }

    public void holeWebseite(URL url, String post) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), holeWebseite(" + url + "," + post + ")");
        this.zustand = 1;
        if (this.socket != null) {
            this.socket.schliessen();
            this.socket = null;
        }
        Object[] args = new Object[]{url, post};
        this.ausfuehren("internHoleRessource", args);
    }

    public void internHoleRessource(URL url, String post) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), internHoleRessource(" + url + "," + post + ")");
        Socket aktuellerSocket = this.socket;
        HTTPNachricht nachricht = new HTTPNachricht(1);
        nachricht.setPfad(url.getFile());
        if (url.getHost() != null && !url.getHost().equals("")) {
            this.host = url.getHost();
        }
        nachricht.setHost(this.host);
        if (nachricht.getHost() != null && !nachricht.getHost().equals("")) {
            HTTPNachricht fehler;
            block14: {
                if (post != null && !post.equals("")) {
                    nachricht.setMethod("POST");
                    nachricht.setDaten(post);
                } else {
                    nachricht.setMethod("GET");
                }
                if (this.zustand == 1 || aktuellerSocket == null) {
                    try {
                        aktuellerSocket = this.socket = new TCPSocket(this.getSystemSoftware(), this.host, 80);
                    }
                    catch (VerbindungsException e) {
                        if (this.zustand != 1) break block14;
                        fehler = new HTTPNachricht(1);
                        fehler.setDaten(this.erzeugeHtmlFehlermeldung(0));
                        this.benachrichtigeBeobachter(fehler);
                    }
                }
            }
            if (aktuellerSocket != null && !aktuellerSocket.istVerbunden() && aktuellerSocket == this.socket) {
                try {
                    aktuellerSocket.verbinden();
                }
                catch (Exception e) {
                    if (this.zustand == 1 && aktuellerSocket == this.socket) {
                        fehler = new HTTPNachricht(1);
                        fehler.setDaten(this.erzeugeHtmlFehlermeldung(0));
                        this.benachrichtigeBeobachter(fehler);
                    }
                    e.printStackTrace(Main.debug);
                }
            }
            if (aktuellerSocket != null && aktuellerSocket.istVerbunden() && aktuellerSocket == this.socket) {
                try {
                    aktuellerSocket.senden(nachricht.toString());
                    this.verarbeiteNachricht();
                }
                catch (Exception e) {
                    e.printStackTrace(Main.debug);
                }
            }
        }
    }

    public String holeHost() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), holeHost()");
        return this.host;
    }

    @Override
    public void starten() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), starten()");
        super.starten();
        this.bilddateien = new LinkedList();
    }

    private String einlesenTextdatei(String datei) throws FileNotFoundException, IOException {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), einlesenTextdatei(" + datei + ")");
        StringBuffer fullFile = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ResourceUtil.getResourcePath(datei)), Charset.forName("UTF-8")));){
            String input;
            while ((input = reader.readLine()) != null) {
                fullFile.append(input).append("\n");
            }
        }
        return fullFile.toString();
    }

    private String erzeugeHtmlFehlermeldung(int statusCode) {
        String quelltext;
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), erzeugeHtmlFehlermeldung(" + statusCode + ")");
        if (statusCode == 0) {
            quelltext = messages.getString("sw_webbrowser_msg1");
        } else {
            String dateipfad = ResourceUtil.getResourcePath("tmpl/http_fehler_" + Information.getInformation().getLocale().toString() + ".txt");
            try {
                quelltext = this.einlesenTextdatei(dateipfad);
            }
            catch (Exception e) {
                quelltext = messages.getString("sw_webbrowser_msg2");
                e.printStackTrace(Main.debug);
            }
            quelltext = quelltext.replace(":code:", "" + statusCode);
            String meldung = HTTPNachricht.holeStatusNachricht(statusCode);
            quelltext = quelltext.replace(":meldung:", meldung);
        }
        return quelltext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verarbeiteIMGTags(String quelltext, String host) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), verarbeiteIMGTags(" + quelltext + "," + host + ")");
        this.zustand = 2;
        Parser parser = Parser.createParser(quelltext, null);
        TagFindingVisitor nodeVisitor = new TagFindingVisitor(new String[]{"img"});
        try {
            parser.visitAllNodesWith(nodeVisitor);
            Node[] nodes = nodeVisitor.getTags(0);
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof ImageTag)) continue;
                ImageTag img = (ImageTag)nodes[i];
                LinkedList<String> linkedList = this.bilddateien;
                synchronized (linkedList) {
                    this.bilddateien.add(img.getImageURL());
                    continue;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
        }
        LinkedList<String> linkedList = this.bilddateien;
        synchronized (linkedList) {
            for (String dateipfad : this.bilddateien) {
                try {
                    URL url = new URL("http", host, dateipfad);
                    Object[] args = new Object[]{url, ""};
                    this.ausfuehren("internHoleRessource", args);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace(Main.debug);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verarbeiteNachricht() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (WebBrowser), verarbeiteNachricht()");
        String nachricht = null;
        Socket aktuellerSocket = this.socket;
        try {
            nachricht = aktuellerSocket.empfangen();
        }
        catch (Exception e) {
            nachricht = null;
        }
        if (nachricht != null) {
            HTTPNachricht antwort = new HTTPNachricht(nachricht);
            if (antwort.getStatusCode() == 200) {
                String contentType = antwort.getContentType();
                if (contentType == null) {
                    antwort.setDaten("");
                } else if (contentType.equalsIgnoreCase("text/html") && antwort.getDaten() != null) {
                    this.verarbeiteIMGTags(antwort.getDaten(), antwort.getHost());
                } else if (contentType.equalsIgnoreCase("image/bmp") || contentType.equalsIgnoreCase("image/gif") || contentType.equalsIgnoreCase("image/jpg") || contentType.equalsIgnoreCase("image/png")) {
                    LinkedList<String> linkedList = this.bilddateien;
                    synchronized (linkedList) {
                        if (this.bilddateien.size() > 0) {
                            String dateipfad = this.bilddateien.removeFirst();
                            Base64.decodeToFile(antwort.getDaten(), Information.getInformation().getTempPfad() + dateipfad);
                        }
                    }
                    antwort = null;
                }
            } else if (this.zustand == 1 && aktuellerSocket == this.socket) {
                antwort.setDaten(this.erzeugeHtmlFehlermeldung(antwort.getStatusCode()));
            } else {
                antwort = null;
            }
            if (aktuellerSocket == this.socket) {
                this.benachrichtigeBeobachter(antwort);
            }
        } else if (this.zustand == 1 && aktuellerSocket == this.socket) {
            HTTPNachricht antwort = new HTTPNachricht(1);
            antwort.setDaten(this.erzeugeHtmlFehlermeldung(0));
            this.benachrichtigeBeobachter(antwort);
        }
        if ((this.bilddateien == null || this.bilddateien.size() == 0) && aktuellerSocket == this.socket && this.socket != null) {
            this.socket.schliessen();
            this.socket = null;
        }
    }
}

